/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.ActiveConnection;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdTyped;
import alexiil.mc.lib.net.ParentNetIdSingle;

final class ResolvedNetId<T>
extends NetIdTyped<T> {
    final NetIdTyped<?> wrapped;

    public ResolvedNetId(ParentNetIdSingle<T> parent, NetIdTyped<?> wrapped) {
        super(parent, wrapped.name, wrapped.length);
        this.wrapped = wrapped;
        this.changeFlag(wrapped.getFinalFlags());
    }

    @Override
    protected void receive(NetByteBuf buffer, IMsgReadCtx ctx, T obj) throws InvalidInputDataException {
        ResolvedNetId.receive0(buffer, ctx, obj, this.wrapped);
    }

    @Override
    public void send(ActiveConnection connection, T obj) {
        throw new IllegalStateException("You can never write out a Resolved Net ID!\n(How did you even call this anyway? This is meant to be an internal class!)");
    }

    private static <U> void receive0(NetByteBuf buffer, IMsgReadCtx ctx, Object obj, NetIdTyped<U> wrapped) throws InvalidInputDataException {
        wrapped.receive(buffer, ctx, wrapped.parent.clazz.cast(obj));
    }

    @Override
    public ResolvedNetId<T> withoutBuffering() {
        this.notBuffered();
        return this;
    }

    @Override
    public ResolvedNetId<T> withTinySize() {
        this.setTinySize();
        return this;
    }

    @Override
    public ResolvedNetId<T> withNormalSize() {
        this.setNormalSize();
        return this;
    }

    @Override
    public ResolvedNetId<T> withLargeSize() {
        this.setLargeSize();
        return this;
    }

    @Override
    public ResolvedNetId<T> toClientOnly() {
        this._toClientOnly();
        return this;
    }

    @Override
    public ResolvedNetId<T> toServerOnly() {
        this._toServerOnly();
        return this;
    }

    @Override
    public ResolvedNetId<T> toEitherSide() {
        this._toEitherSide();
        return this;
    }
}

