/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.ActiveConnection;
import alexiil.mc.lib.net.CheckingNetByteBuf;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InternalMsgUtil;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdDataK;
import alexiil.mc.lib.net.NetIdPath;
import alexiil.mc.lib.net.NetIdSignalK;
import alexiil.mc.lib.net.NetIdTyped;
import alexiil.mc.lib.net.ParentDynamicNetId;
import alexiil.mc.lib.net.ParentNetId;
import alexiil.mc.lib.net.ParentNetIdBase;
import alexiil.mc.lib.net.ParentNetIdCast;
import alexiil.mc.lib.net.ParentNetIdDuel;
import alexiil.mc.lib.net.ParentNetIdDuelDirect;
import alexiil.mc.lib.net.ParentNetIdExtractor;
import alexiil.mc.lib.net.TreeNetIdBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class ParentNetIdSingle<T>
extends ParentNetIdBase {
    public final Class<T> clazz;
    final Map<String, NetIdTyped<T>> leafChildren = new HashMap<String, NetIdTyped<T>>();
    final Map<String, ParentNetIdDuel<T, ?>> branchChildren = new HashMap();

    ParentNetIdSingle(ParentNetIdBase parent, Class<T> clazz, String name, int thisLength) {
        super(parent, name, thisLength);
        this.clazz = clazz;
    }

    public ParentNetIdSingle(ParentNetId parent, Class<T> clazz, String name, int thisLength) {
        super(parent, name, thisLength);
        this.clazz = clazz;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    void addChild(NetIdTyped<T> netId) {
        if (this instanceof ParentDynamicNetId) {
            throw new IllegalArgumentException("ParentDynamicNetId can only have 1 child!");
        }
        if (this.leafChildren.containsKey(netId.name) || this.branchChildren.containsKey(netId.name)) {
            throw new IllegalStateException("There is already a child with the name " + netId.name + "!");
        }
        this.leafChildren.put(netId.name, netId);
    }

    void addChild(ParentNetIdDuel<T, ?> netId) {
        if (this instanceof ParentDynamicNetId) {
            throw new IllegalArgumentException("ParentDynamicNetId can only have 1 child!");
        }
        if (this.leafChildren.containsKey(netId.name) || this.branchChildren.containsKey(netId.name)) {
            throw new IllegalStateException("There is already a child with the name " + netId.name + "!");
        }
        this.branchChildren.put(netId.name, netId);
    }

    @Override
    TreeNetIdBase getChild(String childName) {
        NetIdTyped<T> leaf = this.leafChildren.get(childName);
        return leaf != null ? leaf : (TreeNetIdBase)this.branchChildren.get(childName);
    }

    @Override
    protected String getPrintableName() {
        return this.getRealClassName() + "<" + this.clazz.getSimpleName() + ">";
    }

    public NetIdDataK<T> idData(String name) {
        return new NetIdDataK(this, name, -1);
    }

    public NetIdDataK<T> idData(String name, int dataLength) {
        return new NetIdDataK(this, name, dataLength);
    }

    public NetIdSignalK<T> idSignal(String name) {
        return new NetIdSignalK(this, name);
    }

    public <U extends T> ParentNetIdCast<T, U> subType(Class<U> subClass, String subName) {
        return new ParentNetIdCast(this, subName, subClass);
    }

    public <U> ParentNetIdExtractor<T, U> extractor(Class<U> targetClass, String subName, Function<U, T> forward, Function<T, U> backward) {
        return new ParentNetIdExtractor<T, U>(this, subName, targetClass, forward, backward);
    }

    public ParentNetIdSingle<T> child(String name) {
        return new ParentNetIdDuelDirect(this, name);
    }

    protected abstract T readContext(NetByteBuf var1, IMsgReadCtx var2) throws InvalidInputDataException;

    protected abstract void writeContext(NetByteBuf var1, IMsgWriteCtx var2, T var3);

    T readContextCall(CheckingNetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        buffer.readMarkerId(ctx, this);
        return this.readContext(buffer, ctx);
    }

    void writeContextCall(CheckingNetByteBuf buffer, IMsgWriteCtx ctx, T value) {
        if (buffer.hasTypeData()) {
            buffer.writeMarkerId(InternalMsgUtil.getWriteId(ctx.getConnection(), this, this.path));
        }
        this.writeContext(buffer, ctx, value);
    }

    protected void writeDynamicContext(CheckingNetByteBuf buffer, IMsgWriteCtx ctx, T value, List<TreeNetIdBase> resolvedPath) {
        this.writeContextCall(buffer, ctx, value);
        Collections.addAll(resolvedPath, this.path.array);
    }

    public final void writeKey(CheckingNetByteBuf buffer, IMsgWriteCtx ctx, T value) {
        if (this.pathContainsDynamicParent) {
            int wIndex = buffer.writerIndex();
            buffer.writeInt(0);
            ArrayList<TreeNetIdBase> nPath = new ArrayList<TreeNetIdBase>();
            this.writeDynamicContext(buffer, ctx, value, nPath);
            nPath.add(this);
            TreeNetIdBase[] array = nPath.toArray(new TreeNetIdBase[0]);
            NetIdPath resolvedPath = new NetIdPath(array);
            buffer.setInt(wIndex, InternalMsgUtil.getWriteId(ctx.getConnection(), this, resolvedPath));
        } else {
            this.writeContext(buffer, ctx, value);
        }
    }

    public final T readKey(CheckingNetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        if (!this.pathContainsDynamicParent) {
            return this.readContext(buffer, ctx);
        }
        ActiveConnection connection = ctx.getConnection();
        int pathId = buffer.readInt();
        if (pathId < 0 || pathId >= connection.readMapIds.size()) {
            throw new InvalidInputDataException("Unknown/invalid ID " + pathId);
        }
        TreeNetIdBase readId = connection.readMapIds.get(pathId);
        if (!(readId instanceof ParentNetIdSingle)) {
            throw new InvalidInputDataException("Not a receiving node: " + readId + " for id " + pathId);
        }
        ParentNetIdSingle op = (ParentNetIdSingle)readId;
        T read = op.readContext(buffer, ctx);
        if (!this.clazz.isInstance(read)) {
            throw new InvalidInputDataException("The id sent to us (" + pathId + ") was for a node of a different class! (" + op + ")");
        }
        return this.clazz.cast(read);
    }
}

