/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.CheckingNetByteBuf;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InternalMsgUtil;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdPath;
import alexiil.mc.lib.net.ParentDynamicNetId;
import alexiil.mc.lib.net.ParentNetIdSingle;
import alexiil.mc.lib.net.ResolvedDynamicNetId;
import alexiil.mc.lib.net.ResolvedParentNetId;
import alexiil.mc.lib.net.TreeNetIdBase;
import java.util.List;

public abstract class ParentNetIdDuel<Parent, T>
extends ParentNetIdSingle<T> {
    public final ParentNetIdSingle<Parent> parent;

    public ParentNetIdDuel(ParentNetIdSingle<Parent> parent, String name, Class<T> clazz, int length) {
        super(parent, clazz, name, length);
        this.parent = parent;
        if (!(this instanceof ResolvedParentNetId) && !(this instanceof ResolvedDynamicNetId)) {
            parent.addChild(this);
        }
    }

    public ParentNetIdDuel(ParentNetIdSingle<Parent> parent, String name, Class<T> clazz) {
        this(parent, name, clazz, -1);
    }

    @Override
    protected String getPrintableName() {
        return this.getRealClassName() + "<" + this.parent.clazz.getSimpleName() + ", " + this.clazz.getSimpleName() + ">";
    }

    @Override
    protected final void writeContext(NetByteBuf buffer, IMsgWriteCtx ctx, T value) {
        this.writeContext0(buffer, ctx, value);
    }

    @Override
    final void writeContextCall(CheckingNetByteBuf buffer, IMsgWriteCtx ctx, T value) {
        this.parent.writeContextCall(buffer, ctx, this.extractParent(value));
        super.writeContextCall(buffer, ctx, value);
    }

    @Override
    protected void writeDynamicContext(CheckingNetByteBuf buffer, IMsgWriteCtx ctx, T value, List<TreeNetIdBase> resolvedPath) {
        this.parent.writeDynamicContext(buffer, ctx, this.extractParent(value), resolvedPath);
        resolvedPath.add(this);
        if (buffer.hasTypeData()) {
            buffer.writeMarkerId(InternalMsgUtil.getWriteId(ctx.getConnection(), this, new NetIdPath(resolvedPath)));
        }
        this.writeContext0(buffer, ctx, value);
    }

    protected abstract Parent extractParent(T var1);

    protected abstract void writeContext0(NetByteBuf var1, IMsgWriteCtx var2, T var3);

    @Override
    protected final T readContext(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        throw new UnsupportedOperationException("Call readContextCall instead!");
    }

    @Override
    final T readContextCall(CheckingNetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        Parent p = this.parent.readContextCall(buffer, ctx);
        if (p == null) {
            return null;
        }
        if (!(this instanceof ParentDynamicNetId) && !(this instanceof ResolvedDynamicNetId)) {
            buffer.readMarkerId(ctx, this);
        }
        return this.readContext(buffer, ctx, p);
    }

    protected abstract T readContext(NetByteBuf var1, IMsgReadCtx var2, Parent var3) throws InvalidInputDataException;
}

