/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.CheckingNetByteBuf;
import alexiil.mc.lib.net.DynamicNetId;
import alexiil.mc.lib.net.DynamicNetLink;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.ParentNetIdDuel;
import alexiil.mc.lib.net.ParentNetIdSingle;
import alexiil.mc.lib.net.TreeNetIdBase;
import java.util.List;
import java.util.function.Function;

public final class ParentDynamicNetId<P, C>
extends ParentNetIdDuel<P, C> {
    public final DynamicNetId<C> childId;
    private final Function<P, C> childGetter;

    public ParentDynamicNetId(ParentNetIdSingle<P> parent, String name, DynamicNetId<C> childId, Function<P, C> childGetter) {
        super(parent, name, childId.clazz);
        this.childId = childId;
        this.childGetter = childGetter;
    }

    @Override
    TreeNetIdBase getChild(String childName) {
        if (childName.equals(this.childId.name)) {
            return this.childId;
        }
        return null;
    }

    @Override
    protected P extractParent(C value) {
        throw new IllegalStateException("Dynamic Net ID's must be written with the dynamic variant!");
    }

    @Override
    protected void writeContext0(NetByteBuf buffer, IMsgWriteCtx ctx, C value) {
        throw new IllegalStateException("Dynamic Net ID's must be written with the dynamic variant!");
    }

    @Override
    public void writeDynamicContext(CheckingNetByteBuf buffer, IMsgWriteCtx ctx, C value, List<TreeNetIdBase> resolvedPath) {
        throw new IllegalStateException("This should never be called by DynamicNetId!");
    }

    @Override
    protected C readContext(NetByteBuf buffer, IMsgReadCtx ctx, P parentValue) throws InvalidInputDataException {
        return this.childGetter.apply(parentValue);
    }

    public DynamicNetLink<P, C> link(P parent, C child) {
        return new DynamicNetLink<P, C>(this, parent, child);
    }

    public DynamicNetLink.IDynamicLinkFactory<C> linkFactory(P parent) {
        return child -> this.link(parent, child);
    }
}

