/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.ActiveConnection;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.LibNetworkStack;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdData;
import alexiil.mc.lib.net.NetObjectCacheBase;
import alexiil.mc.lib.net.ParentNetId;
import it.unimi.dsi.fastutil.Hash;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_2960;

public final class NetObjectCache<T>
extends NetObjectCacheBase<T> {
    static final boolean DEBUG = LibNetworkStack.DEBUG || Boolean.getBoolean("libnetworkstack.cache.debug");
    private final ParentNetId netIdParent;
    private final NetIdData netIdPutCacheEntry;
    private final NetIdData netIdRemoveCacheEntry;

    public NetObjectCache(ParentNetId parent, Hash.Strategy<T> equality, IEntrySerialiser<T> serialiser) {
        super(equality, serialiser);
        this.netIdParent = parent;
        this.netIdPutCacheEntry = this.netIdParent.idData("put").setReceiver(this::receivePutCacheEntry);
        this.netIdRemoveCacheEntry = this.netIdParent.idData("remove").setReceiver(this::receiveRemoveCacheEntry);
    }

    public void notBuffered() {
        this.netIdPutCacheEntry.notBuffered();
        this.netIdRemoveCacheEntry.notBuffered();
    }

    public static <T> NetObjectCache<T> createMappedIdentifier(ParentNetId parent, final Function<T, class_2960> nameGetter, final Function<class_2960, T> objectGetter) {
        return new NetObjectCache<T>(parent, new Hash.Strategy<T>(){

            public int hashCode(T o) {
                return o == null ? 0 : ((class_2960)nameGetter.apply(o)).hashCode();
            }

            public boolean equals(T a, T b) {
                if (a == null || b == null) {
                    return a == b;
                }
                return Objects.equals(nameGetter.apply(a), nameGetter.apply(b));
            }
        }, new IEntrySerialiser<T>(){

            @Override
            public void write(T obj, ActiveConnection connection, NetByteBuf buffer) {
                buffer.writeIdentifier((class_2960)nameGetter.apply(obj));
            }

            @Override
            public T read(ActiveConnection connection, NetByteBuf buffer) throws InvalidInputDataException {
                class_2960 id = buffer.readIdentifierSafe();
                if (id == null) {
                    return null;
                }
                return objectGetter.apply(id);
            }
        });
    }

    public static <T> NetObjectCache<T> createMappedIdentifier(ParentNetId parent, Function<T, class_2960> nameGetter, Map<class_2960, T> map) {
        return NetObjectCache.createMappedIdentifier(parent, nameGetter, map::get);
    }

    private void receivePutCacheEntry(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        int id = buffer.readInt();
        Object obj = this.serialiser.read(ctx.getConnection(), buffer);
        if (DEBUG) {
            LibNetworkStack.LOGGER.info("[cache] " + ctx.getConnection() + " " + this.netIdParent + " Read new ID " + id + " for object " + obj);
        }
        this.getData((ActiveConnection)ctx.getConnection()).idToObj.put(id, obj);
    }

    private void receiveRemoveCacheEntry(NetByteBuf buffer, IMsgReadCtx ctx) {
    }

    @Override
    NetObjectCacheBase.Data newData(ActiveConnection connection) {
        if (DEBUG) {
            LibNetworkStack.LOGGER.info("[cache] " + connection + " " + this.netIdParent + " Created a new cache.");
        }
        return super.newData(connection);
    }

    public int getId(ActiveConnection connection, T obj) {
        NetObjectCacheBase.Data data = this.getData(connection);
        int id = data.objToId.getInt(obj);
        if (id < 0) {
            id = data.objToId.size();
            data.objToId.put(obj, id);
            int i = id;
            if (DEBUG) {
                LibNetworkStack.LOGGER.info("[cache] " + connection + " " + this.netIdParent + " Sending new ID " + i + " for object " + obj);
            }
            this.netIdPutCacheEntry.send(connection, (buffer, ctx) -> {
                buffer.writeInt(i);
                this.serialiser.write(obj, connection, buffer);
            });
        }
        return id;
    }

    @Nullable
    public T getObj(ActiveConnection connection, int id) {
        NetObjectCacheBase.Data data = this.getData(connection);
        if (DEBUG && !data.idToObj.containsKey(id)) {
            LibNetworkStack.LOGGER.info("[cache] " + connection + " " + this.netIdParent + " Unknown ID " + id + "!");
        }
        return (T)data.idToObj.get(id);
    }

    public static interface IEntrySerialiser<T> {
        public void write(T var1, ActiveConnection var2, NetByteBuf var3);

        public T read(ActiveConnection var1, NetByteBuf var2) throws InvalidInputDataException;
    }
}

