/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.TreeNetIdBase;
import java.util.Arrays;
import java.util.List;

final class NetIdPath {
    private static final NetIdPath EMPTY = new NetIdPath(new TreeNetIdBase[0]);
    final TreeNetIdBase[] array;
    final int hash;

    NetIdPath(TreeNetIdBase[] array) {
        this.array = array;
        this.hash = Arrays.hashCode(array);
    }

    NetIdPath(TreeNetIdBase single) {
        this(new TreeNetIdBase[]{single});
    }

    NetIdPath(List<? extends TreeNetIdBase> list) {
        this(list.toArray(new TreeNetIdBase[0]));
    }

    public String toString() {
        if (this.array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.array[0].name);
        for (int i = 1; i < this.array.length; ++i) {
            TreeNetIdBase id = this.array[i];
            sb.append(".");
            sb.append(id.name);
        }
        return sb.toString();
    }

    NetIdPath parent() {
        if (this.array.length <= 1) {
            return EMPTY;
        }
        return new NetIdPath(Arrays.copyOfRange(this.array, 0, this.array.length - 1));
    }

    NetIdPath withChild(TreeNetIdBase child) {
        TreeNetIdBase[] arr = Arrays.copyOf(this.array, this.array.length + 1);
        arr[this.array.length] = child;
        return new NetIdPath(arr);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof NetIdPath) {
            NetIdPath other = (NetIdPath)obj;
            if (this.hash != other.hash || this.array.length != other.array.length) {
                return false;
            }
            for (int i = this.array.length - 1; i >= 0; --i) {
                if (this.array[i] == other.array[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    int calculateLength() {
        int len = 0;
        for (TreeNetIdBase id : this.array) {
            if (id.length == -1) {
                return -1;
            }
            len += id.length;
        }
        return len;
    }
}

