/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.ActiveConnection;
import alexiil.mc.lib.net.CheckingNetByteBuf;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InternalMsgUtil;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.LibNetworkStack;
import alexiil.mc.lib.net.MessageContext;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdPath;
import alexiil.mc.lib.net.NetIdTyped;
import alexiil.mc.lib.net.ParentNetIdSingle;
import alexiil.mc.lib.net.TreeNetIdBase;
import java.util.ArrayList;

public final class NetIdDataK<T>
extends NetIdTyped<T> {
    private IMsgDataReceiverK<T> receiver = (t, buffer, ctx) -> {
        throw new InvalidInputDataException("No receiver set for " + ctx.getNetSide());
    };
    private IMsgDataWriterK<T> writer;

    public NetIdDataK(ParentNetIdSingle<T> parent, String name, int length) {
        super(parent, name, length);
    }

    public NetIdDataK<T> setReceiver(IMsgDataReceiverK<T> receiver) {
        this.receiver = receiver;
        return this;
    }

    public NetIdDataK<T> setReadWrite(IMsgDataReceiverK<T> receiver, IMsgDataWriterK<T> writer) {
        this.receiver = receiver;
        this.writer = writer;
        return this;
    }

    @Override
    public void receive(NetByteBuf buffer, IMsgReadCtx ctx, T parentValue) throws InvalidInputDataException {
        this.receiver.receive(parentValue, buffer, ctx);
    }

    @Override
    public void send(ActiveConnection connection, T obj) {
        this.send(connection, obj, this.writer);
    }

    public void send(ActiveConnection connection, T obj, IMsgDataWriterK<T> writer) {
        NetIdPath resolvedPath;
        MessageContext.Write ctx = new MessageContext.Write(connection, this);
        this.validateSendingSide(ctx);
        NetByteBuf buffer = this.hasFixedLength() ? connection.allocBuffer(this.totalLength) : connection.allocBuffer();
        NetByteBuf bufferTypes = connection.sendTypes ? NetByteBuf.buffer() : null;
        CheckingNetByteBuf checkingBuffer = new CheckingNetByteBuf(buffer, bufferTypes);
        if (this.parent.pathContainsDynamicParent) {
            ArrayList<TreeNetIdBase> nPath = new ArrayList<TreeNetIdBase>();
            this.parent.writeDynamicContext(checkingBuffer, ctx, obj, nPath);
            nPath.add(this);
            resolvedPath = new NetIdPath(nPath);
        } else {
            this.parent.writeContextCall(checkingBuffer, ctx, obj);
            resolvedPath = this.path;
        }
        if (checkingBuffer.hasTypeData()) {
            int thisId = InternalMsgUtil.getWriteId(connection, this, resolvedPath);
            checkingBuffer.writeMarkerId(thisId);
        }
        int headerLength = checkingBuffer.writerIndex();
        int headerBitLength = checkingBuffer.getBitWriterIndex();
        writer.write(obj, checkingBuffer, ctx);
        if (headerLength != checkingBuffer.writerIndex() || headerBitLength != checkingBuffer.getBitWriterIndex()) {
            if (bufferTypes != null) {
                InternalMsgUtil.sendNextTypes(connection, bufferTypes, checkingBuffer.getCountWrite());
            }
            if (LibNetworkStack.CONFIG_RECORD_STACKTRACES && connection.sendStacktraces) {
                InternalMsgUtil.createAndSendDebugThrowable(connection, ctx);
            }
            InternalMsgUtil.send(connection, this, resolvedPath, buffer);
        }
        buffer.release();
    }

    @Override
    public NetIdDataK<T> withoutBuffering() {
        this.notBuffered();
        return this;
    }

    @Override
    public NetIdDataK<T> withTinySize() {
        this.setTinySize();
        return this;
    }

    @Override
    public NetIdDataK<T> withNormalSize() {
        this.setNormalSize();
        return this;
    }

    @Override
    public NetIdDataK<T> withLargeSize() {
        this.setLargeSize();
        return this;
    }

    @Override
    public NetIdDataK<T> toClientOnly() {
        this._toClientOnly();
        return this;
    }

    @Override
    public NetIdDataK<T> toServerOnly() {
        this._toServerOnly();
        return this;
    }

    @Override
    public NetIdDataK<T> toEitherSide() {
        this._toEitherSide();
        return this;
    }

    @FunctionalInterface
    public static interface IMsgDataReceiverK<T> {
        public void receive(T var1, NetByteBuf var2, IMsgReadCtx var3) throws InvalidInputDataException;
    }

    @FunctionalInterface
    public static interface IMsgDataWriterK<T> {
        public void write(T var1, NetByteBuf var2, IMsgWriteCtx var3);
    }
}

