/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.LibNetworkStack;
import alexiil.mc.lib.net.NetByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.StringUtil;
import java.nio.charset.StandardCharsets;

public final class MsgUtil {
    private MsgUtil() {
    }

    public static void writeUTF(NetByteBuf buffer, String string) {
        byte[] data = string.getBytes(StandardCharsets.UTF_8);
        if (data.length > 65535) {
            throw new IllegalArgumentException("Cannot write a string with more than 65535 bytes!");
        }
        buffer.writeShort(data.length);
        buffer.writeBytes(data);
    }

    public static String readUTF(NetByteBuf buffer) {
        int len = buffer.readUnsignedShort();
        byte[] data = new byte[len];
        buffer.readBytes(data);
        return new String(data, StandardCharsets.UTF_8);
    }

    public static void ensureEmpty(ByteBuf buf, boolean throwError, String extra) throws InvalidInputDataException {
        int readableBytes;
        int rb = readableBytes = buf.readableBytes();
        if (buf instanceof NetByteBuf) {
            // empty if block
        }
        if (readableBytes > 0) {
            int ri = buf.readerIndex();
            ByteBuf dst = Unpooled.buffer();
            buf.getBytes(0, dst, buf.writerIndex());
            String summary = MsgUtil.formatPacketSelection(dst, dst.readableBytes(), ri);
            IllegalStateException ex = new IllegalStateException("Did not fully read the data! [" + extra + "]\n" + summary + " --" + rb);
            if (throwError) {
                throw ex;
            }
            LibNetworkStack.LOGGER.warn((Object)ex);
            buf.clear();
        }
    }

    public static void printWholeBuffer(ByteBuf buf) {
        int readerIndex = buf.readerIndex();
        ByteBuf dst = Unpooled.buffer();
        buf.getBytes(0, dst, buf.writerIndex());
        LibNetworkStack.LOGGER.info("  " + MsgUtil.formatPacketSelection(dst, dst.readableBytes(), readerIndex));
    }

    private static String formatPacketSelection(ByteBuf buffer, int length, int readerIndex) {
        StringBuilder sb = new StringBuilder();
        MsgUtil.appendBufferData(buffer, length, sb, "", readerIndex);
        return sb.toString();
    }

    public static void appendBufferData(ByteBuf buffer, int length, StringBuilder sb, String linePrefix, int readerIndex) {
        MsgUtil.appendBufferData(buffer, 0, length, sb, linePrefix, readerIndex);
    }

    public static void appendBufferData(ByteBuf buffer, int offset, int length, StringBuilder sb, String linePrefix, int readerIndex) {
        int to;
        int from;
        linePrefix = "\n" + (String)linePrefix;
        int i = 0;
        while ((from = i * 20) < (to = Math.min(from + 20, length))) {
            int j;
            if (i > 0) {
                sb.append((String)linePrefix);
            }
            for (int j2 = from; j2 < to; ++j2) {
                byte b = buffer.getByte(j2 + offset);
                sb.append(StringUtil.byteToHexStringPadded((int)b));
                if (j2 + 1 == readerIndex) {
                    sb.append('#');
                    continue;
                }
                sb.append(' ');
            }
            int leftOver = from - to + 20;
            for (j = 0; j < leftOver; ++j) {
                sb.append("   ");
            }
            sb.append("| ");
            for (j = from; j < to; ++j) {
                byte b = buffer.getByte(j + offset);
                char c = (char)b;
                if (c < ' ' || c > '\u007f') {
                    c = ' ';
                }
                sb.append(c);
            }
            ++i;
        }
    }
}

