/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.impl.CoreMinecraftNetUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LibNetworkStack
implements ModInitializer {
    public static final String MODID = "libnetworkstack";
    public static final boolean DEBUG;
    public static final Logger LOGGER;
    public static final String CONFIG_FILE_LOCATION;
    public static final boolean CONFIG_RECORD_TYPES;
    public static final boolean CONFIG_RECORD_STACKTRACES;

    public void onInitialize() {
        CoreMinecraftNetUtil.load();
    }

    static {
        String fileLoc;
        LOGGER = LogManager.getLogger((String)"LibNetworkStack");
        boolean debug = Boolean.getBoolean("libnetworkstack.debug");
        FabricLoader fabric = FabricLoader.getInstance();
        File cfgDir = fabric.getGameDir() == null ? new File("config") : fabric.getConfigDirectory();
        if (!cfgDir.isDirectory()) {
            cfgDir.mkdirs();
        }
        File cfgFile = new File(cfgDir, "libnetworkstack.txt");
        try {
            fileLoc = cfgFile.getCanonicalPath();
        }
        catch (IOException io) {
            fileLoc = cfgFile.getAbsolutePath();
            LOGGER.warn("[config] Failed to get the canonical location of " + cfgFile, (Throwable)io);
        }
        CONFIG_FILE_LOCATION = fileLoc;
        Properties props = new Properties();
        boolean didFileExist = cfgFile.exists();
        if (didFileExist) {
            try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(cfgFile), StandardCharsets.UTF_8);){
                props.load(isr);
            }
            catch (IOException e) {
                LOGGER.error("[config] Failed to read the config file!", (Throwable)e);
            }
        }
        boolean hasAll = true;
        boolean forceEnabled = FabricLoader.getInstance().isModLoaded("network-drain-cleaner");
        hasAll &= props.containsKey("debug.log");
        DEBUG = debug |= "true".equalsIgnoreCase(props.getProperty("debug.log", "false"));
        hasAll &= props.containsKey("debug.record_types");
        CONFIG_RECORD_TYPES = forceEnabled || "true".equalsIgnoreCase(props.getProperty("debug.record_types", "false"));
        boolean bl = CONFIG_RECORD_STACKTRACES = forceEnabled || "true".equalsIgnoreCase(props.getProperty("debug.record_stacktraces", "false"));
        if (!(hasAll &= props.containsKey("debug.record_stacktraces"))) {
            try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile, true), StandardCharsets.UTF_8);){
                if (!didFileExist) {
                    ((Writer)fw).append("# LibNetworkStack configuration file.\n");
                    ((Writer)fw).append("# Removing an option will reset it back to the default value.\n");
                    ((Writer)fw).append("# Removing or altering comments doesn't replace them.\n\n");
                }
                if (!props.containsKey("debug.log")) {
                    ((Writer)fw).append("# True to enable all debug logging.\n");
                    ((Writer)fw).append("debug.log=false\n\n");
                }
                if (!props.containsKey("debug.record_types")) {
                    ((Writer)fw).append("# True to enable recording type information when writing packets\n");
                    ((Writer)fw).append("# (which is used when an exception is thrown while reading packets)\n");
                    ((Writer)fw).append("debug.record_types=false\n\n");
                }
                if (!props.containsKey("debug.record_stacktraces")) {
                    ((Writer)fw).append("# True to enable recording stacktraces when writing packets\n");
                    ((Writer)fw).append("# (which is used when an exception is thrown while reading packets)\n");
                    ((Writer)fw).append("# Unlike 'debug.record_types' this adds quite a lot of overhead,\n");
                    ((Writer)fw).append("# so should only be used when absolutely necessary.\n");
                    ((Writer)fw).append("debug.record_stacktraces=false\n\n");
                }
            }
            catch (IOException e) {
                LOGGER.warn("[config] Failed to write the config file!", (Throwable)e);
            }
        }
    }
}

