/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.ActiveConnection;
import alexiil.mc.lib.net.BufferedConnection;
import alexiil.mc.lib.net.CheckingNetByteBuf;
import alexiil.mc.lib.net.DynamicNetId;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.LibNetworkStack;
import alexiil.mc.lib.net.MessageContext;
import alexiil.mc.lib.net.MsgUtil;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdBase;
import alexiil.mc.lib.net.NetIdPath;
import alexiil.mc.lib.net.NetIdTyped;
import alexiil.mc.lib.net.ParentDynamicNetId;
import alexiil.mc.lib.net.ParentNetIdBase;
import alexiil.mc.lib.net.ParentNetIdDuel;
import alexiil.mc.lib.net.ParentNetIdSingle;
import alexiil.mc.lib.net.ResolvedDynamicNetId;
import alexiil.mc.lib.net.ResolvedNetId;
import alexiil.mc.lib.net.ResolvedParentNetId;
import alexiil.mc.lib.net.TreeNetIdBase;
import alexiil.mc.lib.net.mixin.api.IThreadedAnvilChunkStorageMixin;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.CodecException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3898;

public class InternalMsgUtil {
    private static final boolean DEBUG = LibNetworkStack.DEBUG;
    public static final int ID_INTERNAL_ALLOCATE_STATIC = 0;
    public static final int ID_INTERNAL_NEW_BANDWIDTH = 1;
    public static final int ID_INTERNAL_ALLOCATE_STACKTRACE_ELEMENT = 2;
    public static final int ID_INTERNAL_DEBUG_TYPES = 5;
    public static final int ID_INTERNAL_DEBUG_STACKTRACE = 6;
    public static final int ID_INTERNAL_REQUEST_DEBUG_TYPES = 7;
    public static final int ID_INTERNAL_REQUEST_STACKTRACES = 8;
    public static final int COUNT_HARDCODED_IDS = 9;
    private static final Method STACK_TRACE_ELEMENT_MODULE_NAME;

    public static void onReceive(ActiveConnection connection, NetByteBuf buffer) throws InvalidInputDataException {
        int id = buffer.readVarUnsignedInt();
        switch (id) {
            case 0: {
                ParentNetIdBase p;
                boolean isParent;
                int parent = buffer.readVarUnsignedInt();
                int newId = buffer.readVarUnsignedInt();
                int flags = buffer.readInt();
                boolean bl = isParent = (flags & 4) != 0;
                int len = isParent ? -2 : ((flags & 3) == 0 ? buffer.readUnsignedMedium() : -1);
                short textLen = buffer.readUnsignedByte();
                byte[] textData = new byte[textLen];
                buffer.readBytes(textData);
                String str = new String(textData, StandardCharsets.UTF_8);
                if (parent == 0) {
                    p = connection.rootId;
                } else {
                    TreeNetIdBase cId = connection.readMapIds.get(parent);
                    if (!(cId instanceof ParentNetIdBase)) {
                        throw new InvalidInputDataException("Not a valid parent: " + cId.fullName);
                    }
                    p = (ParentNetIdBase)cId;
                }
                TreeNetIdBase childId = p instanceof ResolvedParentNetId ? InternalMsgUtil.resolveChild((ResolvedParentNetId)p, str) : (p instanceof ParentDynamicNetId ? InternalMsgUtil.resolveChild((ParentDynamicNetId)p, str) : (p instanceof ResolvedDynamicNetId ? InternalMsgUtil.resolveChild((ResolvedDynamicNetId)p, str) : p.getChild(str)));
                if (childId == null) {
                    throw new InvalidInputDataException("Unknown child " + str + " of parent " + p.fullName);
                }
                if (DEBUG) {
                    LibNetworkStack.LOGGER.info(connection + " Received new id " + newId + " as " + childId + " '(flags " + Integer.toBinaryString(flags) + ", len = " + InternalMsgUtil.lenToString(len) + ")");
                }
                if (connection.readMapIds.size() != newId) {
                    throw new InvalidInputDataException("Invalid new ID! We must have gotton out of sync somehow...");
                }
                connection.readMapIds.add(childId);
                if (childId.getLengthForPacketAlloc() == len) break;
                throw new InvalidInputDataException("Mismatched length! We expect " + InternalMsgUtil.lenToString(childId.getLengthForPacketAlloc()) + ", but we received " + InternalMsgUtil.lenToString(len));
            }
            case 1: {
                int maximum = buffer.readUnsignedShort();
                if (!(connection instanceof BufferedConnection)) break;
                ((BufferedConnection)connection).updateTheirMaxBandwidth(maximum);
                break;
            }
            case 2: {
                int count = buffer.readUnsignedByte() + 1;
                int byteCount = buffer.readVarUnsignedInt();
                NetByteBuf subBuffer = buffer.readBytes(byteCount);
                if (DEBUG) {
                    LibNetworkStack.LOGGER.info(connection + " Received " + count + " stacktrace elements in " + byteCount + " bytes.");
                }
                for (int i = 0; i < count; ++i) {
                    if (DEBUG) {
                        LibNetworkStack.LOGGER.info(connection + " reading stacktrace " + (i + 1));
                    }
                    InternalMsgUtil.readStacktraceAllocation(connection, subBuffer);
                }
                break;
            }
            case 5: {
                NetByteBuf data;
                int bytes = buffer.readVarUnsignedInt();
                int count = buffer.readVarUnsignedInt();
                connection.lastReceivedTypes = data = buffer.readBytes(bytes);
                connection.lastReceivedTypesCount = count;
                break;
            }
            case 6: {
                int stackId = buffer.readVarUnsignedInt();
                connection.lastReceivedStacktrace = (ActiveConnection.MultiTraceLines)connection.receivedJoinedTraces.get(stackId);
                if (connection.lastReceivedStacktrace != null) break;
                throw new InvalidInputDataException("Unknown MultiTraceLines id " + stackId);
            }
            case 7: {
                connection.sendTypes = true;
                break;
            }
            case 8: {
                if (connection.sendStacktraces) break;
                connection.sendStacktraces = true;
                if (LibNetworkStack.CONFIG_RECORD_STACKTRACES) {
                    LibNetworkStack.LOGGER.info(connection + " is now being sent stacktraces for every packet.");
                    break;
                }
                LibNetworkStack.LOGGER.info(connection + " requested stacktraces, but debug.record_stacktraces is disabled so we won't send any.");
                break;
            }
            default: {
                CheckingNetByteBuf checkingBuffer;
                boolean hasFullTypeBuffer;
                if (id < 0 || id >= connection.readMapIds.size()) {
                    throw new InvalidInputDataException(connection + " Unknown/invalid ID " + id);
                }
                TreeNetIdBase readId = connection.readMapIds.get(id);
                if (!(readId instanceof NetIdBase)) {
                    throw new InvalidInputDataException("Not a receiving node: " + readId + " for ID " + id);
                }
                NetIdBase netId = (NetIdBase)readId;
                int flags = netId.getFinalFlags();
                MessageContext.Read ctx = new MessageContext.Read(connection, netId);
                if ((flags & 0x30) == 16) {
                    ctx.assertClientSide();
                } else if ((flags & 0x30) == 32) {
                    ctx.assertServerSide();
                }
                int len = netId.hasFixedLength() ? netId.totalLength : ((flags & 3) == 1 ? 1 + buffer.readUnsignedByte() : ((flags & 3) == 2 ? 1 + buffer.readUnsignedShort() : 1 + buffer.readUnsignedMedium()));
                NetByteBuf payload = connection.allocBuffer(len);
                buffer.readBytes((ByteBuf)payload, len);
                NetByteBuf.SavedReaderIndex payloadStart = payload.saveReaderIndex();
                NetByteBuf typeBuffer = connection.lastReceivedTypes;
                if (typeBuffer != null) {
                    hasFullTypeBuffer = true;
                    typeBuffer.markReaderIndex();
                    checkingBuffer = new CheckingNetByteBuf(payload, typeBuffer);
                } else if (LibNetworkStack.DEBUG) {
                    hasFullTypeBuffer = false;
                    typeBuffer = NetByteBuf.buffer();
                    checkingBuffer = new CheckingNetByteBuf(payload, typeBuffer);
                    checkingBuffer.recordReads();
                } else {
                    hasFullTypeBuffer = false;
                    checkingBuffer = new CheckingNetByteBuf(payload, null);
                }
                try {
                    if (netId.receive(checkingBuffer, ctx)) {
                        if (ctx.dropReason == null) {
                            if (checkingBuffer.readableBytes() <= 0) break;
                            throw new InvalidInputDataException("The packet has more data than was read!");
                        }
                        if (!DEBUG) break;
                        LibNetworkStack.LOGGER.info(connection + " Dropped " + netId.fullName + " because '" + ctx.dropReason + "'!");
                        break;
                    }
                    if (!DEBUG) break;
                    LibNetworkStack.LOGGER.info(connection + " Dropped " + netId.fullName + " as one of it's parents could not be read!");
                    break;
                }
                catch (CheckingNetByteBuf.InvalidNetTypeException | InvalidInputDataException | CodecException | IndexOutOfBoundsException e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Packet failed to read correctly!\n\n");
                    sb.append("Packet: " + netId + "\n");
                    sb.append("Payload Length: " + len + "\n");
                    sb.append("Reader Index: " + payload.readerIndex() + ". (Marked by '#')\n");
                    sb.append("Error: " + e.getMessage() + "\n");
                    sb.append("Raw Bytes:\n");
                    sb.append("+---------\n");
                    sb.append("| ");
                    MsgUtil.appendBufferData((ByteBuf)checkingBuffer, 0, len, sb, "| ", payload.readerIndex());
                    sb.append("\n");
                    sb.append("+---------\n");
                    NetByteBuf.SavedReaderIndex payloadIndex = payload.saveReaderIndex();
                    payload.resetReaderIndex(payloadStart);
                    if (typeBuffer == null) {
                        sb.append("WARNING: No type information found!\n");
                        sb.append("  Add '-Dlibnetworkstack.debug=true' to your VM arguments\n");
                        sb.append("  to record type information on packet read&write.\n");
                        sb.append("  Alternatively you can change 'debug' or 'debug.record_types' to true\n");
                        sb.append("  in the config file: " + LibNetworkStack.CONFIG_FILE_LOCATION + "\n");
                    } else {
                        int typeCount = hasFullTypeBuffer ? connection.lastReceivedTypesCount : checkingBuffer.getCountRead();
                        NetByteBuf.SavedReaderIndex typeIndex = typeBuffer.saveReaderIndex();
                        typeBuffer.resetReaderIndex();
                        sb.append("Payload Types: " + typeCount + "\n");
                        if (!hasFullTypeBuffer) {
                            sb.append("(WARNING: these are from the read() ");
                            sb.append("methods as they weren't provided by the sender)\n");
                        }
                        sb.append("Payload Data:\n");
                        for (int i = 0; i < typeCount; ++i) {
                            CheckingNetByteBuf.NetMethod method = checkingBuffer.typeBuffer.method_10818(CheckingNetByteBuf.NetMethod.class);
                            if (method == CheckingNetByteBuf.NetMethod.MARKER_ID) {
                                int marker = checkingBuffer.readMarkerId_data();
                                sb.append("+---------\n");
                                if (marker < 9 || marker >= connection.readMapIds.size()) {
                                    sb.append("|Marker: invalid/unknown! (" + marker + ")\n");
                                    continue;
                                }
                                TreeNetIdBase markerId = connection.readMapIds.get(marker);
                                sb.append("|");
                                sb.append(markerId);
                                sb.append("\n");
                                continue;
                            }
                            StringBuilder sb2 = new StringBuilder();
                            try {
                                method.appender.readAndAppend(checkingBuffer, sb2);
                            }
                            catch (Throwable t) {
                                InvalidInputDataException e2 = new InvalidInputDataException(sb.toString(), e);
                                e2.addSuppressed(t);
                                throw e2;
                            }
                            if (method == CheckingNetByteBuf.NetMethod.CUSTOM_MARKER) {
                                sb.append("+-");
                            } else {
                                sb.append("| ");
                            }
                            if (e instanceof CheckingNetByteBuf.InvalidNetTypeException && ((CheckingNetByteBuf.InvalidNetTypeException)e).index == i) {
                                CheckingNetByteBuf.InvalidNetTypeException netType = (CheckingNetByteBuf.InvalidNetTypeException)e;
                                int newLine = sb2.indexOf("\n");
                                Object inserted = "    <-- HERE: ";
                                inserted = netType.read != method ? (String)inserted + "tried to read " + netType.read : (String)inserted + e.getMessage();
                                if (newLine < 0) {
                                    sb2.append((String)inserted);
                                } else {
                                    sb2.insert(newLine, (String)inserted);
                                }
                            }
                            sb.append(sb2.toString().replace("\n", "\n|"));
                            sb.append("\n");
                            if (payloadIndex.readerIndex != payload.readerIndex() || payloadIndex.readerIndex >= payload.writerIndex()) continue;
                            sb.append("+---(stopped reading here)\n");
                        }
                        typeBuffer.resetReaderIndex(typeIndex);
                        int rem = payload.readableBytes();
                        if (rem > 0) {
                            sb.append("+---------\n");
                            sb.append("|Remaining Bytes (" + rem + "):\n| ");
                            MsgUtil.appendBufferData((ByteBuf)payload, payload.readerIndex(), rem, sb, "| ", -1);
                            sb.append("\n");
                        }
                        sb.append("+---------\n");
                    }
                    if (connection.lastReceivedStacktrace != null) {
                        sb.append("\n+---------\n");
                        sb.append("|Sender Stacktrace:\n|\n");
                        boolean first = true;
                        ActiveConnection.MultiTraceLines line = connection.lastReceivedStacktrace;
                        do {
                            sb.append(first ? "|     " : "|  at ");
                            sb.append(line.line);
                            sb.append("\n");
                            first = false;
                        } while ((line = line.parent) != null);
                        sb.append("+---------\n");
                    }
                    sb.append("\n");
                    throw new InvalidInputDataException(sb.toString(), e);
                }
                finally {
                    payload.release();
                    if (typeBuffer != null) {
                        typeBuffer.release();
                        connection.lastReceivedTypes = null;
                    }
                }
            }
        }
    }

    private static void readStacktraceAllocation(ActiveConnection connection, NetByteBuf buffer) throws InvalidInputDataException {
        int type = buffer.readFixedBits(2);
        switch (type) {
            case 0: {
                int newId = buffer.readVarUnsignedInt();
                int parentId = buffer.readVarUnsignedInt();
                ActiveConnection.StringTraceSeparator sep = buffer.method_10818(ActiveConnection.StringTraceSeparator.class);
                String text = buffer.method_19772();
                ActiveConnection.StringTraceSegment parent = (ActiveConnection.StringTraceSegment)connection.receivedTraceStringSegments.get(parentId);
                if (parent == null && parentId != 0) {
                    throw new InvalidInputDataException("Unknown parent ID for StringTraceSegment " + parent);
                }
                ActiveConnection.StringTraceSegment segment = new ActiveConnection.StringTraceSegment(newId, parent, sep, text);
                ActiveConnection.StringTraceSegment old = (ActiveConnection.StringTraceSegment)connection.receivedTraceStringSegments.put(newId, (Object)segment);
                if (old != null) {
                    throw new InvalidInputDataException("Duplicate StringTraceSegment " + old + " vs added " + segment);
                }
                if (!DEBUG) break;
                LibNetworkStack.LOGGER.info(connection + " Received new stacktrace string element " + newId + " as " + segment);
                break;
            }
            case 1: {
                int newId = buffer.readVarUnsignedInt();
                int parentId = buffer.readVarUnsignedInt();
                int lineNumber = buffer.readVarUnsignedInt();
                ActiveConnection.StringTraceSegment parent = (ActiveConnection.StringTraceSegment)connection.receivedTraceStringSegments.get(parentId);
                if (parent == null) {
                    throw new InvalidInputDataException("Unknown parent ID for SingleTraceLine " + parentId);
                }
                ActiveConnection.SingleTraceLine single = new ActiveConnection.SingleTraceLine(newId, parent, lineNumber);
                ActiveConnection.SingleTraceLine old = (ActiveConnection.SingleTraceLine)connection.receivedTraceLines.put(newId, (Object)single);
                if (old != null) {
                    throw new InvalidInputDataException("Duplicate SingleTraceLine " + old + " vs added " + single);
                }
                if (!DEBUG) break;
                LibNetworkStack.LOGGER.info(connection + " Received new stacktrace line element " + newId + " as " + single);
                break;
            }
            case 2: {
                int newId = buffer.readVarUnsignedInt();
                int parentId = buffer.readVarUnsignedInt();
                int lineId = buffer.readVarUnsignedInt();
                ActiveConnection.MultiTraceLines parent = (ActiveConnection.MultiTraceLines)connection.receivedJoinedTraces.get(parentId);
                if (parent == null && parentId != 0) {
                    throw new InvalidInputDataException("Unknown parent ID for MultiTraceLines " + parentId);
                }
                ActiveConnection.SingleTraceLine line = (ActiveConnection.SingleTraceLine)connection.receivedTraceLines.get(lineId);
                if (line == null) {
                    throw new InvalidInputDataException("Unknown ID for SingleTraceLine " + lineId);
                }
                ActiveConnection.MultiTraceLines multi = new ActiveConnection.MultiTraceLines(newId, parent, line);
                ActiveConnection.MultiTraceLines old = (ActiveConnection.MultiTraceLines)connection.receivedJoinedTraces.put(newId, (Object)multi);
                if (old != null) {
                    throw new InvalidInputDataException("Duplicate MultiTraceLines " + old + " vs added " + multi);
                }
                if (!DEBUG) break;
                LibNetworkStack.LOGGER.info(connection + " Received new stacktrace multi element " + newId + " p " + parentId + " as " + multi);
                break;
            }
            default: {
                throw new InvalidInputDataException("Unknown ID_INTERNAL_ALLOCATE_STACKTRACE_ELEMENT type " + type);
            }
        }
    }

    private static <P, C> ResolvedDynamicNetId<C> resolveChild(ParentDynamicNetId<P, C> parent, String str) {
        DynamicNetId childId = parent.childId;
        if (!childId.name.equals(str)) {
            return null;
        }
        return new ResolvedDynamicNetId(parent, childId);
    }

    private static <T> TreeNetIdBase resolveChild(ResolvedParentNetId<?, T> netId, String str) {
        return InternalMsgUtil.resolveChild(netId, netId.reader, str);
    }

    private static <T> TreeNetIdBase resolveChild(ResolvedDynamicNetId<T> netId, String str) {
        return InternalMsgUtil.resolveChild(netId, netId.wrapped, str);
    }

    private static <T> TreeNetIdBase resolveChild(ParentNetIdSingle<T> resolved, ParentNetIdSingle<T> wrapped, String str) {
        ParentNetIdDuel branchId = wrapped.branchChildren.get(str);
        if (branchId != null) {
            return new ResolvedParentNetId(resolved, branchId);
        }
        NetIdTyped leafId = wrapped.leafChildren.get(str);
        if (leafId != null) {
            return new ResolvedNetId<T>(resolved, leafId);
        }
        return null;
    }

    private static String lenToString(int len) {
        if (len == -1) {
            return "Dynamic";
        }
        if (len == -2) {
            return "Parent";
        }
        return Integer.toString(len);
    }

    public static void send(ActiveConnection connection, NetIdBase netId, NetIdPath path, NetByteBuf payload) {
        NetByteBuf fullPayload = InternalMsgUtil.wrapFullPayload(connection, netId, path, payload);
        int id = fullPayload.getInt(0);
        connection.sendPacket(fullPayload, id, netId, netId.getDefaultPriority());
        fullPayload.release();
    }

    public static void send(ActiveConnection connection, NetIdBase netId, NetIdPath path, NetByteBuf payload, int priority) {
        NetByteBuf fullPayload = InternalMsgUtil.wrapFullPayload(connection, netId, path, payload);
        int id = fullPayload.getInt(0);
        connection.sendPacket(fullPayload, id, netId, priority);
        fullPayload.release();
    }

    private static NetByteBuf wrapFullPayload(ActiveConnection connection, NetIdBase netId, NetIdPath path, NetByteBuf payload) {
        int id = InternalMsgUtil.getWriteId(connection, netId, path);
        int len = 5 + (netId.hasFixedLength() ? 0 : 4) + payload.readableBytes();
        if (netId.hasFixedLength()) assert (netId.totalLength == payload.readableBytes());
        NetByteBuf fullPayload = NetByteBuf.buffer(len);
        fullPayload.writeVarUnsignedInt(id);
        if (!netId.hasFixedLength()) {
            if ((netId.getFinalFlags() & 3) == 1) {
                if (payload.readableBytes() > 256) {
                    throw new IllegalArgumentException("Packet Payload too large for TINY packet size - was " + payload.readableBytes() + ", which is bigger than 256!");
                }
                fullPayload.writeByte(payload.readableBytes() - 1);
            } else if ((netId.getFinalFlags() & 3) == 2) {
                if (payload.readableBytes() > 65536) {
                    throw new IllegalArgumentException("Packet Payload too large for NORMAL packet size - was " + payload.readableBytes() + ", which is bigger than 65536!");
                }
                fullPayload.writeShort(payload.readableBytes() - 1);
            } else {
                if (payload.readableBytes() > 0x1000000) {
                    throw new IllegalArgumentException("Packet Payload too large for LARGE packet size - was " + payload.readableBytes() + ", which is bigger than 16777216!");
                }
                fullPayload.writeMedium(payload.readableBytes() - 1);
            }
        }
        fullPayload.writeBytes((ByteBuf)payload, payload.readerIndex(), payload.readableBytes());
        return fullPayload;
    }

    static int getWriteId(ActiveConnection connection, TreeNetIdBase netId, NetIdPath path) {
        int currentId = connection.writeMapIds.getInt((Object)path);
        int id = currentId == 0 ? InternalMsgUtil.allocAndSendNewId(connection, netId, path) : currentId;
        return id;
    }

    static void sendNextTypes(ActiveConnection connection, NetByteBuf types, int count) {
        int bytes = types.readableBytes();
        if (bytes > 0x200000) {
            throw new IllegalArgumentException("Too many bytes! (" + bytes + ") > 2097152");
        }
        if (count > 0x200000) {
            throw new IllegalArgumentException("Too many types! (" + count + ") > 2097152");
        }
        int len = 7 + bytes;
        NetByteBuf fullPayload = NetByteBuf.buffer(len);
        fullPayload.writeVarUnsignedInt(5);
        fullPayload.writeVarUnsignedInt(bytes);
        fullPayload.writeVarUnsignedInt(count);
        fullPayload.writeBytes((ByteBuf)types, types.readerIndex(), bytes);
        connection.sendPacket(fullPayload, 5, null, 0);
        fullPayload.release();
    }

    static void createAndSendDebugThrowable(ActiveConnection connection, MessageContext.Write ctx) {
        Throwable throwable;
        class_2586 be = ctx.__debugBlockEntity;
        if (be == null) {
            throwable = InternalMsgUtil.__NOT_A_BLOCK_ENTITY();
        } else {
            class_1937 class_19372 = be.method_10997();
            if (!(class_19372 instanceof class_3218)) {
                throwable = InternalMsgUtil.__BLOCK_ENTITY_NOT_ON_SERVER();
            } else {
                class_3218 svWorld = (class_3218)class_19372;
                class_3898 tacs = svWorld.method_14178().field_17254;
                IThreadedAnvilChunkStorageMixin mixinTacs = (IThreadedAnvilChunkStorageMixin)tacs;
                class_3193 chunkHolder = mixinTacs.libnetworkstack_getChunkHolder(new class_1923(be.method_11016()));
                throwable = chunkHolder.method_16144() == null ? InternalMsgUtil.__BLOCK_ENTITY_NOT_SENT() : InternalMsgUtil.__BLOCK_ENTITY_PROBABLY_SENT();
            }
        }
        InternalMsgUtil.sendNextStacktrace(connection, throwable);
    }

    private static Throwable __NOT_A_BLOCK_ENTITY() {
        return new Throwable();
    }

    private static Throwable __BLOCK_ENTITY_NOT_ON_SERVER() {
        return new Throwable();
    }

    private static Throwable __BLOCK_ENTITY_NOT_SENT() {
        return new Throwable();
    }

    private static Throwable __BLOCK_ENTITY_PROBABLY_SENT() {
        return new Throwable();
    }

    static void sendNextStacktrace(ActiveConnection connection, Throwable t) {
        class Gen {
            NetByteBuf traceAllocationBuf = null;
            int allocationCount = 0;
            StringBuilder sb = new StringBuilder();
            ActiveConnection.StringTraceSegment sParent = null;
            final /* synthetic */ ActiveConnection val$connection;

            Gen(ActiveConnection activeConnection) {
                this.val$connection = activeConnection;
            }

            void beginAllocation() {
                if (this.traceAllocationBuf == null) {
                    this.traceAllocationBuf = NetByteBuf.buffer();
                }
            }

            void finishAllocation() {
                ++this.allocationCount;
                if (this.allocationCount == 256) {
                    if (DEBUG) {
                        LibNetworkStack.LOGGER.info(this.val$connection + " Sending 256 (complete) stacktrace allocations in " + this.traceAllocationBuf.writerIndex() + " bytes.");
                    }
                    NetByteBuf buffer = NetByteBuf.buffer();
                    buffer.writeVarUnsignedInt(2);
                    buffer.writeByte(255);
                    buffer.writeVarUnsignedInt(this.traceAllocationBuf.readableBytes());
                    buffer.writeBytes((ByteBuf)this.traceAllocationBuf);
                    this.val$connection.sendPacket(buffer, 2, null, 0);
                    buffer.release();
                    this.traceAllocationBuf.release();
                    this.traceAllocationBuf = null;
                    this.allocationCount = 0;
                }
            }

            void finish() {
                if (this.allocationCount > 0) {
                    if (DEBUG) {
                        LibNetworkStack.LOGGER.info(this.val$connection + " Sending " + this.allocationCount + " (partial) stacktrace allocations in " + this.traceAllocationBuf.writerIndex() + " bytes.");
                    }
                    NetByteBuf buffer = NetByteBuf.buffer();
                    buffer.writeVarUnsignedInt(2);
                    buffer.writeByte(this.allocationCount - 1);
                    buffer.writeVarUnsignedInt(this.traceAllocationBuf.readableBytes());
                    buffer.writeBytes((ByteBuf)this.traceAllocationBuf);
                    this.val$connection.sendPacket(buffer, 2, null, 0);
                    buffer.release();
                    this.traceAllocationBuf.release();
                    this.traceAllocationBuf = null;
                    this.allocationCount = 0;
                }
            }

            void allocSegment(ActiveConnection.StringTraceSeparator sep) {
                String text = this.sb.toString();
                this.sb.replace(0, Integer.MAX_VALUE, "");
                ActiveConnection.StringTraceSegment next = this.sParent.getCharChild(sep).get(text);
                if (next == null) {
                    int newId = ++this.val$connection.allocatedStringSegemnts;
                    next = new ActiveConnection.StringTraceSegment(newId, this.sParent, sep, text);
                    if (DEBUG) {
                        LibNetworkStack.LOGGER.info(this.val$connection + " Sending new stacktrace string element " + newId + " as " + next);
                    }
                    this.beginAllocation();
                    this.traceAllocationBuf.writeFixedBits(0, 2);
                    this.traceAllocationBuf.writeVarUnsignedInt(newId);
                    this.traceAllocationBuf.writeVarUnsignedInt(this.sParent.id);
                    this.traceAllocationBuf.writeEnumConstant(sep);
                    this.traceAllocationBuf.method_10814(text);
                    this.finishAllocation();
                }
                this.sParent = next;
            }

            public ActiveConnection.StringTraceSeparator walk(String fullName, ActiveConnection.StringTraceSeparator lastSep) {
                for (int j = 0; j < fullName.length(); ++j) {
                    char c = fullName.charAt(j);
                    ActiveConnection.StringTraceSeparator sep = ActiveConnection.StringTraceSeparator.from(c);
                    if (sep != null) {
                        this.allocSegment(lastSep);
                        lastSep = sep;
                        continue;
                    }
                    this.sb.append(c);
                }
                if (this.sb.length() > 0) {
                    this.allocSegment(lastSep);
                }
                return lastSep;
            }
        }
        Gen gen = new Gen(connection);
        Object[] trace = t.getStackTrace();
        ActiveConnection.MultiTraceLines parent = null;
        for (int i = trace.length - 1; i >= 0; --i) {
            ActiveConnection.MultiTraceLines next;
            StackTraceElement ste = trace[i];
            String moduleName = InternalMsgUtil.grabModuleName(ste);
            String fqn = ste.getClassName();
            String mth = ste.getMethodName();
            int line = ste.getLineNumber();
            gen.sParent = connection.rootTraceSegment;
            ActiveConnection.StringTraceSeparator lastSep = ActiveConnection.StringTraceSeparator.DOT;
            if (moduleName != null) {
                lastSep = gen.walk(moduleName, lastSep);
                lastSep = ActiveConnection.StringTraceSeparator.SLASH;
            }
            lastSep = gen.walk(fqn, lastSep);
            gen.walk(mth, lastSep);
            ActiveConnection.SingleTraceLine fullLine = (ActiveConnection.SingleTraceLine)gen.sParent.lineChildren.get(line);
            if (fullLine == null) {
                int newId = ++connection.allocatedTraceSegemnts;
                fullLine = new ActiveConnection.SingleTraceLine(newId, gen.sParent, line);
                if (DEBUG) {
                    LibNetworkStack.LOGGER.info(connection + " Sending new stacktrace line element " + newId + " as " + fullLine);
                }
                gen.beginAllocation();
                gen.traceAllocationBuf.writeFixedBits(1, 2);
                gen.traceAllocationBuf.writeVarUnsignedInt(newId);
                gen.traceAllocationBuf.writeVarUnsignedInt(gen.sParent.id);
                gen.traceAllocationBuf.writeVarUnsignedInt(line);
                gen.finishAllocation();
            }
            if ((next = fullLine.children.get(parent)) == null) {
                int newId = ++connection.allocatedJoinedTraces;
                next = new ActiveConnection.MultiTraceLines(newId, parent, fullLine);
                if (DEBUG) {
                    LibNetworkStack.LOGGER.info(connection + " Sending new stacktrace multi element " + newId + " p " + (parent == null ? 0 : parent.id) + " as " + next);
                }
                gen.beginAllocation();
                gen.traceAllocationBuf.writeFixedBits(2, 2);
                gen.traceAllocationBuf.writeVarUnsignedInt(newId);
                gen.traceAllocationBuf.writeVarUnsignedInt(parent == null ? 0 : parent.id);
                gen.traceAllocationBuf.writeVarUnsignedInt(fullLine.id);
                gen.finishAllocation();
            }
            parent = next;
        }
        gen.finish();
        if (parent == null) {
            throw new IllegalStateException("No stacktrace to send! " + Arrays.toString(trace));
        }
        NetByteBuf fullPayload = NetByteBuf.buffer(6);
        fullPayload.writeVarUnsignedInt(6);
        fullPayload.writeVarUnsignedInt(parent.id);
        connection.sendPacket(fullPayload, 6, null, 0);
        fullPayload.release();
    }

    private static String grabModuleName(StackTraceElement ste) {
        if (STACK_TRACE_ELEMENT_MODULE_NAME != null) {
            try {
                return (String)STACK_TRACE_ELEMENT_MODULE_NAME.invoke((Object)ste, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new Error(e);
            }
        }
        return null;
    }

    private static int allocAndSendNewId(ActiveConnection connection, TreeNetIdBase netId, NetIdPath path) {
        ParentNetIdBase parent;
        assert (netId == path.array[path.array.length - 1]);
        byte[] textData = netId.name.getBytes(StandardCharsets.UTF_8);
        int pathLength = path.calculateLength();
        boolean writeLength = netId instanceof NetIdBase && pathLength != -1;
        int len = 15 + (writeLength ? 3 : 0) + 1 + textData.length;
        NetByteBuf allocationData = NetByteBuf.asNetByteBuf(Unpooled.buffer((int)len));
        allocationData.writeVarUnsignedInt(0);
        ParentNetIdBase parentNetIdBase = parent = path.array.length > 1 ? (ParentNetIdBase)path.array[path.array.length - 2] : null;
        if (parent == null) {
            throw new IllegalArgumentException("The net ID " + netId + " must have a non-null parent!");
        }
        if (parent == connection.rootId) {
            allocationData.writeVarUnsignedInt(0);
        } else {
            allocationData.writeVarUnsignedInt(InternalMsgUtil.getWriteId(connection, parent, path.parent()));
        }
        int newId = connection.writeMapIds.size() + 9;
        connection.writeMapIds.put((Object)path, newId);
        allocationData.writeVarUnsignedInt(newId);
        int flags = netId.getFinalFlags();
        allocationData.writeInt(flags);
        if ((flags & 4) == 0 && (flags & 3) == 0 != writeLength) {
            throw new IllegalStateException("The packet " + netId + " has flags of " + flags + " but writeLength of " + writeLength);
        }
        if (writeLength) {
            allocationData.writeMedium(pathLength);
        }
        allocationData.writeByte(textData.length);
        allocationData.writeBytes(textData);
        if (LibNetworkStack.DEBUG) {
            LibNetworkStack.LOGGER.info(connection + " Sending new ID " + newId + " -> " + netId.getPrintableName() + " " + path);
        }
        connection.sendPacket(allocationData, 0, null, 0);
        allocationData.release();
        return newId;
    }

    static {
        Method method = null;
        try {
            method = StackTraceElement.class.getMethod("getModuleName", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        STACK_TRACE_ELEMENT_MODULE_NAME = method;
    }
}

