/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.CheckingNetByteBuf;
import alexiil.mc.lib.net.DynamicNetLink;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.ParentNetIdSingle;
import alexiil.mc.lib.net.TreeNetIdBase;
import java.util.List;

public final class DynamicNetId<T>
extends ParentNetIdSingle<T> {
    final LinkAccessor<T> linkGetter;

    public DynamicNetId(Class<T> clazz, LinkAccessor<T> linkGetter) {
        super(null, clazz, "dynamic", -1);
        this.linkGetter = linkGetter;
    }

    @Override
    protected T readContext(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        throw new IllegalStateException("Dynamic Net ID's must be fully resolved before they can be read!");
    }

    @Override
    protected void writeContext(NetByteBuf buffer, IMsgWriteCtx ctx, T value) {
        throw new IllegalStateException("Dynamic Net ID's must be written with the dynamic variant!");
    }

    @Override
    protected void writeDynamicContext(CheckingNetByteBuf buffer, IMsgWriteCtx ctx, T value, List<TreeNetIdBase> resolvedPath) {
        this.writeParent(buffer, ctx, this.linkGetter.getLink(value), resolvedPath);
        resolvedPath.add(this);
    }

    private <P> void writeParent(CheckingNetByteBuf buffer, IMsgWriteCtx ctx, DynamicNetLink<P, T> link, List<TreeNetIdBase> resolvedPath) {
        assert (link.parentId.childId == this);
        link.parentId.parent.writeDynamicContext(buffer, ctx, link.parent, resolvedPath);
        resolvedPath.add(link.parentId);
    }

    @FunctionalInterface
    public static interface LinkAccessor<T> {
        public DynamicNetLink<?, T> getLink(T var1);
    }
}

