/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.MsgUtil;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.TreeNetIdBase;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_3532;
import net.minecraft.class_3965;

public class CheckingNetByteBuf
extends NetByteBuf {
    private final NetByteBuf wrapped;
    final NetByteBuf typeBuffer;
    private boolean recordReads;
    private int countRead = 0;
    private int countWrite = 0;

    public CheckingNetByteBuf(NetByteBuf wrapped, @Nullable NetByteBuf typeData) {
        super((ByteBuf)wrapped, wrapped.passthrough);
        this.wrapped = wrapped;
        this.typeBuffer = typeData;
    }

    public void recordReads() {
        this.recordReads = this.typeBuffer != null;
    }

    public int getCountRead() {
        return this.countRead;
    }

    public int getCountWrite() {
        return this.countWrite;
    }

    @Override
    public int getBitWriterIndex() {
        return this.wrapped.getBitWriterIndex();
    }

    @Override
    public int getBitReaderIndex() {
        return this.wrapped.getBitReaderIndex();
    }

    private void validateRead(NetMethod expected) {
        if (this.recordReads) {
            return;
        }
        ++this.countRead;
        if (this.typeBuffer == null) {
            return;
        }
        NetMethod written = this.typeBuffer.method_10818(NetMethod.class);
        if (expected != written) {
            throw new InvalidNetTypeException(written, expected, this.countRead - 1);
        }
    }

    private void recordRead(NetMethod expected) {
        if (!this.recordReads) {
            return;
        }
        ++this.countRead;
        this.typeBuffer.writeEnumConstant(expected);
    }

    private void write(NetMethod method) {
        ++this.countWrite;
        if (this.typeBuffer != null) {
            this.typeBuffer.writeEnumConstant(method);
        }
    }

    public void readMarkerId(int expected) {
        int id;
        if (this.recordReads) {
            this.recordRead(NetMethod.MARKER_ID);
            this.typeBuffer.writeVarUnsignedInt(expected);
            return;
        }
        this.validateRead(NetMethod.MARKER_ID);
        if (this.typeBuffer != null && expected != (id = this.typeBuffer.readVarUnsignedInt())) {
            throw new InvalidNetTypeException(NetMethod.MARKER_ID, this.countRead - 1, "" + id, "" + expected);
        }
    }

    public void readMarkerId(IMsgReadCtx ctx, TreeNetIdBase netId) {
        if (this.typeBuffer == null) {
            return;
        }
        for (int i = 0; i < ctx.getConnection().readMapIds.size(); ++i) {
            TreeNetIdBase id = ctx.getConnection().readMapIds.get(i);
            if (id != netId) continue;
            this.readMarkerId(i);
            return;
        }
        throw new IllegalStateException("Don't know how to read " + netId);
    }

    int readMarkerId_data() {
        if (this.typeBuffer == null) {
            return -1;
        }
        return this.typeBuffer.readVarUnsignedInt();
    }

    public void writeMarkerId(int id) {
        this.write(NetMethod.MARKER_ID);
        if (this.typeBuffer != null) {
            this.typeBuffer.writeVarUnsignedInt(id);
        }
    }

    public boolean hasTypeData() {
        return this.typeBuffer != null;
    }

    @Override
    public boolean readBoolean() {
        this.validateRead(NetMethod.BOOLEAN);
        boolean val = this.wrapped.readBoolean();
        this.recordRead(NetMethod.BOOLEAN);
        return val;
    }

    @Override
    public CheckingNetByteBuf writeBoolean(boolean flag) {
        this.write(NetMethod.BOOLEAN);
        this.wrapped.writeBoolean(flag);
        return this;
    }

    public byte readByte() {
        this.validateRead(NetMethod.BYTE);
        byte val = this.wrapped.readByte();
        this.recordRead(NetMethod.BYTE);
        return val;
    }

    public short readUnsignedByte() {
        this.validateRead(NetMethod.BYTE);
        short val = this.wrapped.readUnsignedByte();
        this.recordRead(NetMethod.BYTE);
        return val;
    }

    public CheckingNetByteBuf writeByte(int i) {
        this.write(NetMethod.BYTE);
        this.wrapped.writeByte(i);
        return this;
    }

    public short readShort() {
        this.validateRead(NetMethod.SHORT);
        short val = this.wrapped.readShort();
        this.recordRead(NetMethod.SHORT);
        return val;
    }

    public int readUnsignedShort() {
        this.validateRead(NetMethod.SHORT);
        int val = this.wrapped.readUnsignedShort();
        this.recordRead(NetMethod.SHORT);
        return val;
    }

    public CheckingNetByteBuf writeShort(int i) {
        this.write(NetMethod.SHORT);
        this.wrapped.writeShort(i);
        return this;
    }

    public int readMedium() {
        this.validateRead(NetMethod.MEDIUM);
        int val = this.wrapped.readMedium();
        this.recordRead(NetMethod.MEDIUM);
        return val;
    }

    public int readUnsignedMedium() {
        this.validateRead(NetMethod.MEDIUM);
        int val = this.wrapped.readUnsignedMedium();
        this.recordRead(NetMethod.MEDIUM);
        return val;
    }

    public CheckingNetByteBuf writeMedium(int i) {
        this.write(NetMethod.MEDIUM);
        this.wrapped.writeMedium(i);
        return this;
    }

    public int readInt() {
        this.validateRead(NetMethod.INT);
        int val = this.wrapped.readInt();
        this.recordRead(NetMethod.INT);
        return val;
    }

    public long readUnsignedInt() {
        this.validateRead(NetMethod.INT);
        long val = this.wrapped.readUnsignedInt();
        this.recordRead(NetMethod.INT);
        return val;
    }

    public CheckingNetByteBuf writeInt(int i) {
        this.write(NetMethod.INT);
        this.wrapped.writeInt(i);
        return this;
    }

    public long readLong() {
        this.validateRead(NetMethod.LONG);
        long val = this.wrapped.readLong();
        this.recordRead(NetMethod.LONG);
        return val;
    }

    public CheckingNetByteBuf writeLong(long l) {
        this.write(NetMethod.LONG);
        this.wrapped.writeLong(l);
        return this;
    }

    public short readShortLE() {
        this.validateRead(NetMethod.SHORT_LE);
        short val = this.wrapped.readShortLE();
        this.recordRead(NetMethod.SHORT_LE);
        return val;
    }

    public int readUnsignedShortLE() {
        this.validateRead(NetMethod.SHORT_LE);
        int val = this.wrapped.readUnsignedShortLE();
        this.recordRead(NetMethod.SHORT_LE);
        return val;
    }

    public CheckingNetByteBuf writeShortLE(int i) {
        this.write(NetMethod.SHORT_LE);
        this.wrapped.writeShortLE(i);
        return this;
    }

    public int readMediumLE() {
        this.validateRead(NetMethod.MEDIUM_LE);
        int val = this.wrapped.readMediumLE();
        this.recordRead(NetMethod.MEDIUM_LE);
        return val;
    }

    public int readUnsignedMediumLE() {
        this.validateRead(NetMethod.MEDIUM_LE);
        int val = this.wrapped.readUnsignedMediumLE();
        this.recordRead(NetMethod.MEDIUM_LE);
        return val;
    }

    public CheckingNetByteBuf writeMediumLE(int i) {
        this.write(NetMethod.MEDIUM_LE);
        this.wrapped.writeMediumLE(i);
        return this;
    }

    public int readIntLE() {
        this.validateRead(NetMethod.INT_LE);
        int val = this.wrapped.readIntLE();
        this.recordRead(NetMethod.INT_LE);
        return val;
    }

    public long readUnsignedIntLE() {
        this.validateRead(NetMethod.INT_LE);
        long val = this.wrapped.readUnsignedIntLE();
        this.recordRead(NetMethod.INT_LE);
        return val;
    }

    public CheckingNetByteBuf writeIntLE(int i) {
        this.write(NetMethod.INT_LE);
        this.wrapped.writeIntLE(i);
        return this;
    }

    public long readLongLE() {
        this.validateRead(NetMethod.LONG_LE);
        long val = this.wrapped.readLongLE();
        this.recordRead(NetMethod.LONG_LE);
        return val;
    }

    public CheckingNetByteBuf writeLongLE(long l) {
        this.write(NetMethod.LONG_LE);
        this.wrapped.writeLongLE(l);
        return this;
    }

    public float readFloat() {
        this.validateRead(NetMethod.FLOAT);
        float val = this.wrapped.readFloat();
        this.recordRead(NetMethod.FLOAT);
        return val;
    }

    public CheckingNetByteBuf writeFloat(float f) {
        this.write(NetMethod.FLOAT);
        this.wrapped.writeFloat(f);
        return this;
    }

    public float readFloatLE() {
        this.validateRead(NetMethod.FLOAT_LE);
        float val = this.wrapped.readFloatLE();
        this.recordRead(NetMethod.FLOAT_LE);
        return val;
    }

    public CheckingNetByteBuf writeFloatLE(float value) {
        this.write(NetMethod.FLOAT_LE);
        this.wrapped.writeFloatLE(value);
        return this;
    }

    public double readDouble() {
        this.validateRead(NetMethod.DOUBLE);
        double val = this.wrapped.readDouble();
        this.recordRead(NetMethod.DOUBLE);
        return val;
    }

    public CheckingNetByteBuf writeDouble(double d) {
        this.write(NetMethod.DOUBLE);
        this.wrapped.writeDouble(d);
        return this;
    }

    public double readDoubleLE() {
        this.validateRead(NetMethod.DOUBLE_LE);
        double val = this.wrapped.readDoubleLE();
        this.recordRead(NetMethod.DOUBLE_LE);
        return val;
    }

    public CheckingNetByteBuf writeDoubleLE(double value) {
        this.write(NetMethod.DOUBLE_LE);
        this.wrapped.writeDoubleLE(value);
        return this;
    }

    public char readChar() {
        this.validateRead(NetMethod.CHAR);
        char val = this.wrapped.readChar();
        this.recordRead(NetMethod.CHAR);
        return val;
    }

    public CheckingNetByteBuf writeChar(int i) {
        this.write(NetMethod.CHAR);
        this.wrapped.writeChar(i);
        return this;
    }

    private void validateReadByteLength(int length) {
        int len;
        this.validateRead(NetMethod.BYTES);
        if (this.recordReads) {
            return;
        }
        if (this.typeBuffer != null && (len = this.typeBuffer.readVarUnsignedInt()) != length) {
            throw new InvalidNetTypeException(NetMethod.BYTES, this.countRead - 1, "" + len, "" + length);
        }
    }

    private void recordReadByteLength(int length) {
        this.recordRead(NetMethod.BYTES);
        if (this.recordReads) {
            this.typeBuffer.writeVarUnsignedInt(length);
        }
    }

    private void checkWriteByteLength(int length) {
        this.write(NetMethod.BYTES);
        if (this.typeBuffer != null) {
            this.typeBuffer.writeVarUnsignedInt(length);
        }
    }

    public final CheckingNetByteBuf readBytes(byte[] dst) {
        return this.readBytes(dst, 0, dst.length);
    }

    public final CheckingNetByteBuf writeBytes(byte[] src) {
        return this.writeBytes(src, 0, src.length);
    }

    public CheckingNetByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        this.validateReadByteLength(length);
        this.wrapped.readBytes(dst, dstIndex, length);
        this.recordReadByteLength(length);
        return this;
    }

    public CheckingNetByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        this.checkWriteByteLength(length);
        this.wrapped.writeBytes(src, srcIndex, length);
        return this;
    }

    public final CheckingNetByteBuf readBytes(ByteBuf byteBuf) {
        return this.readBytes(byteBuf, byteBuf.writableBytes());
    }

    public final CheckingNetByteBuf writeBytes(ByteBuf byteBuf) {
        return this.writeBytes(byteBuf, byteBuf.readableBytes());
    }

    public CheckingNetByteBuf readBytes(ByteBuf byteBuf, int length) {
        this.validateReadByteLength(length);
        this.wrapped.readBytes(byteBuf, length);
        this.recordReadByteLength(length);
        return this;
    }

    public CheckingNetByteBuf writeBytes(ByteBuf byteBuf, int length) {
        this.checkWriteByteLength(length);
        this.wrapped.writeBytes(byteBuf, length);
        return this;
    }

    @Override
    public class_2338 method_10811() {
        this.validateRead(NetMethod.BLOCK_POS);
        class_2338 val = this.wrapped.method_10811();
        this.recordRead(NetMethod.BLOCK_POS);
        return val;
    }

    @Override
    public CheckingNetByteBuf writeBlockPos(class_2338 pos) {
        this.write(NetMethod.BLOCK_POS);
        this.wrapped.writeBlockPos(pos);
        return this;
    }

    public class_3965 method_17814() {
        this.validateRead(NetMethod.BLOCK_HIT_RESULT);
        class_3965 val = this.wrapped.method_17814();
        this.recordRead(NetMethod.BLOCK_HIT_RESULT);
        return val;
    }

    public void method_17813(class_3965 blockHitResult) {
        this.write(NetMethod.BLOCK_HIT_RESULT);
        this.wrapped.method_17813(blockHitResult);
    }

    public class_2487 method_30616(class_2505 sizeTracker) {
        this.validateRead(NetMethod.COMPOUND_TAG);
        class_2487 val = this.wrapped.method_30616(sizeTracker);
        this.recordRead(NetMethod.COMPOUND_TAG);
        return val;
    }

    public CheckingNetByteBuf writeNbt(class_2487 compoundTag) {
        this.write(NetMethod.COMPOUND_TAG);
        this.wrapped.method_10794(compoundTag);
        return this;
    }

    @Override
    public String method_19772() {
        return this.method_10800(Short.MAX_VALUE);
    }

    public CheckingNetByteBuf writeString(String string) {
        return this.writeString(string, Short.MAX_VALUE);
    }

    public String method_10800(int maxLength) {
        this.validateRead(NetMethod.STRING);
        String val = this.wrapped.method_10800(maxLength);
        this.recordRead(NetMethod.STRING);
        return val;
    }

    public CheckingNetByteBuf writeString(String string, int maxLength) {
        this.write(NetMethod.STRING);
        this.wrapped.method_10788(string, maxLength);
        return this;
    }

    @Override
    public <E extends Enum<E>> E method_10818(Class<E> enumClass) {
        int len;
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        if (enums == null) {
            throw new IllegalArgumentException("Not an enum " + enumClass);
        }
        if (enums.length == 0) {
            throw new IllegalArgumentException("Tried to read an enum value without any values! How did you do this?");
        }
        this.validateRead(NetMethod.ENUM);
        if (enums.length == 1) {
            int len2;
            if (this.recordReads) {
                this.typeBuffer.writeVarUnsignedInt(1);
            } else if (this.typeBuffer != null && (len2 = this.typeBuffer.readVarUnsignedInt()) != 1) {
                throw new InvalidNetTypeException(NetMethod.ENUM, this.countRead - 1, "" + len2, "1");
            }
            if (!this.passthrough) {
                return (E)enums[0];
            }
        } else if (this.recordReads) {
            this.typeBuffer.writeVarUnsignedInt(enums.length);
        } else if (this.typeBuffer != null && (len = this.typeBuffer.readVarUnsignedInt()) != enums.length) {
            throw new InvalidNetTypeException(NetMethod.ENUM, this.countRead - 1, "" + len, "" + enums.length);
        }
        if (this.passthrough) {
            return this.wrapped.method_10818(enumClass);
        }
        return (E)enums[this.wrapped.readFixedBits(class_3532.method_15342((int)enums.length))];
    }

    @Override
    public CheckingNetByteBuf writeEnumConstant(Enum<?> value) {
        Enum[] possible = (Enum[])value.getDeclaringClass().getEnumConstants();
        if (possible == null) {
            throw new IllegalArgumentException("Not an enum " + value.getClass());
        }
        if (possible.length == 0) {
            throw new IllegalArgumentException("Tried to write an enum value without any values! How did you do this?");
        }
        this.write(NetMethod.ENUM);
        if (possible.length == 1) {
            if (this.typeBuffer != null) {
                this.typeBuffer.writeVarUnsignedInt(1);
            }
        } else if (this.typeBuffer != null) {
            this.typeBuffer.writeVarUnsignedInt(possible.length);
        }
        if (this.passthrough) {
            this.wrapped.writeEnumConstant(value);
        } else if (possible.length > 1) {
            this.wrapped.writeFixedBits(value.ordinal(), class_3532.method_15342((int)possible.length));
        }
        return this;
    }

    @Override
    public int readVarUnsignedInt() {
        this.validateRead(NetMethod.VAR_UINT);
        int val = this.wrapped.readVarUnsignedInt();
        this.recordRead(NetMethod.VAR_UINT);
        return val;
    }

    @Override
    public CheckingNetByteBuf writeVarUnsignedInt(int ival) {
        this.write(NetMethod.VAR_UINT);
        this.wrapped.writeVarUnsignedInt(ival);
        return this;
    }

    @Override
    public long readVarUnsignedLong() {
        this.validateRead(NetMethod.VAR_ULONG);
        long val = this.wrapped.readVarUnsignedLong();
        this.recordRead(NetMethod.VAR_ULONG);
        return val;
    }

    @Override
    public CheckingNetByteBuf writeVarUnsignedLong(long lval) {
        this.write(NetMethod.VAR_ULONG);
        this.wrapped.writeVarUnsignedLong(lval);
        return this;
    }

    @Override
    public int readFixedBits(int length) throws IllegalArgumentException {
        byte len;
        this.validateRead(NetMethod.FIXED_INT);
        if (!this.recordReads && this.typeBuffer != null && (len = this.typeBuffer.readByte()) != length) {
            throw new InvalidNetTypeException(NetMethod.FIXED_INT, this.countRead - 1, "" + len, "" + length);
        }
        int val = this.wrapped.readFixedBits(length);
        this.recordRead(NetMethod.FIXED_INT);
        if (this.recordReads && this.typeBuffer != null) {
            this.typeBuffer.writeByte(length);
        }
        return val;
    }

    @Override
    public CheckingNetByteBuf writeFixedBits(int value, int length) throws IllegalArgumentException {
        this.write(NetMethod.FIXED_INT);
        if (this.typeBuffer != null) {
            this.typeBuffer.writeByte(length);
        }
        this.wrapped.writeFixedBits(value, length);
        return this;
    }

    @Override
    public int method_10816() {
        this.validateRead(NetMethod.VAR_INT);
        int val = this.wrapped.method_10816();
        this.recordRead(NetMethod.VAR_INT);
        return val;
    }

    @Override
    public CheckingNetByteBuf writeVarInt(int ival) {
        this.write(NetMethod.VAR_INT);
        this.wrapped.writeVarInt(ival);
        return this;
    }

    @Override
    public long method_10792() {
        this.validateRead(NetMethod.VAR_LONG);
        long val = this.wrapped.method_10792();
        this.recordRead(NetMethod.VAR_LONG);
        return val;
    }

    @Override
    public CheckingNetByteBuf writeVarLong(long lval) {
        this.write(NetMethod.VAR_LONG);
        this.wrapped.writeVarLong(lval);
        return this;
    }

    @Override
    public boolean isRecordingMarkers() {
        return true;
    }

    @Override
    public void readMarker(String id) {
        String read;
        this.validateRead(NetMethod.CUSTOM_MARKER);
        if (!this.recordReads && this.typeBuffer != null && !id.equals(read = this.typeBuffer.method_19772())) {
            throw new InvalidNetTypeException(NetMethod.CUSTOM_MARKER, this.countRead - 1, read, id);
        }
        this.recordRead(NetMethod.CUSTOM_MARKER);
        if (this.recordReads && this.typeBuffer != null) {
            this.typeBuffer.method_10814(id);
        }
    }

    @Override
    public void writeMarker(String id) {
        this.write(NetMethod.CUSTOM_MARKER);
        if (this.typeBuffer != null) {
            this.typeBuffer.method_10814(id);
        }
    }

    public static enum NetMethod {
        MARKER_ID((buf, to) -> to.append("marker: " + buf.typeBuffer.readVarUnsignedInt())),
        BOOLEAN((buf, to) -> to.append("boolean: ").append(buf.wrapped.readBoolean())),
        BYTE((buf, to) -> to.append("byte: ").append(buf.wrapped.readByte())),
        SHORT((buf, to) -> to.append("short: ").append(buf.wrapped.readShort())),
        MEDIUM((buf, to) -> to.append("medium: ").append(buf.wrapped.readMedium())),
        INT((buf, to) -> to.append("int: ").append(buf.wrapped.readInt())),
        LONG((buf, to) -> to.append("long: ").append(buf.wrapped.readLong())),
        SHORT_LE((buf, to) -> to.append("short(le): ").append(buf.wrapped.readShortLE())),
        MEDIUM_LE((buf, to) -> to.append("medium(le): ").append(buf.wrapped.readMediumLE())),
        INT_LE((buf, to) -> to.append("int(le): ").append(buf.wrapped.readIntLE())),
        LONG_LE((buf, to) -> to.append("long(le): ").append(buf.wrapped.readLongLE())),
        FLOAT((buf, to) -> to.append("float: ").append(buf.wrapped.readFloat())),
        FLOAT_LE((buf, to) -> to.append("float(le): ").append(buf.wrapped.readFloatLE())),
        DOUBLE((buf, to) -> to.append("double: ").append(buf.wrapped.readDouble())),
        DOUBLE_LE((buf, to) -> to.append("double(le): ").append(buf.wrapped.readDoubleLE())),
        CHAR((buf, to) -> {
            to.append("char: ");
            char c = buf.wrapped.readChar();
            if (Character.isISOControl(c)) {
                to.append("0x");
                to.append(Integer.toHexString(c));
            } else {
                to.append("'");
                to.append(c);
                to.append("'");
            }
        }),
        BYTES((buf, to) -> {
            int count = buf.typeBuffer.readVarUnsignedInt();
            NetByteBuf bytes = buf.wrapped.readBytes(count);
            to.append("bytes (" + count + "):\n  ");
            MsgUtil.appendBufferData((ByteBuf)bytes, count, to, "  ", -1);
        }),
        BLOCK_POS((buf, to) -> {
            class_2338 pos = buf.wrapped.method_10811();
            to.append("BlockPos: [ ");
            to.append(pos.method_10263()).append(", ");
            to.append(pos.method_10264()).append(", ");
            to.append(pos.method_10260()).append(" ]");
        }),
        BLOCK_HIT_RESULT((buf, to) -> {
            to.append("BlockHitResult: { ");
            class_3965 hit = buf.wrapped.method_17814();
            to.append("  pos = ").append(hit.method_17777().method_10263()).append(", ");
            to.append(hit.method_17777().method_10264()).append(", ");
            to.append(hit.method_17777().method_10260()).append("\n");
            to.append("  side = ").append(hit.method_17780()).append("\n");
            to.append("  type = ").append(hit.method_17783()).append("\n");
            to.append("  is inside = ").append(hit.method_17781());
        }),
        COMPOUND_TAG((buf, to) -> to.append("nbt: ").append(buf.wrapped.method_10798())),
        STRING((buf, to) -> to.append("string: \"").append(buf.wrapped.method_19772()).append("\"")),
        ENUM((buf, to) -> {
            if (buf.passthrough) {
                int enumCount = buf.typeBuffer.readVarUnsignedInt();
                to.append("enum (").append(enumCount).append("): ");
                to.append(buf.wrapped.method_10816());
            } else {
                int enumCount = buf.typeBuffer.readVarUnsignedInt();
                to.append("enum (").append(enumCount).append("): ");
                int bits = class_3532.method_15342((int)enumCount);
                to.append(buf.wrapped.readFixedBits(bits));
            }
        }),
        VAR_UINT((buf, to) -> to.append("var_uint: ").append(buf.wrapped.readVarUnsignedInt())),
        VAR_ULONG((buf, to) -> to.append("var_ulong: ").append(buf.wrapped.readVarUnsignedLong())),
        FIXED_INT((buf, to) -> {
            byte count = buf.typeBuffer.readByte();
            to.append("fixed_int (" + count + "): ");
            to.append(buf.wrapped.readFixedBits(count));
        }),
        VAR_INT((buf, to) -> to.append("var_int: ").append(buf.wrapped.method_10816())),
        VAR_LONG((buf, to) -> to.append("var_long: ").append(buf.wrapped.method_10792())),
        CUSTOM_MARKER((buf, to) -> to.append("- \"").append(buf.typeBuffer.method_19772()).append("\"")),
        __UNUSED__1(null),
        __UNUSED__2(null),
        __UNUSED__3(null),
        __UNUSED__4(null);

        public final NetMethodAppender appender;

        private NetMethod(NetMethodAppender appender) {
            this.appender = appender;
        }

        @FunctionalInterface
        static interface NetMethodAppender {
            public void readAndAppend(CheckingNetByteBuf var1, StringBuilder var2);
        }
    }

    public static final class InvalidNetTypeException
    extends RuntimeException {
        public final NetMethod written;
        public final NetMethod read;
        public final String writeArgs;
        public final String readArgs;
        public final int index;

        public InvalidNetTypeException(NetMethod written, NetMethod read, int index) {
            super("Read the wrong type! (Wrote " + written + ", but read " + read + " @ " + index + ")");
            this.written = written;
            this.read = read;
            this.writeArgs = "";
            this.readArgs = "";
            this.index = index;
        }

        public InvalidNetTypeException(NetMethod method, int index, String writeArgs, String readArgs) {
            super("Read the wrong extra data for type " + method + "! (Wrote " + writeArgs + ", but read " + readArgs + " @ " + index + ")");
            this.written = method;
            this.read = method;
            this.writeArgs = writeArgs;
            this.readArgs = readArgs;
            this.index = index;
        }
    }
}

