/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.EnumNetSide;
import alexiil.mc.lib.net.InternalMsgUtil;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.LibNetworkStack;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdBase;
import alexiil.mc.lib.net.NetIdPath;
import alexiil.mc.lib.net.NetObjectCacheBase;
import alexiil.mc.lib.net.ParentNetId;
import alexiil.mc.lib.net.TreeNetIdBase;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1657;

public abstract class ActiveConnection {
    final ParentNetId rootId;
    final List<TreeNetIdBase> readMapIds = new ArrayList<TreeNetIdBase>();
    final Object2IntMap<NetIdPath> writeMapIds = new Object2IntOpenHashMap();
    final Map<NetObjectCacheBase<?>, NetObjectCacheBase.Data> caches = new HashMap();
    final Int2ObjectMap<StringTraceSegment> receivedTraceStringSegments;
    final Int2ObjectMap<SingleTraceLine> receivedTraceLines;
    final Int2ObjectMap<MultiTraceLines> receivedJoinedTraces;
    final StringTraceSegment rootTraceSegment;
    int allocatedStringSegemnts;
    int allocatedTraceSegemnts;
    int allocatedJoinedTraces;
    int nextFreeId = 9;
    boolean sendTypes = LibNetworkStack.CONFIG_RECORD_TYPES;
    boolean sendStacktraces = this.isDebuggingConnection();
    int lastReceivedTypesCount;
    NetByteBuf lastReceivedTypes;
    MultiTraceLines lastReceivedStacktrace;

    public ActiveConnection(ParentNetId rootId) {
        this.rootId = rootId;
        for (int i = 0; i < 9; ++i) {
            this.readMapIds.add(null);
        }
        if (LibNetworkStack.CONFIG_RECORD_STACKTRACES) {
            this.receivedTraceStringSegments = new Int2ObjectOpenHashMap();
            this.receivedTraceLines = new Int2ObjectOpenHashMap();
            this.receivedJoinedTraces = new Int2ObjectOpenHashMap();
            this.rootTraceSegment = new StringTraceSegment(0, null, null, null);
        } else {
            this.receivedTraceStringSegments = null;
            this.receivedTraceLines = null;
            this.receivedJoinedTraces = null;
            this.rootTraceSegment = null;
        }
    }

    protected boolean isDebuggingConnection() {
        return false;
    }

    public final void postConstruct() {
        NetByteBuf data;
        if (LibNetworkStack.CONFIG_RECORD_TYPES) {
            data = NetByteBuf.buffer(1);
            data.writeVarInt(7);
            this.sendPacket(data, 7, null, 0);
        }
        if (LibNetworkStack.CONFIG_RECORD_STACKTRACES) {
            data = NetByteBuf.buffer(1);
            data.writeVarInt(8);
            this.sendPacket(data, 8, null, 0);
        }
    }

    public EnumNetSide getNetSide() {
        throw new UnsupportedOperationException("This type of ActiveConnection does not support net-sides.");
    }

    public class_1657 getPlayer() {
        throw new UnsupportedOperationException("This type of ActiveConnection does not support players.");
    }

    protected abstract void sendPacket(NetByteBuf var1, int var2, @Nullable NetIdBase var3, int var4);

    public void flushQueue() {
    }

    public void onReceiveRawData(NetByteBuf data) throws InvalidInputDataException {
        InternalMsgUtil.onReceive(this, data);
    }

    public NetByteBuf allocBuffer() {
        return NetByteBuf.buffer();
    }

    public NetByteBuf allocBuffer(int initialCapacity) {
        return NetByteBuf.buffer(initialCapacity);
    }

    <T> NetObjectCacheBase.Data getCacheData(NetObjectCacheBase<T> cache) {
        return this.caches.computeIfAbsent(cache, c -> {
            NetObjectCacheBase netObjectCacheBase = c;
            Objects.requireNonNull(netObjectCacheBase);
            return new NetObjectCacheBase.Data(netObjectCacheBase, this);
        });
    }

    static final class StringTraceSegment {
        final int id;
        final StringTraceSegment parent;
        final StringTraceSeparator separator;
        final String str;
        final Map<String, StringTraceSegment> dotChildren = new HashMap<String, StringTraceSegment>();
        final Map<String, StringTraceSegment> slashChildren = new HashMap<String, StringTraceSegment>();
        final Map<String, StringTraceSegment> dollarChildren = new HashMap<String, StringTraceSegment>();
        final Int2ObjectMap<SingleTraceLine> lineChildren = new Int2ObjectOpenHashMap();

        public StringTraceSegment(int id, StringTraceSegment parent, StringTraceSeparator separator, String str) {
            this.id = id;
            this.separator = separator;
            this.str = str;
            StringTraceSegment stringTraceSegment = parent == null ? null : (this.parent = parent.separator == null ? null : parent);
            if (parent != null) {
                parent.getCharChild(separator).put(str, this);
            }
        }

        Map<String, StringTraceSegment> getCharChild(StringTraceSeparator sep) {
            switch (sep) {
                case DOT: {
                    return this.dotChildren;
                }
                case SLASH: {
                    return this.slashChildren;
                }
                case DOLLAR: {
                    return this.dollarChildren;
                }
            }
            throw new IllegalArgumentException("Unknown StringTraceSeparator " + sep);
        }

        public String toString() {
            if (this.parent == null) {
                return this.str;
            }
            return this.parent.toString() + this.separator.separator + this.str;
        }
    }

    static enum StringTraceSeparator {
        DOT('.'),
        SLASH('/'),
        DOLLAR('$');

        final char separator;

        private StringTraceSeparator(char separator) {
            this.separator = separator;
        }

        @Nullable
        static StringTraceSeparator from(char c) {
            switch (c) {
                case '.': {
                    return DOT;
                }
                case '/': {
                    return SLASH;
                }
            }
            return null;
        }
    }

    static final class MultiTraceLines {
        final int id;
        final MultiTraceLines parent;
        final SingleTraceLine line;

        public MultiTraceLines(int id, MultiTraceLines parent, SingleTraceLine line) {
            this.id = id;
            this.parent = parent;
            this.line = line;
            line.children.put(parent, this);
        }

        public String toString() {
            if (this.parent == null) {
                return this.line.toString();
            }
            return this.line.toString() + "\n at " + this.parent.toString();
        }
    }

    static final class SingleTraceLine {
        final int id;
        final StringTraceSegment str;
        final int lineNumber;
        final Map<MultiTraceLines, MultiTraceLines> children = new HashMap<MultiTraceLines, MultiTraceLines>();

        public SingleTraceLine(int id, StringTraceSegment str, int lineNumber) {
            this.id = id;
            this.str = str;
            this.lineNumber = lineNumber;
            str.lineChildren.put(lineNumber, (Object)this);
        }

        public String toString() {
            return this.str + "():" + this.lineNumber;
        }
    }
}

