/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.hats.witch;

import eu.midnightdust.hats.web.HatLoader;
import eu.midnightdust.hats.witch.WitchHatModel;
import eu.midnightdust.lib.util.MidnightColorUtil;
import java.awt.Color;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3882;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_583;

@Environment(value=EnvType.CLIENT)
public class WitchHatFeatureRenderer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    public static final class_5601 WITCH_HAT_MODEL_LAYER = new class_5601(new class_2960("midnight-hats", "witch_hat"), "main");
    private static final UUID MOTSCHEN = UUID.fromString("a44c2660-630f-478f-946a-e518669fcf0c");
    private static final class_2960 WITCH = new class_2960("textures/entity/witch.png");
    private static final class_2960 OVERLAY = new class_2960("midnightlib", "textures/hats/overlay.png");
    private static final Color MOTSCHEN_COLOR = MidnightColorUtil.radialRainbow(1.0f, 1.0f);
    private static final Color ADOPTER_COLOR = MidnightColorUtil.hex2Rgb("ffffff");
    private static final Color MODDER_COLOR = MidnightColorUtil.hex2Rgb("7825b4");
    private static final Color FRIEND_COLOR = MidnightColorUtil.hex2Rgb("ff0234");
    private static final Color DONOR_COLOR = MidnightColorUtil.hex2Rgb("ff6c00");
    private static final Color SOCIAL_COLOR = MidnightColorUtil.hex2Rgb("238a9d");
    private final WitchHatModel<T> witchHat;
    private final class_310 client = class_310.method_1551();

    public WitchHatFeatureRenderer(class_3883<T, M> featureRendererContext, class_5599 entityModelLoader) {
        super(featureRendererContext);
        this.witchHat = new WitchHatModel(entityModelLoader.method_32072(WITCH_HAT_MODEL_LAYER));
    }

    public static class_5607 getTexturedModelData() {
        return class_5607.method_32110((class_5609)WitchHatModel.getModelData(), (int)64, (int)128);
    }

    public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l) {
        Color hat_type = this.getHat(livingEntity.method_5667());
        if (hat_type != null && !livingEntity.method_5756((class_1657)this.client.field_1724)) {
            if (hat_type == MOTSCHEN_COLOR) {
                hat_type = MidnightColorUtil.radialRainbow(1.0f, 1.0f);
            }
            matrixStack.method_22903();
            ((class_3882)this.method_17165()).method_2838().method_22703(matrixStack);
            class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)WITCH));
            this.witchHat.method_2828(matrixStack, vertexConsumer, i, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            class_4588 glow = vertexConsumerProvider.getBuffer(class_1921.method_23592((class_2960)OVERLAY, (boolean)true));
            matrixStack.method_46416(0.0f, 0.0f, -0.001f);
            this.witchHat.method_2828(matrixStack, glow, 230, class_4608.field_21444, (float)hat_type.getRed() / 255.0f, (float)hat_type.getGreen() / 255.0f, (float)hat_type.getBlue() / 255.0f, 1.0f);
            matrixStack.method_22909();
        }
    }

    private Color getHat(UUID uuid) {
        if (uuid.equals(MOTSCHEN)) {
            return MOTSCHEN_COLOR;
        }
        if (HatLoader.PLAYER_HATS != null && HatLoader.PLAYER_HATS.containsKey(uuid)) {
            return switch (HatLoader.PLAYER_HATS.get(uuid).getHatType()) {
                case "adopter" -> ADOPTER_COLOR;
                case "contributer", "modder" -> MODDER_COLOR;
                case "friend" -> FRIEND_COLOR;
                case "donator", "donor" -> DONOR_COLOR;
                case "social" -> SOCIAL_COLOR;
                default -> MidnightColorUtil.hex2Rgb(HatLoader.PLAYER_HATS.get(uuid).getHatType());
            };
        }
        return null;
    }
}

