/*
 * Decompiled with CFR 0.152.
 */
package io.github.stuff_stuffs.multipart_entities.common.util;

import com.google.common.collect.Iterators;
import io.github.stuff_stuffs.multipart_entities.common.entity.MutableBox;
import io.github.stuff_stuffs.multipart_entities.common.util.OrientedBox;
import io.github.stuff_stuffs.multipart_entities.mixin.common.InvokerArrayVoxelShape;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_244;
import net.minecraft.class_251;
import net.minecraft.class_259;
import net.minecraft.class_265;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompoundOrientedBox
extends class_238
implements Iterable<OrientedBox> {
    private final Collection<OrientedBox> boxes;
    private class_265 cached;
    @Nullable
    private final MutableBox overrideBox;

    public CompoundOrientedBox(class_238 bounds, Collection<OrientedBox> boxes, MutableBox overrideBox) {
        this(bounds.field_1323, bounds.field_1322, bounds.field_1321, bounds.field_1320, bounds.field_1325, bounds.field_1324, boxes, overrideBox);
    }

    public CompoundOrientedBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Collection<OrientedBox> boxes, @Nullable MutableBox overrideBox) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.boxes = boxes;
        this.overrideBox = overrideBox;
    }

    private CompoundOrientedBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Collection<OrientedBox> boxes, class_265 cached, @Nullable MutableBox overrideBox) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.boxes = boxes;
        this.cached = cached;
        this.overrideBox = overrideBox;
    }

    public class_238 method_1009(double x, double y, double z) {
        ObjectArrayList orientedBoxes = new ObjectArrayList(this.boxes.size());
        for (OrientedBox box : this.boxes) {
            orientedBoxes.add(box.expand(x, y, z));
        }
        MutableBox overrideBox = null;
        if (this.overrideBox != null) {
            overrideBox = new MutableBox(this.overrideBox.getBox().method_1009(x, y, z));
        }
        if (this.cached != null) {
            return new CompoundOrientedBox(this.field_1323 - x, this.field_1322 - y, this.field_1321 - z, this.field_1320 + x, this.field_1325 + y, this.field_1324 + z, (Collection<OrientedBox>)orientedBoxes, this.cached.method_1096(x, y, z), overrideBox);
        }
        return new CompoundOrientedBox(this.field_1323 - x, this.field_1322 - y, this.field_1321 - z, this.field_1320 + x, this.field_1325 + y, this.field_1324 + z, (Collection<OrientedBox>)orientedBoxes, overrideBox);
    }

    public class_238 method_989(double x, double y, double z) {
        ObjectArrayList orientedBoxes = new ObjectArrayList(this.boxes.size());
        for (OrientedBox box : this.boxes) {
            orientedBoxes.add(box.offset(x, y, z));
        }
        MutableBox overrideBox = null;
        if (this.overrideBox != null) {
            overrideBox = new MutableBox(this.overrideBox.getBox().method_989(x, y, z));
        }
        if (this.cached != null) {
            return new CompoundOrientedBox(this.field_1323 + x, this.field_1322 + y, this.field_1321 + z, this.field_1320 + x, this.field_1325 + y, this.field_1324 + z, (Collection<OrientedBox>)orientedBoxes, this.cached.method_1096(x, y, z), overrideBox);
        }
        return new CompoundOrientedBox(this.field_1323 + x, this.field_1322 + y, this.field_1321 + z, this.field_1320 + x, this.field_1325 + y, this.field_1324 + z, (Collection<OrientedBox>)orientedBoxes, overrideBox);
    }

    public class_238 method_996(class_2338 blockPos) {
        return this.method_989(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    public Optional<class_243> method_992(class_243 min, class_243 max) {
        double t = Double.MAX_VALUE;
        for (OrientedBox box : this.boxes) {
            double tmp = box.raycast(min, max);
            if (tmp == -1.0) continue;
            t = Math.min(t, tmp);
        }
        if (t != Double.MAX_VALUE) {
            double d = max.field_1352 - min.field_1352;
            double e = max.field_1351 - min.field_1351;
            double f = max.field_1350 - min.field_1350;
            return Optional.of(min.method_1031(t * d, t * e, t * f));
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public Iterator<OrientedBox> iterator() {
        return Iterators.unmodifiableIterator(this.boxes.iterator());
    }

    public boolean method_1003(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.method_994(new class_238(minX, minY, minZ, maxX, maxY, maxZ));
    }

    public boolean method_994(class_238 box) {
        class_243[] vertices = OrientedBox.getVertices(box);
        for (OrientedBox orientedBox : this.boxes) {
            if (!orientedBox.intersects(vertices)) continue;
            return true;
        }
        return false;
    }

    public class_265 toVoxelShape() {
        if (this.cached != null) {
            return this.cached;
        }
        if (this.overrideBox != null) {
            this.cached = class_259.method_1078((class_238)this.overrideBox.getBox());
            return this.cached;
        }
        double minX = this.method_1001(class_2350.class_2351.field_11048) + 1.0E-4;
        double minY = this.method_1001(class_2350.class_2351.field_11052) + 1.0E-4;
        double minZ = this.method_1001(class_2350.class_2351.field_11051) + 1.0E-4;
        double deltaX = this.method_990(class_2350.class_2351.field_11048) - minX;
        double deltaY = this.method_990(class_2350.class_2351.field_11052) - minY;
        double deltaZ = this.method_990(class_2350.class_2351.field_11051) - minZ;
        double resolution = 4.0;
        int xResolution = (int)Math.ceil(deltaX * resolution + 1.0E-4);
        int yResolution = (int)Math.ceil(deltaY * resolution + 1.0E-4);
        int zResolution = (int)Math.ceil(deltaZ * resolution + 1.0E-4);
        class_244 bitSet = new class_244(xResolution, yResolution, zResolution);
        for (int i = 0; i < xResolution; ++i) {
            double x = minX + (double)i / resolution;
            for (int j = 0; j < zResolution; ++j) {
                double z = minZ + (double)j / resolution;
                for (int k = 0; k < yResolution; ++k) {
                    double y = minY + (double)k / resolution;
                    class_238 box = new class_238(x, y, z, x + 0.9999 / (double)xResolution, y + 0.9999 / (double)yResolution, z + 0.9999 / (double)zResolution);
                    if (!this.method_994(box)) continue;
                    bitSet.method_1049(i, k, j);
                }
            }
        }
        DoubleArrayList xPoints = new DoubleArrayList(xResolution + 1);
        for (int i = 0; i < xResolution + 1; ++i) {
            xPoints.add(minX + (double)i / resolution);
        }
        DoubleArrayList yPoints = new DoubleArrayList(yResolution + 1);
        for (int i = 0; i < yResolution + 1; ++i) {
            yPoints.add(minY + (double)i / resolution);
        }
        DoubleArrayList zPoints = new DoubleArrayList(zResolution + 1);
        for (int i = 0; i < zResolution + 1; ++i) {
            zPoints.add(minZ + (double)i / resolution);
        }
        this.cached = InvokerArrayVoxelShape.init((class_251)bitSet, (DoubleList)xPoints, (DoubleList)yPoints, (DoubleList)zPoints);
        return this.cached;
    }

    public boolean method_1008(double x, double y, double z) {
        for (OrientedBox box : this.boxes) {
            if (!box.contains(x, y, z)) continue;
            return true;
        }
        return false;
    }

    public CompoundOrientedBox withBounds(class_238 bounds) {
        return new CompoundOrientedBox(bounds, (Collection<OrientedBox>)new ObjectArrayList(this.boxes), this.overrideBox);
    }

    public double calculateMaxDistance(class_2350.class_2351 axis, class_265 voxelShape, double maxDist) {
        for (class_238 boundingBox : this.toVoxelShape().method_1090()) {
            maxDist = voxelShape.method_1108(axis, boundingBox, maxDist);
            if (!(Math.abs(maxDist) < 1.0E-4)) continue;
            return 0.0;
        }
        return maxDist;
    }
}

