/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.conditionalmixin.api.util;

import java.lang.reflect.Method;
import java.util.Collection;
import me.fallenbreath.conditionalmixin.ConditionalMixinMod;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;

public class VersionChecker {
    public static boolean doesVersionSatisfyPredicate(Version version, String versionPredicate) {
        try {
            return VersionPredicate.parse((String)versionPredicate).test((Object)version);
        }
        catch (NoClassDefFoundError e) {
            try {
                Class<?> clazz = Class.forName("net.fabricmc.loader.util.version.VersionPredicateParser");
                Method matches = clazz.getMethod("matches", Version.class, String.class);
                return (Boolean)matches.invoke(null, version, versionPredicate);
            }
            catch (Exception ex) {
                ConditionalMixinMod.LOGGER.error("Failed to invoke VersionPredicateParser#matches", (Throwable)ex);
            }
        }
        catch (Exception e) {
            ConditionalMixinMod.LOGGER.error("Failed to parse version or version predicate {} {}: {}", (Object)version.getFriendlyString(), (Object)versionPredicate, (Object)e);
        }
        return false;
    }

    public static boolean doesVersionSatisfyPredicate(Version version, Collection<String> versionPredicates) {
        return versionPredicates.isEmpty() || versionPredicates.stream().anyMatch(vp -> VersionChecker.doesVersionSatisfyPredicate(version, vp));
    }
}

