/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.RegionSummary;
import folk.sisby.surveyor.util.ChunkUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_5321;

public class WorldTerrainSummary {
    protected final class_5321<class_1937> worldKey;
    protected final Map<class_1923, RegionSummary> regions = new ConcurrentHashMap<class_1923, RegionSummary>();

    public WorldTerrainSummary(class_5321<class_1937> worldKey, Map<class_1923, RegionSummary> regions) {
        this.worldKey = worldKey;
        this.regions.putAll(regions);
    }

    protected static class_1923 regionPosOf(class_1923 pos) {
        return new class_1923(pos.field_9181 >> 5, pos.field_9180 >> 5);
    }

    public boolean contains(class_1923 pos) {
        class_1923 regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.containsKey(regionPos) && this.regions.get(regionPos).contains(pos);
    }

    public ChunkSummary get(class_1923 pos) {
        class_1923 regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.get(regionPos).get(pos);
    }

    public RegionSummary getRegion(class_1923 regionPos) {
        return this.regions.computeIfAbsent(regionPos, k -> new RegionSummary());
    }

    public class_2359<class_1959> getBiomePalette(class_1923 pos) {
        class_1923 regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.get(regionPos).getBiomePalette();
    }

    public class_2359<class_2248> getBlockPalette(class_1923 pos) {
        class_1923 regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.get(regionPos).getBlockPalette();
    }

    public Map<class_1923, BitSet> bitSet(SurveyorExploration exploration) {
        HashMap<class_1923, BitSet> map = new HashMap<class_1923, BitSet>();
        this.regions.forEach((p, r) -> map.put((class_1923)p, r.bitSet()));
        return exploration == null ? map : exploration.limitTerrainBitset(this.worldKey, map);
    }

    public static Set<class_1923> toKeys(Map<class_1923, BitSet> bitSets) {
        return WorldTerrainSummary.toKeys(bitSets, Comparator.comparingInt(pos -> pos.field_9181 + pos.field_9180));
    }

    public static Set<class_1923> toKeys(Map<class_1923, BitSet> bitSets, class_1923 originChunk) {
        class_1923 oPos = new class_1923(RegionSummary.chunkToRegion(originChunk.field_9181), RegionSummary.chunkToRegion(originChunk.field_9180));
        return WorldTerrainSummary.toKeys(bitSets, Comparator.comparingDouble(pos -> (oPos.field_9181 - pos.field_9181) * (oPos.field_9181 - pos.field_9181) + (oPos.field_9180 - pos.field_9180) * (oPos.field_9180 - pos.field_9180)));
    }

    public static Set<class_1923> toKeys(Map<class_1923, BitSet> bitSets, Comparator<class_1923> regionComparator) {
        LinkedHashSet<class_1923> set = new LinkedHashSet<class_1923>();
        bitSets.entrySet().stream().sorted(Map.Entry.comparingByKey(regionComparator)).forEach(e -> ((BitSet)e.getValue()).stream().forEach(i -> set.add(RegionSummary.chunkForBit((class_1923)e.getKey(), i))));
        return set;
    }

    public void put(class_1937 world, class_2791 chunk) {
        this.regions.computeIfAbsent(WorldTerrainSummary.regionPosOf(chunk.method_12004()), k -> new RegionSummary()).putChunk(world, chunk);
        SurveyorEvents.Invoke.terrainUpdated(world, chunk.method_12004());
    }

    public int save(class_1937 world, File folder) {
        ArrayList savedRegions = new ArrayList();
        this.regions.forEach((pos, summary) -> {
            if (!summary.isDirty()) {
                return;
            }
            savedRegions.add(pos);
            class_2487 regionCompound = summary.writeNbt(world.method_30349(), new class_2487(), (class_1923)pos);
            File regionFile = new File(folder, "c.%d.%d.dat".formatted(pos.field_9181, pos.field_9180));
            try {
                class_2507.method_30614((class_2487)regionCompound, (File)regionFile);
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error writing region summary file {}.", (Object)regionFile.getName(), (Object)e);
            }
        });
        return savedRegions.size();
    }

    public static WorldTerrainSummary load(class_1937 world, File folder) {
        File[] chunkFiles = folder.listFiles((file, name) -> {
            String[] split = name.split("\\.");
            if (split.length == 4 && split[0].equals("c") && split[3].equals("dat")) {
                try {
                    Integer.parseInt(split[1]);
                    Integer.parseInt(split[2]);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        });
        HashMap<class_1923, RegionSummary> regions = new HashMap<class_1923, RegionSummary>();
        if (chunkFiles != null) {
            for (File regionFile : chunkFiles) {
                class_1923 regionPos = new class_1923(Integer.parseInt(regionFile.getName().split("\\.")[1]), Integer.parseInt(regionFile.getName().split("\\.")[2]));
                class_2487 regionCompound = null;
                try {
                    regionCompound = class_2507.method_30613((File)regionFile);
                }
                catch (IOException e) {
                    Surveyor.LOGGER.error("[Surveyor] Error loading region summary file {}.", (Object)regionFile.getName(), (Object)e);
                }
                if (regionCompound == null) continue;
                regions.put(regionPos, new RegionSummary().readNbt(regionCompound, world.method_30349()));
            }
        }
        return new WorldTerrainSummary((class_5321<class_1937>)world.method_27983(), regions);
    }

    public static void onChunkLoad(class_1937 world, class_2791 chunk) {
        WorldSummary summary = WorldSummary.of(world);
        if (!summary.terrain().contains(chunk.method_12004()) || !ChunkUtil.airCount(chunk).equals(summary.terrain().get(chunk.method_12004()).getAirCount())) {
            summary.terrain().put(world, chunk);
        }
    }

    public static void onChunkUnload(class_1937 world, class_2818 chunk) {
        WorldSummary summary = WorldSummary.of(world);
        if (chunk.method_12044()) {
            summary.terrain().put(world, (class_2791)chunk);
        }
    }
}

