/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.DimensionSupport;
import folk.sisby.surveyor.util.PaletteUtil;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3513;
import net.minecraft.class_5455;
import net.minecraft.class_7924;

public class RegionSummary {
    public static final int REGION_POWER = 5;
    public static final int REGION_SIZE = 32;
    public static final int BITSET_SIZE = 1024;
    public static final String KEY_BIOMES = "biomes";
    public static final String KEY_BLOCKS = "blocks";
    public static final String KEY_BIOME_WATER = "biomeWater";
    public static final String KEY_BIOME_FOLIAGE = "biomeFoliage";
    public static final String KEY_BIOME_GRASS = "biomeGrass";
    public static final String KEY_BLOCK_COLORS = "blockColors";
    public static final String KEY_CHUNKS = "chunks";
    protected final class_3513<class_1959> biomePalette = class_3513.method_37913((int)255);
    protected final class_3513<Integer> rawBiomePalette = class_3513.method_37913((int)255);
    protected final class_3513<class_2248> blockPalette = class_3513.method_37913((int)255);
    protected final class_3513<Integer> rawBlockPalette = class_3513.method_37913((int)255);
    protected ChunkSummary[][] chunks = new ChunkSummary[32][32];
    protected boolean dirty = false;

    public static <T, O> List<O> mapPalette(class_2359<T> palette, Function<T, O> mapper) {
        ArrayList<O> list = new ArrayList<O>();
        for (int i = 0; i < palette.method_10204(); ++i) {
            list.add(mapper.apply(palette.method_10200(i)));
        }
        return list;
    }

    public static int regionToChunk(int xz) {
        return xz << 5;
    }

    public static int chunkToRegion(int xz) {
        return xz >> 5;
    }

    public static int regionRelative(int xz) {
        return xz & 0x1F;
    }

    public static int bitForXZ(int x, int z) {
        return (x << 5) + z;
    }

    public static int bitForChunk(class_1923 pos) {
        return RegionSummary.bitForXZ(RegionSummary.regionRelative(pos.field_9181), RegionSummary.regionRelative(pos.field_9180));
    }

    public static int xForBit(int i) {
        return i >> 5;
    }

    public static int zForBit(int i) {
        return i & 0x1F;
    }

    public static class_1923 chunkForBit(class_1923 rPos, int i) {
        return new class_1923(RegionSummary.regionToChunk(rPos.field_9181) + RegionSummary.xForBit(i), RegionSummary.regionToChunk(rPos.field_9180) + RegionSummary.zForBit(i));
    }

    public boolean contains(class_1923 pos) {
        return this.chunks[RegionSummary.regionRelative(pos.field_9181)][RegionSummary.regionRelative(pos.field_9180)] != null;
    }

    public ChunkSummary get(class_1923 pos) {
        return this.chunks[RegionSummary.regionRelative(pos.field_9181)][RegionSummary.regionRelative(pos.field_9180)];
    }

    public BitSet bitSet() {
        BitSet bitSet = new BitSet(1024);
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                if (this.chunks[x][z] == null) continue;
                bitSet.set(RegionSummary.bitForXZ(x, z));
            }
        }
        return bitSet;
    }

    public void putChunk(class_1937 world, class_2791 chunk) {
        this.chunks[RegionSummary.regionRelative((int)chunk.method_12004().field_9181)][RegionSummary.regionRelative((int)chunk.method_12004().field_9180)] = new ChunkSummary(world, chunk, DimensionSupport.getSummaryLayers(world), this.biomePalette, this.rawBiomePalette, this.blockPalette, this.rawBlockPalette, !(world instanceof class_3218));
        this.dirty = true;
    }

    public RegionSummary readNbt(class_2487 nbt, class_5455 manager) {
        class_2378 biomeRegistry = manager.method_30530(class_7924.field_41236);
        class_2378 blockRegistry = manager.method_30530(class_7924.field_41254);
        nbt.method_10554(KEY_BIOMES, 8).stream().map(e -> (class_1959)biomeRegistry.method_10223(new class_2960(e.method_10714()))).forEach(b -> {
            this.biomePalette.method_15225(b);
            this.rawBiomePalette.method_15225((Object)biomeRegistry.method_10206(b));
        });
        nbt.method_10554(KEY_BLOCKS, 8).stream().map(e -> (class_2248)blockRegistry.method_10223(new class_2960(e.method_10714()))).forEach(b -> {
            this.blockPalette.method_15225(b);
            this.rawBlockPalette.method_15225((Object)blockRegistry.method_10206(b));
        });
        class_2487 chunksCompound = nbt.method_10562(KEY_CHUNKS);
        for (String posKey : chunksCompound.method_10541()) {
            int x = RegionSummary.regionRelative(Integer.parseInt(posKey.split(",")[0]));
            int z = RegionSummary.regionRelative(Integer.parseInt(posKey.split(",")[1]));
            this.chunks[x][z] = new ChunkSummary(chunksCompound.method_10562(posKey));
        }
        return this;
    }

    public class_2487 writeNbt(class_5455 manager, class_2487 nbt, class_1923 regionPos) {
        nbt.method_10566(KEY_BIOMES, (class_2520)new class_2499(RegionSummary.mapPalette(this.biomePalette, b -> class_2519.method_23256((String)manager.method_30530(class_7924.field_41236).method_10221(b).toString())), 8));
        nbt.method_10566(KEY_BLOCKS, (class_2520)new class_2499(RegionSummary.mapPalette(this.blockPalette, b -> class_2519.method_23256((String)manager.method_30530(class_7924.field_41254).method_10221(b).toString())), 8));
        nbt.method_10572(KEY_BIOME_WATER, RegionSummary.mapPalette(this.biomePalette, class_1959::method_8687));
        nbt.method_10572(KEY_BIOME_FOLIAGE, RegionSummary.mapPalette(this.biomePalette, class_1959::method_8698));
        nbt.method_10572(KEY_BIOME_GRASS, RegionSummary.mapPalette(this.biomePalette, b -> b.method_8711(0.0, 0.0)));
        nbt.method_10572(KEY_BLOCK_COLORS, RegionSummary.mapPalette(this.blockPalette, b -> b.method_26403().field_16011));
        class_2487 chunksCompound = new class_2487();
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                if (this.chunks[x][z] == null) continue;
                chunksCompound.method_10566("%s,%s".formatted((regionPos.field_9181 << 5) + x, (regionPos.field_9180 << 5) + z), (class_2520)this.chunks[x][z].writeNbt(new class_2487()));
            }
        }
        nbt.method_10566(KEY_CHUNKS, (class_2520)chunksCompound);
        return nbt;
    }

    public BitSet readBuf(class_5455 manager, class_2540 buf) {
        class_2378 biomeRegistry = manager.method_30530(class_7924.field_41236);
        int[] rawBiomes = buf.method_34066(class_2540::method_10816).stream().mapToInt(i -> i).toArray();
        Int2IntArrayMap biomeRemap = new Int2IntArrayMap();
        for (int i2 = 0; i2 < rawBiomes.length; ++i2) {
            biomeRemap.put(i2, PaletteUtil.rawIdOrAdd(this.biomePalette, this.rawBiomePalette, rawBiomes[i2], biomeRegistry));
        }
        class_2378 blockRegistry = manager.method_30530(class_7924.field_41254);
        int[] rawBlocks = buf.method_34066(class_2540::method_10816).stream().mapToInt(i -> i).toArray();
        Int2IntArrayMap blockRemap = new Int2IntArrayMap();
        for (int i3 = 0; i3 < rawBlocks.length; ++i3) {
            blockRemap.put(i3, PaletteUtil.rawIdOrAdd(this.blockPalette, this.rawBlockPalette, rawBlocks[i3], blockRegistry));
        }
        BitSet set = buf.method_33558();
        int[] indices = set.stream().toArray();
        ArrayList summaries = (ArrayList)buf.method_34068(ArrayList::new, ChunkSummary::new);
        for (int i4 = 0; i4 < summaries.size(); ++i4) {
            ChunkSummary summary = (ChunkSummary)summaries.get(i4);
            summary.remap((Map<Integer, Integer>)biomeRemap, (Map<Integer, Integer>)blockRemap);
            this.chunks[RegionSummary.xForBit((int)indices[i4])][RegionSummary.zForBit((int)indices[i4])] = summary;
        }
        this.dirty = true;
        return set;
    }

    public class_2540 writeBuf(class_2540 buf, BitSet set) {
        buf.method_34062(RegionSummary.mapPalette(this.rawBiomePalette, i -> i), class_2540::method_10804);
        buf.method_34062(RegionSummary.mapPalette(this.rawBlockPalette, i -> i), class_2540::method_10804);
        buf.method_33557(set);
        buf.method_34062(set.stream().mapToObj(i -> this.chunks[RegionSummary.xForBit(i)][RegionSummary.zForBit(i)]).toList(), (b, summary) -> summary.writeBuf((class_2540)b));
        return buf;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public class_2359<class_1959> getBiomePalette() {
        return this.biomePalette;
    }

    public class_2359<class_2248> getBlockPalette() {
        return this.blockPalette;
    }
}

