/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.structure;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.structure.JigsawPieceSummary;
import folk.sisby.surveyor.structure.StructurePieceSummary;
import folk.sisby.surveyor.structure.StructureStartSummary;
import folk.sisby.surveyor.util.MapUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3773;
import net.minecraft.class_5321;
import net.minecraft.class_6625;
import net.minecraft.class_6862;
import net.minecraft.class_7151;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class WorldStructureSummary {
    public static final String KEY_STRUCTURES = "structures";
    public static final String KEY_TYPE = "type";
    public static final String KEY_TAGS = "tags";
    public static final String KEY_STARTS = "starts";
    public static final String KEY_PIECES = "pieces";
    protected final class_5321<class_1937> worldKey;
    protected final Map<class_5321<class_3195>, Map<class_1923, StructureStartSummary>> structures = new ConcurrentHashMap<class_5321<class_3195>, Map<class_1923, StructureStartSummary>>();
    protected final Map<class_5321<class_3195>, class_5321<class_7151<?>>> structureTypes = new ConcurrentHashMap();
    protected final Multimap<class_5321<class_3195>, class_6862<class_3195>> structureTags = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    protected boolean dirty = false;

    public WorldStructureSummary(class_5321<class_1937> worldKey, Map<class_5321<class_3195>, Map<class_1923, StructureStartSummary>> structures, Map<class_5321<class_3195>, class_5321<class_7151<?>>> structureTypes, Multimap<class_5321<class_3195>, class_6862<class_3195>> structureTags) {
        this.worldKey = worldKey;
        this.structures.putAll(structures);
        this.structureTypes.putAll(structureTypes);
        this.structureTags.putAll(structureTags);
    }

    public class_5321<class_7151<?>> getType(class_5321<class_3195> key) {
        return this.structureTypes.get(key);
    }

    public Collection<class_6862<class_3195>> getTags(class_5321<class_3195> key) {
        return this.structureTags.get(key);
    }

    public boolean contains(class_1937 world, class_3449 start) {
        class_5321 key = (class_5321)world.method_30349().method_30530(class_7924.field_41246).method_29113((Object)start.method_16656()).orElseThrow();
        return this.structures.containsKey(key) && this.structures.get(key).containsKey(start.method_34000());
    }

    public boolean contains(class_5321<class_3195> key, class_1923 pos) {
        return this.structures.containsKey(key) && this.structures.get(key).containsKey(pos);
    }

    public StructureStartSummary get(class_5321<class_3195> key, class_1923 pos) {
        return this.structures.get(key).get(pos);
    }

    public Map<class_5321<class_3195>, Map<class_1923, StructureStartSummary>> asMap(SurveyorExploration exploration) {
        Multimap<class_5321<class_3195>, class_1923> keySet = this.keySet(exploration);
        HashMap<class_5321<class_3195>, Map<class_1923, StructureStartSummary>> map = new HashMap<class_5321<class_3195>, Map<class_1923, StructureStartSummary>>();
        keySet.forEach((key, pos) -> map.computeIfAbsent((class_5321<class_3195>)key, k -> new HashMap()).put(pos, this.get((class_5321<class_3195>)key, (class_1923)pos)));
        return map;
    }

    public Multimap<class_5321<class_3195>, class_1923> keySet(SurveyorExploration exploration) {
        Multimap<class_5321<class_3195>, class_1923> map = MapUtil.keyMultiMap(this.structures);
        if (exploration != null) {
            exploration.limitStructureKeySet(this.worldKey, map);
        }
        return map;
    }

    protected static StructureStartSummary summarisePieces(class_6625 context, class_3449 start) {
        ArrayList<StructurePieceSummary> pieces = new ArrayList<StructurePieceSummary>();
        for (class_3443 piece : start.method_14963()) {
            if (piece.method_16653().equals(class_3773.field_25840)) {
                pieces.addAll(JigsawPieceSummary.tryFromPiece(piece));
                continue;
            }
            pieces.add(StructurePieceSummary.fromPiece(context, piece, start.method_14963().size() <= 10));
        }
        return new StructureStartSummary(pieces);
    }

    public void put(class_3218 world, class_3449 start) {
        class_5321 key = (class_5321)world.method_30349().method_30530(class_7924.field_41246).method_29113((Object)start.method_16656()).orElseThrow();
        this.structures.computeIfAbsent((class_5321<class_3195>)key, k -> new ConcurrentHashMap());
        class_1923 pos = start.method_34000();
        if (!this.structures.get(key).containsKey(pos)) {
            StructureStartSummary summary = WorldStructureSummary.summarisePieces(class_6625.method_38713((class_3218)world), start);
            class_5321 type = (class_5321)world.method_30349().method_30530(class_7924.field_41231).method_29113((Object)start.method_16656().method_41618()).orElseThrow();
            List tags = world.method_30349().method_30530(class_7924.field_41246).method_47983((Object)start.method_16656()).method_40228().toList();
            this.structures.get(key).put(pos, summary);
            this.structureTypes.put((class_5321<class_3195>)key, type);
            this.structureTags.putAll((Object)key, tags);
            this.dirty = true;
            SurveyorEvents.Invoke.structuresAdded((class_1937)world, (class_5321<class_3195>)key, pos);
        }
    }

    public void put(class_1937 world, class_5321<class_3195> key, class_1923 pos, StructureStartSummary summary, class_5321<class_7151<?>> type, Collection<class_6862<class_3195>> tagKeys) {
        this.structures.computeIfAbsent(key, k -> new ConcurrentHashMap()).put(pos, summary);
        this.structureTypes.put(key, type);
        this.structureTags.putAll(key, tagKeys);
        this.dirty = true;
        SurveyorEvents.Invoke.structuresAdded(world, key, pos);
    }

    protected class_2487 writeNbt(class_2487 nbt) {
        class_2487 structuresCompound = new class_2487();
        this.structures.forEach((key, starts) -> {
            class_2487 structureCompound = new class_2487();
            structureCompound.method_10582(KEY_TYPE, this.structureTypes.get(key).method_29177().toString());
            structureCompound.method_10566(KEY_TAGS, (class_2520)new class_2499(this.structureTags.get(key).stream().map(t -> class_2519.method_23256((String)t.comp_327().toString())).toList(), 8));
            class_2487 startsCompound = new class_2487();
            starts.forEach((pos, summary) -> {
                class_2499 pieceList = new class_2499(summary.getChildren().stream().map(p -> p.toNbt()).toList(), 10);
                class_2487 startCompound = new class_2487();
                startCompound.method_10566(KEY_PIECES, (class_2520)pieceList);
                startsCompound.method_10566("%s,%s".formatted(pos.field_9181, pos.field_9180), (class_2520)startCompound);
            });
            structureCompound.method_10566(KEY_STARTS, (class_2520)startsCompound);
            structuresCompound.method_10566(key.method_29177().toString(), (class_2520)structureCompound);
        });
        nbt.method_10566(KEY_STRUCTURES, (class_2520)structuresCompound);
        return nbt;
    }

    public int save(class_1937 world, File folder) {
        if (this.dirty) {
            File structureFile = new File(folder, "structures.dat");
            try {
                class_2507.method_30614((class_2487)this.writeNbt(new class_2487()), (File)structureFile);
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error writing structure summary file for {}.", (Object)world.method_27983().method_29177(), (Object)e);
            }
            return this.structures.size();
        }
        return 0;
    }

    public static StructurePieceSummary readStructurePieceNbt(class_2487 nbt) {
        if (nbt.method_10558("id").equals(class_7923.field_41146.method_10221((Object)class_3773.field_25840).toString())) {
            return new JigsawPieceSummary(nbt);
        }
        return new StructurePieceSummary(nbt);
    }

    protected static WorldStructureSummary readNbt(class_5321<class_1937> worldKey, class_2487 nbt) {
        ConcurrentHashMap<class_5321<class_3195>, Map<class_1923, StructureStartSummary>> structures = new ConcurrentHashMap<class_5321<class_3195>, Map<class_1923, StructureStartSummary>>();
        ConcurrentHashMap structureTypes = new ConcurrentHashMap();
        HashMultimap structureTags = HashMultimap.create();
        class_2487 structuresCompound = nbt.method_10562(KEY_STRUCTURES);
        for (String structureId : structuresCompound.method_10541()) {
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)new class_2960(structureId));
            class_2487 structureCompound = structuresCompound.method_10562(structureId);
            class_5321 type = class_5321.method_29179((class_5321)class_7924.field_41231, (class_2960)new class_2960(structureCompound.method_10558(KEY_TYPE)));
            structureTypes.put((class_5321<class_3195>)key, type);
            List<class_6862> tags = structureCompound.method_10554(KEY_TAGS, 8).stream().map(e -> class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960(e.method_10714()))).toList();
            structureTags.putAll((Object)key, tags);
            class_2487 startsCompound = structureCompound.method_10562(KEY_STARTS);
            for (String posKey : startsCompound.method_10541()) {
                int x = Integer.parseInt(posKey.split(",")[0]);
                int z = Integer.parseInt(posKey.split(",")[1]);
                class_2487 startCompound = startsCompound.method_10562(posKey);
                ArrayList<StructurePieceSummary> pieces = new ArrayList<StructurePieceSummary>();
                for (class_2520 pieceElement : startCompound.method_10554(KEY_PIECES, 10)) {
                    pieces.add(WorldStructureSummary.readStructurePieceNbt((class_2487)pieceElement));
                }
                structures.computeIfAbsent((class_5321<class_3195>)key, p -> new ConcurrentHashMap()).put(new class_1923(x, z), new StructureStartSummary(pieces));
            }
        }
        return new WorldStructureSummary(worldKey, structures, structureTypes, (Multimap<class_5321<class_3195>, class_6862<class_3195>>)structureTags);
    }

    public static WorldStructureSummary load(class_1937 world, File folder) {
        class_2487 structureNbt = new class_2487();
        File structuresFile = new File(folder, "structures.dat");
        if (structuresFile.exists()) {
            try {
                structureNbt = class_2507.method_30613((File)structuresFile);
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading structure summary file for {}.", (Object)world.method_27983().method_29177(), (Object)e);
            }
        }
        return WorldStructureSummary.readNbt((class_5321<class_1937>)world.method_27983(), structureNbt);
    }

    public static void onChunkLoad(class_3218 world, class_2791 chunk) {
        WorldStructureSummary structures = WorldSummary.of((class_1937)world).structures();
        chunk.method_12016().forEach((structure, start) -> {
            if (!structures.contains((class_1937)world, (class_3449)start)) {
                structures.put(world, (class_3449)start);
            }
        });
    }

    public static void onStructurePlace(class_3218 world, class_3449 start) {
        WorldStructureSummary structures = WorldSummary.of((class_1937)world).structures();
        if (!structures.contains((class_1937)world, start)) {
            structures.put(world, start);
        }
    }
}

