/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.terrain.RegionSummary;
import folk.sisby.surveyor.util.BitSetUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import net.minecraft.class_1923;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5455;

public record S2CUpdateRegionPacket(class_1923 regionPos, RegionSummary summary, BitSet chunks) implements S2CPacket
{
    public static final class_2960 ID = new class_2960("surveyor", "s2c_update_region");

    public static S2CUpdateRegionPacket handle(class_2540 buf, class_5455 manager, WorldSummary summary) {
        class_1923 regionPos = buf.method_36133();
        RegionSummary region = summary.terrain().getRegion(regionPos);
        BitSet chunks = region.readBuf(manager, buf);
        return new S2CUpdateRegionPacket(regionPos, region, chunks);
    }

    @Override
    public void writeBuf(class_2540 buf) {
        buf.method_36130(this.regionPos);
        this.summary.writeBuf(buf, this.chunks);
    }

    @Override
    public Collection<class_2540> toBufs() {
        ArrayList<class_2540> bufs = new ArrayList<class_2540>();
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.writeBuf(buf);
        if (buf.readableBytes() < 0x100000) {
            bufs.add(buf);
        } else {
            if (this.chunks.cardinality() == 1) {
                throw new RuntimeException("Couldn't create a terrain update packet - an individual chunk would be too large to send!");
            }
            for (BitSet splitChunks : BitSetUtil.half(this.chunks)) {
                bufs.addAll(new S2CUpdateRegionPacket(this.regionPos, this.summary, splitChunks).toBufs());
            }
        }
        return bufs;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }
}

