/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.landmark;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.Landmarks;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.util.MapUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class WorldLandmarks {
    protected final class_5321<class_1937> worldKey;
    protected final Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> landmarks = new ConcurrentHashMap();
    protected boolean dirty = false;

    public WorldLandmarks(class_5321<class_1937> worldKey, Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> landmarks) {
        this.worldKey = worldKey;
        this.landmarks.putAll(landmarks);
    }

    public boolean contains(LandmarkType<?> type, class_2338 pos) {
        return this.landmarks.containsKey(type) && this.landmarks.get(type).containsKey(pos);
    }

    public <T extends Landmark<T>> Landmark<T> get(LandmarkType<T> type, class_2338 pos) {
        return this.landmarks.get(type).get(pos);
    }

    public <T extends Landmark<T>> Map<class_2338, T> asMap(LandmarkType<T> type, SurveyorExploration exploration) {
        HashMap outMap = new HashMap();
        if (this.landmarks.containsKey(type)) {
            this.landmarks.get(type).forEach((pos, landmark) -> {
                if (exploration == null || exploration.exploredLandmark(this.worldKey, (Landmark<?>)landmark)) {
                    outMap.put(pos, landmark);
                }
            });
        }
        return outMap;
    }

    public Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> asMap(SurveyorExploration exploration) {
        HashMap outmap = new HashMap();
        this.landmarks.forEach((type, map) -> map.forEach((pos, landmark) -> {
            if (exploration == null || exploration.exploredLandmark(this.worldKey, (Landmark<?>)landmark)) {
                outmap.computeIfAbsent((LandmarkType<?>)type, t -> new HashMap()).put(pos, landmark);
            }
        }));
        return outmap;
    }

    public Multimap<LandmarkType<?>, class_2338> keySet(SurveyorExploration exploration) {
        HashMultimap outMap = HashMultimap.create();
        this.landmarks.forEach((arg_0, arg_1) -> this.lambda$keySet$5(exploration, (Multimap)outMap, arg_0, arg_1));
        return outMap;
    }

    public void handleChanged(class_1937 world, Multimap<LandmarkType<?>, class_2338> changed, boolean local, @Nullable class_3222 sender) {
        HashMap landmarksAddedChanged = new HashMap();
        HashMultimap landmarksRemoved = HashMultimap.create();
        changed.forEach((arg_0, arg_1) -> this.lambda$handleChanged$7(landmarksAddedChanged, (Multimap)landmarksRemoved, arg_0, arg_1));
        if (!landmarksRemoved.isEmpty()) {
            SurveyorEvents.Invoke.landmarksRemoved(world, landmarksRemoved);
        }
        if (!landmarksAddedChanged.isEmpty()) {
            SurveyorEvents.Invoke.landmarksAdded(world, MapUtil.keyMultiMap(landmarksAddedChanged));
        }
        if (!local) {
            if (!landmarksRemoved.isEmpty()) {
                new SyncLandmarksRemovedPacket((Multimap<LandmarkType<?>, class_2338>)landmarksRemoved).send(sender, world);
            }
            if (!landmarksAddedChanged.isEmpty()) {
                new SyncLandmarksAddedPacket(landmarksAddedChanged).send(sender, world);
            }
        }
    }

    public Multimap<LandmarkType<?>, class_2338> putForBatch(Multimap<LandmarkType<?>, class_2338> changed, Landmark<?> landmark) {
        this.landmarks.computeIfAbsent(landmark.type(), t -> new ConcurrentHashMap()).put(landmark.pos(), landmark);
        this.dirty = true;
        changed.put(landmark.type(), (Object)landmark.pos());
        return changed;
    }

    public void putLocal(class_1937 world, Landmark<?> landmark) {
        Multimap<LandmarkType<?>, class_2338> changed = landmark.put((Multimap<LandmarkType<?>, class_2338>)HashMultimap.create(), world, this);
        this.handleChanged(world, changed, true, null);
    }

    public void put(class_1937 world, Landmark<?> landmark) {
        Multimap<LandmarkType<?>, class_2338> changed = landmark.put((Multimap<LandmarkType<?>, class_2338>)HashMultimap.create(), world, this);
        this.handleChanged(world, changed, false, null);
    }

    public void put(class_3222 sender, class_3218 world, Landmark<?> landmark) {
        Multimap<LandmarkType<?>, class_2338> changed = landmark.put((Multimap<LandmarkType<?>, class_2338>)HashMultimap.create(), (class_1937)world, this);
        this.handleChanged((class_1937)world, changed, false, sender);
    }

    public Multimap<LandmarkType<?>, class_2338> removeForBatch(Multimap<LandmarkType<?>, class_2338> changed, LandmarkType<?> type, class_2338 pos) {
        if (!this.landmarks.containsKey(type) || !this.landmarks.get(type).containsKey(pos)) {
            return changed;
        }
        this.landmarks.get(type).remove(pos);
        if (this.landmarks.get(type).isEmpty()) {
            this.landmarks.remove(type);
        }
        this.dirty = true;
        changed.put(type, (Object)pos);
        return changed;
    }

    public void removeLocal(class_1937 world, LandmarkType<?> type, class_2338 pos) {
        if (!this.landmarks.containsKey(type) || !this.landmarks.get(type).containsKey(pos)) {
            return;
        }
        Multimap<LandmarkType<?>, class_2338> changed = this.landmarks.get(type).get(pos).remove((Multimap<LandmarkType<?>, class_2338>)HashMultimap.create(), world, this);
        this.handleChanged(world, changed, true, null);
    }

    public void remove(class_1937 world, LandmarkType<?> type, class_2338 pos) {
        if (!this.landmarks.containsKey(type) || !this.landmarks.get(type).containsKey(pos)) {
            return;
        }
        Multimap<LandmarkType<?>, class_2338> changed = this.landmarks.get(type).get(pos).remove((Multimap<LandmarkType<?>, class_2338>)HashMultimap.create(), world, this);
        this.handleChanged(world, changed, false, null);
    }

    public void remove(class_3222 sender, class_3218 world, LandmarkType<?> type, class_2338 pos) {
        if (!this.landmarks.containsKey(type) || !this.landmarks.get(type).containsKey(pos)) {
            return;
        }
        Multimap<LandmarkType<?>, class_2338> changed = this.landmarks.get(type).get(pos).remove((Multimap<LandmarkType<?>, class_2338>)HashMultimap.create(), (class_1937)world, this);
        this.handleChanged((class_1937)world, changed, false, sender);
    }

    public void removeAll(class_1937 world, Class<?> clazz, class_2338 pos) {
        HashMultimap changed = HashMultimap.create();
        this.landmarks.forEach((arg_0, arg_1) -> this.lambda$removeAll$9(pos, clazz, (Multimap)changed, world, arg_0, arg_1));
        this.handleChanged(world, (Multimap<LandmarkType<?>, class_2338>)changed, false, null);
    }

    public int save(class_1937 world, File folder) {
        if (this.dirty) {
            File landmarksFile = new File(folder, "landmarks.dat");
            try {
                class_2507.method_30614((class_2487)Landmarks.writeNbt(this.landmarks, new class_2487()), (File)landmarksFile);
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error writing landmarks file for {}.", (Object)world.method_27983().method_29177(), (Object)e);
            }
            return this.landmarks.size();
        }
        return 0;
    }

    public static WorldLandmarks load(class_1937 world, File folder) {
        class_2487 landmarkNbt = new class_2487();
        File landmarksFile = new File(folder, "landmarks.dat");
        if (landmarksFile.exists()) {
            try {
                landmarkNbt = class_2507.method_30613((File)landmarksFile);
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading landmarks file for {}.", (Object)world.method_27983().method_29177(), (Object)e);
            }
        }
        return new WorldLandmarks((class_5321<class_1937>)world.method_27983(), Landmarks.fromNbt(landmarkNbt));
    }

    private /* synthetic */ void lambda$removeAll$9(class_2338 pos, Class clazz, Multimap changed, class_1937 world, LandmarkType type, Map map) {
        Landmark landmark;
        if (map.containsKey(pos) && clazz.isAssignableFrom((landmark = (Landmark)map.get(pos)).getClass())) {
            landmark.remove(changed, world, this);
        }
    }

    private /* synthetic */ void lambda$handleChanged$7(Map landmarksAddedChanged, Multimap landmarksRemoved, LandmarkType type, class_2338 pos) {
        if (this.contains(type, pos)) {
            landmarksAddedChanged.computeIfAbsent(type, t -> new HashMap()).put(pos, this.get(type, pos));
        } else {
            landmarksRemoved.put((Object)type, (Object)pos);
        }
    }

    private /* synthetic */ void lambda$keySet$5(SurveyorExploration exploration, Multimap outMap, LandmarkType type, Map map) {
        map.forEach((pos, landmark) -> {
            if (exploration == null || exploration.exploredLandmark(this.worldKey, (Landmark<?>)landmark)) {
                outMap.put((Object)type, pos);
            }
        });
    }
}

