/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorNetworking;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.structure.StructureStartSummary;
import folk.sisby.surveyor.terrain.RegionSummary;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_638;

public class SurveyorClientNetworking {
    public static void init() {
        SurveyorNetworking.C2S_SENDER = p -> {
            if (!ClientPlayNetworking.canSend((class_2960)p.getId())) {
                return;
            }
            p.toBufs().forEach(buf -> ClientPlayNetworking.send((class_2960)p.getId(), (class_2540)buf));
        };
        ClientPlayNetworking.registerGlobalReceiver((class_2960)S2CStructuresAddedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CStructuresAddedPacket::read, SurveyorClientNetworking::handleStructuresAdded));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)S2CUpdateRegionPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClientUnparsed(b, SurveyorClientNetworking::handleTerrainAdded));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SyncLandmarksAddedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, SyncLandmarksAddedPacket::read, SurveyorClientNetworking::handleLandmarksAdded));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SyncLandmarksRemovedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, SyncLandmarksRemovedPacket::read, SurveyorClientNetworking::handleLandmarksRemoved));
    }

    private static void handleStructuresAdded(class_638 world, WorldSummary summary, S2CStructuresAddedPacket packet) {
        packet.structures().forEach((key, map) -> map.forEach((pos, start) -> summary.structures().put((class_1937)world, (class_5321<class_3195>)key, (class_1923)pos, (StructureStartSummary)start, packet.structureTypes().get(key), packet.structureTags().get(key))));
        if (class_310.method_1551().field_1724 != null) {
            SurveyorExploration exploration = SurveyorClient.getExploration();
            packet.structures().forEach((key, starts) -> starts.forEach((pos, structure) -> exploration.addStructure((class_5321<class_1937>)world.method_27983(), (class_5321<class_3195>)key, (class_1923)pos)));
        }
    }

    private static void handleTerrainAdded(class_638 world, WorldSummary summary, class_2540 buf) {
        S2CUpdateRegionPacket packet = S2CUpdateRegionPacket.handle(buf, world.method_30349(), summary);
        SurveyorClient.getExploration().mergeRegion((class_5321<class_1937>)world.method_27983(), packet.regionPos(), packet.chunks());
        SurveyorEvents.Invoke.terrainUpdated((class_1937)world, packet.chunks().stream().mapToObj(i -> RegionSummary.chunkForBit(packet.regionPos(), i)).toList());
    }

    private static void handleLandmarksAdded(class_638 world, WorldSummary summary, SyncLandmarksAddedPacket packet) {
        HashMultimap changed = HashMultimap.create();
        packet.landmarks().forEach((arg_0, arg_1) -> SurveyorClientNetworking.lambda$handleLandmarksAdded$12(summary, (Multimap)changed, arg_0, arg_1));
        summary.landmarks().handleChanged((class_1937)world, (Multimap<LandmarkType<?>, class_2338>)changed, true, null);
    }

    private static void handleLandmarksRemoved(class_638 world, WorldSummary summary, SyncLandmarksRemovedPacket packet) {
        HashMultimap changed = HashMultimap.create();
        packet.landmarks().forEach((arg_0, arg_1) -> SurveyorClientNetworking.lambda$handleLandmarksRemoved$13(summary, (Multimap)changed, arg_0, arg_1));
        summary.landmarks().handleChanged((class_1937)world, (Multimap<LandmarkType<?>, class_2338>)changed, true, null);
    }

    private static <T extends S2CPacket> void handleClient(class_2540 buf, Function<class_2540, T> reader, ClientPacketHandler<T> handler) {
        S2CPacket packet = (S2CPacket)reader.apply(buf);
        WorldSummary summary = WorldSummary.of((class_1937)class_310.method_1551().field_1687);
        if (!summary.isClient()) {
            return;
        }
        class_310.method_1551().execute(() -> handler.handle(class_310.method_1551().field_1687, summary, packet));
    }

    private static void handleClientUnparsed(class_2540 buf, ClientPacketHandler<class_2540> handler) {
        class_638 world = class_310.method_1551().field_1687;
        WorldSummary summary = WorldSummary.of((class_1937)class_310.method_1551().field_1687);
        if (!summary.isClient()) {
            return;
        }
        handler.handle(world, summary, buf);
    }

    private static /* synthetic */ void lambda$handleLandmarksRemoved$13(WorldSummary summary, Multimap changed, LandmarkType type, class_2338 pos) {
        summary.landmarks().removeForBatch(changed, type, pos);
    }

    private static /* synthetic */ void lambda$handleLandmarksAdded$12(WorldSummary summary, Multimap changed, LandmarkType type, Map map) {
        map.forEach((pos, landmark) -> summary.landmarks().putForBatch((Multimap<LandmarkType<?>, class_2338>)changed, (Landmark<?>)landmark));
    }

    public static interface ClientPacketHandler<T> {
        public void handle(class_638 var1, WorldSummary var2, T var3);
    }
}

