/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClientEvents;
import folk.sisby.surveyor.client.SurveyorClientNetworking;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.C2SKnownStructuresPacket;
import folk.sisby.surveyor.packet.C2SKnownTerrainPacket;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1132;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_642;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class SurveyorClient
implements ClientModInitializer {
    public static final String SERVERS_FILE_NAME = "servers.txt";

    public static File getSavePath(class_1937 world) {
        String saveFolder = String.valueOf(world.method_22385().field_20641);
        Path savePath = FabricLoader.getInstance().getGameDir().resolve("data").resolve("surveyor").resolve(saveFolder);
        savePath.toFile().mkdirs();
        File serversFile = savePath.resolve(SERVERS_FILE_NAME).toFile();
        try {
            class_642 info = class_310.method_1551().method_1558();
            if (!(info == null || serversFile.exists() && FileUtils.readFileToString((File)serversFile, (Charset)StandardCharsets.UTF_8).contains(info.field_3752 + "\n" + info.field_3761))) {
                FileUtils.writeStringToFile((File)serversFile, (String)(info.field_3752 + "\n" + info.field_3761 + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
        }
        catch (IOException e) {
            Surveyor.LOGGER.error("[Surveyor] Error writing servers file for save {}.", (Object)savePath, (Object)e);
        }
        return savePath.toFile();
    }

    public static File getWorldSavePath(class_1937 world) {
        String dimNamespace = world.method_27983().method_29177().method_12836();
        String dimPath = world.method_27983().method_29177().method_12832();
        return SurveyorClient.getSavePath(world).toPath().resolve(dimNamespace).resolve(dimPath).toFile();
    }

    public static boolean serverSupported() {
        return ClientPlayNetworking.canSend((class_2960)C2SKnownTerrainPacket.ID);
    }

    @Nullable
    public static SurveyorExploration getExploration() {
        if (class_310.method_1551().method_1496()) {
            class_3222 serverPlayer = SurveyorClient.stealServerPlayer(SurveyorClient.getClientUuid());
            return serverPlayer == null ? null : SurveyorExploration.of(SurveyorClient.stealServerPlayer(SurveyorClient.getClientUuid()));
        }
        return ClientExploration.INSTANCE;
    }

    public static UUID getClientUuid() {
        return class_4844.method_43343((GameProfile)class_310.method_1551().method_1548().method_1677());
    }

    public static class_3218 stealServerWorld(class_5321<class_1937> worldKey) {
        class_1132 integratedServer = class_310.method_1551().method_1576();
        if (integratedServer == null) {
            return null;
        }
        return integratedServer.method_3847(worldKey);
    }

    public static class_3222 stealServerPlayer(UUID uuid) {
        class_1132 integratedServer = class_310.method_1551().method_1576();
        if (integratedServer == null) {
            return null;
        }
        return integratedServer.method_3760().method_14602(uuid);
    }

    public void onInitializeClient() {
        SurveyorClientNetworking.init();
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> client.execute(ClientExploration::onLoad));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> ClientExploration.onUnload());
        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (WorldSummary.of((class_1937)world).isClient()) {
                WorldTerrainSummary.onChunkLoad((class_1937)world, (class_2791)chunk);
                ClientExploration.INSTANCE.addChunk((class_5321<class_1937>)world.method_27983(), chunk.method_12004());
            }
        });
        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            if (WorldSummary.of((class_1937)world).isClient()) {
                WorldTerrainSummary.onChunkUnload((class_1937)world, chunk);
            }
        });
        ClientTickEvents.END_WORLD_TICK.register(world -> {
            if (!SurveyorClientEvents.INITIALIZING_WORLD) {
                return;
            }
            if (SurveyorClient.getExploration() != null && class_310.method_1551().field_1724 != null) {
                SurveyorClientEvents.INITIALIZING_WORLD = false;
                if (WorldSummary.of((class_1937)world).isClient()) {
                    WorldSummary summary = WorldSummary.of((class_1937)world);
                    new C2SKnownTerrainPacket(summary.terrain().bitSet(null)).send();
                    new C2SKnownStructuresPacket(summary.structures().keySet(null)).send();
                    new C2SKnownLandmarksPacket(summary.landmarks().keySet(null)).send();
                }
                SurveyorClientEvents.Invoke.worldLoad(class_310.method_1551().field_1724.field_17892, class_310.method_1551().field_1724);
            }
        });
        SurveyorEvents.Register.landmarksAdded(new class_2960("surveyor", "client"), (world, worldLandmarks, landmarks) -> {
            SurveyorExploration exploration = SurveyorClient.getExploration();
            if (exploration != null) {
                SurveyorClientEvents.Invoke.landmarksAdded(world, exploration.limitLandmarkKeySet((class_5321<class_1937>)world.method_27983(), worldLandmarks, (Multimap<LandmarkType<?>, class_2338>)HashMultimap.create((Multimap)landmarks)));
            }
        });
        SurveyorEvents.Register.landmarksRemoved(new class_2960("surveyor", "client"), (world, summary, landmarks) -> SurveyorClientEvents.Invoke.landmarksRemoved(world, landmarks));
    }

    private record ClientExploration(Map<class_5321<class_1937>, Map<class_1923, BitSet>> terrain, Map<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>> structures) implements SurveyorExploration
    {
        public static final String KEY_SHARED = "shared";
        public static final ClientExploration INSTANCE = new ClientExploration(new HashMap<class_5321<class_1937>, Map<class_1923, BitSet>>(), new HashMap<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>>());
        public static final ClientExploration SHARED = new ClientExploration(new HashMap<class_5321<class_1937>, Map<class_1923, BitSet>>(), new HashMap<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>>());
        public static File saveFile = null;

        public static void onLoad() {
            if (WorldSummary.of((class_1937)class_310.method_1551().field_1687).isClient()) {
                saveFile = SurveyorClient.getSavePath((class_1937)class_310.method_1551().field_1687).toPath().resolve(SurveyorClient.getClientUuid().toString() + ".dat").toFile();
                class_2487 explorationNbt = new class_2487();
                if (saveFile.exists()) {
                    try {
                        explorationNbt = class_2507.method_30613((File)saveFile);
                    }
                    catch (IOException e) {
                        Surveyor.LOGGER.error("[Surveyor] Error loading client exploration file.", (Throwable)e);
                    }
                }
                INSTANCE.read(explorationNbt);
                SHARED.read(explorationNbt.method_10562(KEY_SHARED));
            }
        }

        public static void onUnload() {
            if (saveFile != null) {
                try {
                    class_2487 nbt = INSTANCE.write(new class_2487());
                    class_2487 sharedNbt = SHARED.write(new class_2487());
                    nbt.method_10566(KEY_SHARED, (class_2520)sharedNbt);
                    class_2507.method_30614((class_2487)nbt, (File)saveFile);
                }
                catch (IOException e) {
                    Surveyor.LOGGER.error("[Surveyor] Error saving client exploration file.", (Throwable)e);
                }
                saveFile = null;
            }
            INSTANCE.terrain().clear();
            ClientExploration.INSTANCE.structures.clear();
            ClientExploration.SHARED.terrain.clear();
            ClientExploration.SHARED.structures.clear();
        }

        @Override
        public Set<UUID> sharedPlayers() {
            return Set.of(class_4844.method_43343((GameProfile)class_310.method_1551().method_1548().method_1677()));
        }

        @Override
        public void addStructure(class_5321<class_1937> worldKey, class_5321<class_3195> structureKey, class_1923 pos) {
            SurveyorExploration.super.addStructure(worldKey, structureKey, pos);
            this.updateClientForAddStructure((class_1937)class_310.method_1551().field_1687, structureKey, pos);
        }

        @Override
        public void mergeRegion(class_5321<class_1937> worldKey, class_1923 regionPos, BitSet bitSet) {
            SurveyorExploration.super.mergeRegion(worldKey, regionPos, bitSet);
            this.updateClientForMergeRegion((class_1937)class_310.method_1551().field_1687, regionPos, bitSet);
        }

        @Override
        public void addChunk(class_5321<class_1937> worldKey, class_1923 pos) {
            SurveyorExploration.super.addChunk(worldKey, pos);
            this.updateClientForAddChunk((class_1937)class_310.method_1551().field_1687, pos);
        }
    }
}

