/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorWorld;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import java.io.File;
import net.minecraft.class_1937;

public record WorldSummary(WorldTerrainSummary terrain, WorldStructureSummary structures, WorldLandmarks landmarks, boolean isClient) {
    public static WorldSummary of(class_1937 world) {
        return ((SurveyorWorld)world).surveyor$getWorldSummary();
    }

    public static WorldSummary load(class_1937 world, File folder, boolean isClient) {
        Surveyor.LOGGER.info("[Surveyor] Loading data for {}", (Object)world.method_27983().method_29177());
        folder.mkdirs();
        WorldTerrainSummary terrain = WorldTerrainSummary.load(world, folder);
        WorldStructureSummary structures = WorldStructureSummary.load(world, folder);
        WorldLandmarks landmarks = WorldLandmarks.load(world, folder);
        Surveyor.LOGGER.info("[Surveyor] Finished loading data for {}", (Object)world.method_27983().method_29177());
        return new WorldSummary(terrain, structures, landmarks, isClient);
    }

    public void save(class_1937 world, File folder, boolean suppressLogs) {
        Surveyor.LOGGER.info("[Surveyor] Saving data for {}", (Object)world.method_27983().method_29177());
        folder.mkdirs();
        this.terrain.save(world, folder);
        this.structures.save(world, folder);
        this.landmarks.save(world, folder);
        Surveyor.LOGGER.info("[Surveyor] Finished saving data for {}", (Object)world.method_27983().method_29177());
    }
}

