/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.C2SKnownStructuresPacket;
import folk.sisby.surveyor.packet.C2SKnownTerrainPacket;
import folk.sisby.surveyor.packet.C2SPacket;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.structure.StructureStartSummary;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class SurveyorNetworking {
    public static Consumer<C2SPacket> C2S_SENDER = p -> {};

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)C2SKnownTerrainPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, C2SKnownTerrainPacket::read, SurveyorNetworking::handleKnownTerrain));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)C2SKnownStructuresPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, C2SKnownStructuresPacket::read, SurveyorNetworking::handleKnownStructures));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)C2SKnownLandmarksPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, C2SKnownLandmarksPacket::read, SurveyorNetworking::handleKnownLandmarks));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SyncLandmarksAddedPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, SyncLandmarksAddedPacket::read, SurveyorNetworking::handleLandmarksAdded));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SyncLandmarksRemovedPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, SyncLandmarksRemovedPacket::read, SurveyorNetworking::handleLandmarksRemoved));
    }

    private static void handleKnownTerrain(class_3222 player, class_3218 world, WorldSummary summary, C2SKnownTerrainPacket packet) {
        Map<class_1923, BitSet> serverBits = summary.terrain().bitSet(SurveyorExploration.of(player));
        Map<class_1923, BitSet> clientBits = packet.regionBits();
        serverBits.forEach((rPos, set) -> {
            if (clientBits.containsKey(rPos)) {
                set.andNot((BitSet)clientBits.get(rPos));
            }
            if (!set.isEmpty()) {
                new S2CUpdateRegionPacket((class_1923)rPos, summary.terrain().getRegion((class_1923)rPos), (BitSet)set).send(player);
            }
        });
    }

    private static void handleKnownStructures(class_3222 player, class_3218 world, WorldSummary summary, C2SKnownStructuresPacket packet) {
        Map<class_5321<class_3195>, Map<class_1923, StructureStartSummary>> structures = summary.structures().asMap(SurveyorExploration.of(player));
        packet.structureKeys().forEach((key, pos) -> {
            if (structures.containsKey(key)) {
                ((Map)structures.get(key)).remove(pos);
                if (((Map)structures.get(key)).isEmpty()) {
                    structures.remove(key);
                }
            }
        });
        if (structures.isEmpty()) {
            return;
        }
        HashMap structureTypes = new HashMap();
        HashMultimap structureTags = HashMultimap.create();
        for (class_5321<class_3195> key2 : structures.keySet()) {
            structureTypes.put(key2, summary.structures().getType(key2));
            structureTags.putAll(key2, summary.structures().getTags(key2));
        }
        new S2CStructuresAddedPacket(structures, structureTypes, (Multimap<class_5321<class_3195>, class_6862<class_3195>>)structureTags).send(player);
    }

    private static void handleKnownLandmarks(class_3222 player, class_3218 world, WorldSummary summary, C2SKnownLandmarksPacket packet) {
        Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> landmarks = summary.landmarks().asMap(SurveyorExploration.of(player));
        packet.landmarks().forEach((type, pos) -> {
            if (landmarks.containsKey(type)) {
                ((Map)landmarks.get(type)).remove(pos);
                if (((Map)landmarks.get(type)).isEmpty()) {
                    landmarks.remove(type);
                }
            }
        });
        if (!landmarks.isEmpty()) {
            new SyncLandmarksAddedPacket(landmarks).send(player);
        }
    }

    private static void handleLandmarksAdded(class_3222 player, class_3218 world, WorldSummary summary, SyncLandmarksAddedPacket packet) {
        HashMultimap changed = HashMultimap.create();
        packet.landmarks().forEach((arg_0, arg_1) -> SurveyorNetworking.lambda$handleLandmarksAdded$10(player, summary, (Multimap)changed, arg_0, arg_1));
        summary.landmarks().handleChanged((class_1937)world, (Multimap<LandmarkType<?>, class_2338>)changed, false, player);
    }

    private static void handleLandmarksRemoved(class_3222 player, class_3218 world, WorldSummary summary, SyncLandmarksRemovedPacket packet) {
        HashMultimap changed = HashMultimap.create();
        packet.landmarks().forEach((arg_0, arg_1) -> SurveyorNetworking.lambda$handleLandmarksRemoved$11(summary, player, (Multimap)changed, arg_0, arg_1));
        summary.landmarks().handleChanged((class_1937)world, (Multimap<LandmarkType<?>, class_2338>)changed, false, player);
    }

    private static <T extends C2SPacket> void handleServer(class_3222 player, class_2540 buf, Function<class_2540, T> reader, ServerPacketHandler<T> handler) {
        C2SPacket packet = (C2SPacket)reader.apply(buf);
        handler.handle(player, player.method_51469(), WorldSummary.of((class_1937)player.method_51469()), packet);
    }

    private static /* synthetic */ void lambda$handleLandmarksRemoved$11(WorldSummary summary, class_3222 player, Multimap changed, LandmarkType type, class_2338 pos) {
        if (summary.landmarks().contains(type, pos) && player.method_5667().equals(summary.landmarks().get(type, pos).owner())) {
            summary.landmarks().removeForBatch(changed, type, pos);
        }
    }

    private static /* synthetic */ void lambda$handleLandmarksAdded$10(class_3222 player, WorldSummary summary, Multimap changed, LandmarkType type, Map map) {
        map.forEach((pos, landmark) -> {
            if (player.method_5667().equals(landmark.owner())) {
                summary.landmarks().putForBatch((Multimap<LandmarkType<?>, class_2338>)changed, (Landmark<?>)landmark);
            }
        });
    }

    public static interface ServerPacketHandler<T extends C2SPacket> {
        public void handle(class_3222 var1, class_3218 var2, WorldSummary var3, T var4);
    }
}

