/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorPlayer;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClientEvents;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.terrain.RegionSummary;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public interface SurveyorExploration {
    public static final String KEY_EXPLORED_TERRAIN = "exploredTerrain";
    public static final String KEY_EXPLORED_STRUCTURES = "exploredStructures";

    public static SurveyorExploration of(class_3222 player) {
        return ((SurveyorPlayer)player).surveyor$getExploration();
    }

    public Map<class_5321<class_1937>, Map<class_1923, BitSet>> terrain();

    public Map<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>> structures();

    public Set<UUID> sharedPlayers();

    default public boolean exploredChunk(class_5321<class_1937> worldKey, class_1923 pos) {
        class_1923 regionPos = new class_1923(pos.method_17885(), pos.method_17886());
        Map<class_1923, BitSet> regions = this.terrain().get(worldKey);
        return Surveyor.CONFIG.shareAllTerrain != false || regions != null && regions.containsKey(regionPos) && regions.get(regionPos).get(RegionSummary.bitForChunk(pos));
    }

    default public boolean exploredStructure(class_5321<class_1937> worldKey, class_5321<class_3195> structure, class_1923 pos) {
        Map<class_5321<class_3195>, LongSet> structures = this.structures().get(worldKey);
        return Surveyor.CONFIG.shareAllStructures != false || structures != null && structures.containsKey(structure) && structures.get(structure).contains(pos.method_8324());
    }

    default public boolean exploredLandmark(class_5321<class_1937> worldKey, Landmark<?> landmark) {
        return Surveyor.CONFIG.shareAllLandmarks != false || (landmark.owner() == null ? this.exploredChunk(worldKey, new class_1923(landmark.pos())) : this.sharedPlayers().contains(landmark.owner()));
    }

    default public Map<class_1923, BitSet> limitTerrainBitset(class_5321<class_1937> worldKey, Map<class_1923, BitSet> bitSet) {
        if (Surveyor.CONFIG.shareAllTerrain.booleanValue()) {
            return bitSet;
        }
        Map<class_1923, BitSet> regions = this.terrain().get(worldKey);
        if (regions == null) {
            bitSet.clear();
        } else {
            bitSet.forEach((rPos, set) -> {
                if (regions.containsKey(rPos)) {
                    set.and((BitSet)regions.get(rPos));
                } else {
                    set.clear();
                }
            });
        }
        return bitSet;
    }

    default public Multimap<class_5321<class_3195>, class_1923> limitStructureKeySet(class_5321<class_1937> worldKey, Multimap<class_5321<class_3195>, class_1923> keySet) {
        if (Surveyor.CONFIG.shareAllStructures.booleanValue()) {
            return keySet;
        }
        Map<class_5321<class_3195>, LongSet> structures = this.structures().get(worldKey);
        if (structures == null) {
            keySet.clear();
        } else {
            keySet.keySet().removeIf(key -> !structures.containsKey(key));
            keySet.entries().removeIf(e -> !((LongSet)structures.get(e.getKey())).contains(((class_1923)e.getValue()).method_8324()));
        }
        return keySet;
    }

    default public Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> limitLandmarkMap(class_5321<class_1937> worldKey, Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> asMap) {
        if (Surveyor.CONFIG.shareAllLandmarks.booleanValue()) {
            return asMap;
        }
        HashMultimap toRemove = HashMultimap.create();
        asMap.forEach((arg_0, arg_1) -> this.lambda$limitLandmarkMap$4(worldKey, (Multimap)toRemove, arg_0, arg_1));
        toRemove.forEach((type, pos) -> {
            ((Map)asMap.get(type)).remove(pos);
            if (((Map)asMap.get(type)).isEmpty()) {
                asMap.remove(type);
            }
        });
        return asMap;
    }

    default public Multimap<LandmarkType<?>, class_2338> limitLandmarkKeySet(class_5321<class_1937> worldKey, WorldLandmarks worldLandmarks, Multimap<LandmarkType<?>, class_2338> keySet) {
        if (Surveyor.CONFIG.shareAllLandmarks.booleanValue()) {
            return keySet;
        }
        HashMultimap toRemove = HashMultimap.create();
        keySet.forEach((arg_0, arg_1) -> this.lambda$limitLandmarkKeySet$6(worldKey, worldLandmarks, (Multimap)toRemove, arg_0, arg_1));
        toRemove.forEach((arg_0, arg_1) -> keySet.remove(arg_0, arg_1));
        return keySet;
    }

    default public void updateClientForMergeRegion(class_1937 world, class_1923 regionPos, BitSet bitSet) {
        Set<class_1923> terrainKeys = bitSet.stream().mapToObj(i -> RegionSummary.chunkForBit(regionPos, i)).collect(Collectors.toSet());
        SurveyorClientEvents.Invoke.terrainUpdated(world, terrainKeys);
        HashMultimap landmarkKeys = HashMultimap.create();
        WorldSummary.of(world).landmarks().keySet(this).forEach((arg_0, arg_1) -> SurveyorExploration.lambda$updateClientForMergeRegion$8(terrainKeys, world, (Multimap)landmarkKeys, arg_0, arg_1));
        SurveyorClientEvents.Invoke.landmarksAdded(world, landmarkKeys);
    }

    default public void mergeRegion(class_5321<class_1937> worldKey, class_1923 regionPos, BitSet bitSet) {
        this.terrain().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(regionPos, p -> new BitSet(32)).or(bitSet);
    }

    default public void updateClientForAddChunk(class_1937 world, class_1923 chunkPos) {
        SurveyorClientEvents.Invoke.terrainUpdated(world, chunkPos);
        HashMultimap landmarkKeys = HashMultimap.create();
        WorldSummary.of(world).landmarks().keySet(this).forEach((arg_0, arg_1) -> SurveyorExploration.lambda$updateClientForAddChunk$11(chunkPos, world, (Multimap)landmarkKeys, arg_0, arg_1));
        SurveyorClientEvents.Invoke.landmarksAdded(world, landmarkKeys);
    }

    default public void addChunk(class_5321<class_1937> worldKey, class_1923 pos) {
        this.terrain().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(new class_1923(pos.method_17885(), pos.method_17886()), k -> new BitSet(1024)).set(RegionSummary.bitForChunk(pos));
    }

    default public void updateClientForAddStructure(class_1937 world, class_5321<class_3195> structureKey, class_1923 pos) {
        SurveyorClientEvents.Invoke.structuresAdded(world, structureKey, pos);
    }

    default public void addStructure(class_5321<class_1937> worldKey, class_5321<class_3195> structureKey, class_1923 pos) {
        this.structures().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(structureKey, s -> new LongOpenHashSet()).add(pos.method_8324());
    }

    default public class_2487 write(class_2487 nbt) {
        class_2487 terrainCompound = new class_2487();
        this.terrain().forEach((worldKey, map) -> {
            LongArrayList regionLongs = new LongArrayList();
            for (Map.Entry entry : map.entrySet()) {
                regionLongs.add(((class_1923)entry.getKey()).method_8324());
                if (((BitSet)entry.getValue()).cardinality() == 1024) {
                    regionLongs.add(-1L);
                    continue;
                }
                long[] regionBits = ((BitSet)entry.getValue()).toLongArray();
                regionLongs.add((long)regionBits.length);
                regionLongs.addAll(LongList.of((long[])regionBits));
            }
            terrainCompound.method_10564(worldKey.method_29177().toString(), regionLongs.toLongArray());
        });
        nbt.method_10566(KEY_EXPLORED_TERRAIN, (class_2520)terrainCompound);
        class_2487 structuresCompound = new class_2487();
        this.structures().forEach((worldKey, map) -> {
            class_2487 worldStructuresCompound = new class_2487();
            for (class_5321 structure : map.keySet()) {
                worldStructuresCompound.method_10564(structure.method_29177().toString(), ((LongSet)map.get(structure)).toLongArray());
            }
            structuresCompound.method_10566(worldKey.method_29177().toString(), (class_2520)worldStructuresCompound);
        });
        nbt.method_10566(KEY_EXPLORED_STRUCTURES, (class_2520)structuresCompound);
        return nbt;
    }

    default public void read(class_2487 nbt) {
        class_2487 terrainCompound = nbt.method_10562(KEY_EXPLORED_TERRAIN);
        for (String worldKeyString : terrainCompound.method_10541()) {
            long[] regionArray = terrainCompound.method_10565(worldKeyString);
            HashMap<class_1923, BitSet> regionMap = new HashMap<class_1923, BitSet>();
            int i = 0;
            while (i + 1 < regionArray.length) {
                class_1923 rPos = new class_1923(regionArray[i]);
                int bitLength = (int)regionArray[i + 1];
                if (bitLength == -1) {
                    BitSet set = new BitSet(1024);
                    set.set(0, 1024);
                    regionMap.put(rPos, set);
                } else {
                    long[] bitArray = new long[bitLength];
                    System.arraycopy(regionArray, i + 2, bitArray, 0, bitLength);
                    regionMap.put(rPos, BitSet.valueOf(bitArray));
                    i += bitLength;
                }
                i += 2;
            }
            this.terrain().put((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(worldKeyString)), regionMap);
        }
        class_2487 structuresCompound = nbt.method_10562(KEY_EXPLORED_STRUCTURES);
        for (String worldKeyString : structuresCompound.method_10541()) {
            HashMap<class_5321, LongOpenHashSet> structureMap = new HashMap<class_5321, LongOpenHashSet>();
            class_2487 worldStructuresCompound = structuresCompound.method_10562(worldKeyString);
            for (String key : worldStructuresCompound.method_10541()) {
                structureMap.put(class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)new class_2960(key)), new LongOpenHashSet(worldStructuresCompound.method_10565(key)));
            }
            this.structures().put((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(worldKeyString)), structureMap);
        }
    }

    default public void copyFrom(SurveyorExploration them) {
        this.terrain().clear();
        this.terrain().putAll(them.terrain());
        this.structures().clear();
        this.structures().putAll(them.structures());
    }

    private static /* synthetic */ void lambda$updateClientForAddChunk$11(class_1923 chunkPos, class_1937 world, Multimap landmarkKeys, LandmarkType type, class_2338 pos) {
        if (chunkPos.equals((Object)new class_1923(pos)) && WorldSummary.of(world).landmarks().get(type, pos).owner() == null) {
            landmarkKeys.put((Object)type, (Object)pos);
        }
    }

    private static /* synthetic */ void lambda$updateClientForMergeRegion$8(Set terrainKeys, class_1937 world, Multimap landmarkKeys, LandmarkType type, class_2338 pos) {
        if (terrainKeys.contains(new class_1923(pos)) && WorldSummary.of(world).landmarks().get(type, pos).owner() == null) {
            landmarkKeys.put((Object)type, (Object)pos);
        }
    }

    private /* synthetic */ void lambda$limitLandmarkKeySet$6(class_5321 worldKey, WorldLandmarks worldLandmarks, Multimap toRemove, LandmarkType type, class_2338 pos) {
        if (!this.exploredLandmark((class_5321<class_1937>)worldKey, worldLandmarks.get(type, pos))) {
            toRemove.put((Object)type, (Object)pos);
        }
    }

    private /* synthetic */ void lambda$limitLandmarkMap$4(class_5321 worldKey, Multimap toRemove, LandmarkType type, Map map) {
        map.forEach((pos, landmark) -> {
            if (!this.exploredLandmark((class_5321<class_1937>)worldKey, (Landmark<?>)landmark)) {
                toRemove.put((Object)type, pos);
            }
        });
    }
}

