/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.Multimap;
import folk.sisby.surveyor.SurveyorConfig;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorNetworking;
import folk.sisby.surveyor.SurveyorPlayer;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.MapUtil;
import folk.sisby.surveyor.util.RaycastUtil;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2806;
import net.minecraft.class_2874;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Surveyor
implements ModInitializer {
    public static final String ID = "surveyor";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"surveyor");
    public static final String DATA_SUBFOLDER = "data";
    public static final SurveyorConfig CONFIG = (SurveyorConfig)SurveyorConfig.createToml((Path)FabricLoader.getInstance().getConfigDir(), (String)"", (String)"surveyor", SurveyorConfig.class);

    public static File getSavePath(class_3218 world) {
        return class_2874.method_12488((class_5321)world.method_27983(), (Path)world.method_8503().method_27050(class_5218.field_24188)).resolve(DATA_SUBFOLDER).resolve(ID).toFile();
    }

    public static void checkStructureExploration(class_3218 world, class_3222 player, class_2338 pos) {
        if (!world.method_8393(pos.method_10263() >> 4, pos.method_10260() >> 4)) {
            return;
        }
        WorldStructureSummary worldStructures = WorldSummary.of((class_1937)world).structures();
        class_2378 structureRegistry = world.method_30349().method_30530(class_7924.field_41246);
        SurveyorExploration exploration = SurveyorExploration.of(player);
        Map structureReferences = world.method_22342(pos.method_10263() >> 4, pos.method_10260() >> 4, class_2806.field_16422).method_12179();
        if (!structureReferences.isEmpty()) {
            Multimap unexploredStructures = MapUtil.asMultiMap(structureReferences.entrySet().stream().collect(Collectors.toMap(e -> (class_5321)structureRegistry.method_29113((Object)((class_3195)e.getKey())).orElseThrow(), e -> ((LongSet)e.getValue()).longStream().mapToObj(class_1923::new).toList())));
            unexploredStructures.entries().removeIf(e -> exploration.exploredStructure((class_5321<class_1937>)world.method_27983(), (class_5321<class_3195>)((class_5321)e.getKey()), (class_1923)e.getValue()));
            unexploredStructures.entries().removeIf(e -> !worldStructures.contains((class_5321<class_3195>)((class_5321)e.getKey()), (class_1923)e.getValue()));
            unexploredStructures.forEach((structureKey, startPos) -> {
                class_3195 structure = (class_3195)structureRegistry.method_29107(structureKey);
                class_3449 start = world.method_22342(startPos.field_9181, startPos.field_9180, class_2806.field_16423).method_12181(structure);
                boolean found = false;
                if (start.method_14969().method_14662((class_2382)pos)) {
                    for (class_3443 piece : start.method_14963()) {
                        if (!piece.method_14935().method_35410(1).method_14662((class_2382)pos)) continue;
                        exploration.addStructure((class_5321<class_1937>)world.method_27983(), (class_5321<class_3195>)structureKey, start.method_34000());
                        found = true;
                        break;
                    }
                }
                if (found && Surveyor.CONFIG.debugMode.booleanValue()) {
                    player.method_43502((class_2561)class_2561.method_43470((String)"Discovered ").method_10852((class_2561)class_2561.method_43470((String)StringUtils.capitalize((String)structureKey.method_29177().method_12832().replace("_", " "))).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" at ")).method_10852((class_2561)class_2561.method_43470((String)"[%s,%s]".formatted(startPos.field_9181 << 4, startPos.field_9180 << 4)).method_27692(class_124.field_1065)).method_27692(class_124.field_1080), true);
                }
            });
        }
    }

    public void onInitialize() {
        SurveyorNetworking.init();
        ServerChunkEvents.CHUNK_LOAD.register(WorldTerrainSummary::onChunkLoad);
        ServerChunkEvents.CHUNK_LOAD.register(WorldStructureSummary::onChunkLoad);
        ServerChunkEvents.CHUNK_UNLOAD.register(WorldTerrainSummary::onChunkUnload);
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if ((world.method_8510() & 7L) != 0L) {
                return;
            }
            for (class_3222 player : world.method_18456()) {
                Surveyor.checkStructureExploration(world, player, player.method_24515());
                Surveyor.checkStructureExploration(world, player, class_2338.method_49638((class_2374)RaycastUtil.playerViewRaycast(player, ((SurveyorPlayer)player).surveyor$getViewDistance()).method_17784()));
            }
        });
    }
}

