/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.util;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jetbrains.annotations.Nullable;

public class ProfileTextureUtil {
    private static Field metadata = FieldUtils.getDeclaredField(MinecraftProfileTexture.class, (String)"metadata", (boolean)true);

    @Nullable
    public static Map<String, String> getMetadata(MinecraftProfileTexture texture) {
        try {
            return (Map)FieldUtils.readField((Field)metadata, (Object)texture);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to read metadata field", e);
        }
    }

    public static Optional<Map<String, String>> getMetadataFrom(MinecraftProfileTexture texture) {
        return Optional.ofNullable(ProfileTextureUtil.getMetadata(texture));
    }

    public static void setMetadata(MinecraftProfileTexture texture, Map<String, String> meta) {
        try {
            FieldUtils.writeField((Field)metadata, (Object)texture, meta);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to write metadata field", e);
        }
    }
}

