/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.scrollable;

import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.scrollable.ScrollOrientation;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class ScrollbarScrubber {
    private int currentPosition;
    private int targetPosition;
    private int momentum;
    private int maximumPosition;
    private float scrollSpeed;
    private int scrubberLength;
    private int gapLength;
    private final ScrollOrientation orientation;

    public ScrollbarScrubber(ScrollOrientation orientation) {
        this.orientation = orientation;
    }

    public int getPosition() {
        return this.currentPosition;
    }

    public int getMaximum() {
        return this.maximumPosition;
    }

    public int getStart() {
        return this.maximumPosition <= 0 ? 0 : (int)Math.max(0.0f, (float)this.getPosition() / (float)this.maximumPosition * (float)this.gapLength);
    }

    public int getLength() {
        return this.scrubberLength;
    }

    public void scrollBy(double amount, boolean animate) {
        this.scrollTo(this.currentPosition + (int)(amount * (double)this.scrollSpeed), animate);
    }

    public void scrollToEnd(boolean animate) {
        this.scrollTo(this.maximumPosition, animate);
    }

    public void scrollToBeginning(boolean animate) {
        this.scrollTo(0, animate);
    }

    public void scrollTo(int position, boolean animate) {
        this.targetPosition = class_3532.method_15340((int)position, (int)0, (int)this.maximumPosition);
        if (!animate) {
            this.currentPosition = this.targetPosition;
        }
        this.setMomentum(0);
    }

    public void setMomentum(int momentum) {
        this.momentum = momentum;
    }

    public void reposition(Bounds containerBounds, Bounds contentBounds) {
        float containerLength = this.orientation.getLength(containerBounds);
        float contentLength = this.orientation.getLength(contentBounds);
        this.maximumPosition = (int)Math.max(0.0f, contentLength - containerLength);
        this.scrollSpeed = containerLength == 0.0f ? 1.0f : contentLength / containerLength;
        this.scrollSpeed *= (float)class_310.method_1551().method_22683().method_4495() / 3.0f;
        this.scrubberLength = (int)class_3532.method_15363((float)(containerLength - (float)Math.sqrt(this.maximumPosition)), (float)15.0f, (float)(containerLength / 2.0f));
        this.gapLength = (int)containerLength - this.scrubberLength;
        this.scrollTo(this.targetPosition, false);
    }

    public void update(Bounds containerBounds, Bounds contentBounds, double mouseX, double mouseY, float partialTicks, boolean grabbed) {
        if (this.currentPosition < this.targetPosition) {
            this.currentPosition += Math.max(1, (this.targetPosition - this.currentPosition) / 2);
        }
        if (this.currentPosition > this.targetPosition) {
            this.currentPosition -= Math.max(1, (this.currentPosition - this.targetPosition) / 2);
        }
        if (!grabbed && (this.momentum = (int)((double)this.momentum * 0.6)) > 0) {
            this.scrollBy(this.momentum, false);
        }
    }

    public float getGrabPosition(double coord) {
        int scrubberStart = this.getStart();
        if (coord < (double)scrubberStart) {
            return -1.0f;
        }
        if (coord > (double)(scrubberStart + this.scrubberLength)) {
            return 2.0f;
        }
        return class_3532.method_15363((float)((float)(coord - (double)scrubberStart) / (float)this.scrubberLength), (float)0.0f, (float)1.0f);
    }
}

