/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.IViewRoot;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.dimension.IBounded;
import com.minelittlepony.common.client.gui.scrollable.ScrollOrientation;
import com.minelittlepony.common.client.gui.scrollable.ScrollbarScrubber;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6880;

public class Scrollbar
implements class_364,
class_4068,
IBounded {
    public static final int SCROLLBAR_THICKNESS = 6;
    private boolean dragging;
    private boolean touching;
    private boolean focused;
    private final ScrollbarScrubber scrubber;
    private final ScrollOrientation orientation;
    private final IViewRoot rootView;
    private final Bounds bounds;
    private Bounds containerBounds;
    private Bounds contentBounds;
    private double prevMousePosition;
    public boolean layoutToEnd;

    @Deprecated
    public Scrollbar(IViewRoot rootView) {
        this(rootView, ScrollOrientation.VERTICAL);
    }

    public Scrollbar(IViewRoot rootView, ScrollOrientation orientation) {
        this.rootView = rootView;
        this.orientation = orientation;
        this.contentBounds = this.bounds = new Bounds(0, 0, orientation.pick(0, 6), orientation.pick(6, 0));
        this.containerBounds = rootView.getBounds();
        this.scrubber = new ScrollbarScrubber(orientation);
    }

    public void reposition() {
        this.contentBounds = this.rootView.getContentBounds().offset(this.rootView.getContentPadding());
        this.containerBounds = this.rootView.getBounds();
        int end = this.layoutToEnd ? this.orientation.getWidth(this.rootView.getBounds()) - 6 : this.orientation.pick(this.contentBounds.bottom(), this.contentBounds.right());
        this.bounds.left = this.orientation.pick(0, end);
        this.bounds.top = this.orientation.pick(end, 0);
        this.bounds.height = this.orientation.pick(6, this.rootView.getBounds().height);
        this.bounds.width = this.orientation.pick(this.rootView.getBounds().width, 6);
        this.scrubber.reposition(this.containerBounds, this.contentBounds);
    }

    @Deprecated
    public int getVerticalScrollAmount() {
        return this.orientation == ScrollOrientation.VERTICAL ? this.scrubber.getPosition() : 0;
    }

    public ScrollbarScrubber getScrubber() {
        return this.scrubber;
    }

    @Deprecated
    public int getHorizontalScrollAmount() {
        return this.orientation == ScrollOrientation.HORIZONTAL ? this.scrubber.getPosition() : 0;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        if (this.scrubber.getMaximum() <= 0) {
            return;
        }
        this.scrubber.update(this.rootView.getBounds(), this.contentBounds, mouseX, mouseY, partialTicks, this.touching || this.dragging);
        this.renderScrubber(this.scrubber, this.orientation, context);
    }

    private void renderScrubber(ScrollbarScrubber scrubber, ScrollOrientation orientation, class_332 context) {
        int scrubberStart = scrubber.getStart();
        int scrubberEnd = scrubberStart + scrubber.getLength();
        this.renderBackground(context, this.bounds.top, this.bounds.left, this.bounds.bottom(), this.bounds.right());
        this.renderBar(context, orientation.pick(scrubberStart, this.bounds.left), orientation.pick(scrubberEnd, this.bounds.right()), orientation.pick(this.bounds.top, scrubberStart), orientation.pick(this.bounds.bottom(), scrubberEnd));
    }

    private void renderBackground(class_332 context, int top, int left, int bottom, int right) {
        context.method_25294(left, top, right, bottom, -1778384896);
    }

    private void renderBar(class_332 context, int left, int right, int top, int bottom) {
        context.method_25294(left, top, right, bottom, this.dragging ? -8355702 : -8355712);
        context.method_25294(left, top, right - 1, bottom - 1, this.dragging ? -4144900 : -4144960);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        mouseY = this.calculateInternalYPosition(mouseY);
        mouseX = this.calculateInternalXPosition(mouseX);
        double mousePosition = this.orientation.pick(mouseX, mouseY);
        this.dragging = false;
        this.touching = false;
        if (!this.method_25405(mouseX, mouseY)) {
            this.touching = true;
            return this.method_25405(mouseX, mouseY);
        }
        float grabPosition = this.scrubber.getGrabPosition(mousePosition);
        if (grabPosition < 0.0f || grabPosition > 1.0f) {
            this.scrubber.scrollBy((int)Math.signum(grabPosition) * 50, true);
        } else {
            GameGui.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
            this.dragging = true;
        }
        this.prevMousePosition = mousePosition;
        return this.method_25405(mouseX, mouseY);
    }

    private double calculateInternalYPosition(double mouseY) {
        return mouseY + (double)this.rootView.getScrollY() + (double)this.rootView.getContentPadding().top;
    }

    private double calculateInternalXPosition(double mouseX) {
        return mouseX + (double)this.rootView.getScrollX() + (double)this.rootView.getContentPadding().left;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double differX, double differY) {
        mouseY = this.calculateInternalYPosition(mouseY);
        mouseX = this.calculateInternalXPosition(mouseX);
        double mousePosition = this.orientation.pick(mouseX, mouseY);
        if (this.dragging) {
            this.scrubber.scrollBy(-((int)(this.prevMousePosition - mousePosition)), false);
        } else if (this.touching) {
            this.scrubber.scrollBy((int)(mousePosition - this.prevMousePosition) / 16, true);
            this.scrubber.setMomentum((int)(mousePosition - this.prevMousePosition));
        }
        this.prevMousePosition = mousePosition;
        return this.method_25405(mouseX, mouseY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.touching = false;
        this.dragging = false;
        return this.method_25405(this.calculateInternalXPosition(mouseX), this.calculateInternalYPosition(mouseY));
    }

    public void scrollBy(double amount) {
        this.scrubber.scrollBy(-amount, true);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.scrubber.getMaximum() > 0 && this.getBounds().contains(mouseX, mouseY);
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Bounds bounds) {
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.method_25370()) {
            if (keyCode == this.orientation.pick(263, 265)) {
                this.scrubber.scrollBy(-10.0, true);
                return true;
            }
            if (keyCode == this.orientation.pick(262, 264)) {
                this.scrubber.scrollBy(10.0, true);
                return true;
            }
            if (keyCode == 269) {
                this.scrubber.scrollToEnd(true);
                return true;
            }
            if (keyCode == 268) {
                this.scrubber.scrollToBeginning(true);
                return true;
            }
        }
        return false;
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    public boolean method_25370() {
        return this.focused || this.dragging;
    }
}

