/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.ITextContext;
import com.minelittlepony.common.client.gui.ITickableElement;
import com.minelittlepony.common.client.gui.Tooltip;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.dimension.IBounded;
import com.minelittlepony.common.client.gui.style.IStyled;
import com.minelittlepony.common.client.gui.style.Style;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4264;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import net.minecraft.class_8000;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class Button
extends class_4264
implements IBounded,
ITextContext,
IStyled<Button>,
ITickableElement {
    private Style style = new Style();
    private final Bounds bounds;
    private static final Consumer<Button> NONE = v -> {};
    @NotNull
    private Consumer<Button> action = NONE;
    @NotNull
    private Consumer<Button> update = NONE;
    @Nullable
    private Tooltip prevTooltip;

    public Button(int x, int y) {
        this(x, y, 200, 20);
    }

    public Button(int x, int y, int width, int height) {
        super(x, y, width, height, class_5244.field_39003);
        this.bounds = new Bounds(y, x, width, height);
    }

    public Button onClick(@NotNull Consumer<? extends Button> callback) {
        this.action = Objects.requireNonNull(callback);
        return this;
    }

    public Button onUpdate(@NotNull Consumer<? extends Button> callback) {
        this.update = Objects.requireNonNull(callback);
        return this;
    }

    public Button setEnabled(boolean enable) {
        this.field_22763 = enable;
        return this;
    }

    public Button setVisible(boolean visible) {
        this.field_22764 = visible;
        return this;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public Button setStyle(Style style) {
        this.style = style;
        return this;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Bounds bounds) {
        this.bounds.copy(bounds);
        this.method_46421(bounds.left);
        this.method_46419(bounds.top);
        this.method_25358(bounds.width);
        this.setHeight(bounds.height);
    }

    public void method_46421(int x) {
        this.bounds.left = x;
        super.method_46421(x);
    }

    public void method_46419(int y) {
        this.bounds.top = y;
        super.method_46419(y);
    }

    public void method_25358(int width) {
        this.bounds.width = width;
        super.method_25358(width);
    }

    public void setHeight(int height) {
        this.bounds.height = height;
        this.field_22759 = height;
    }

    public void method_47399(class_6382 narrationMsg) {
        this.getStyle().getTooltip().ifPresent(tooltip -> tooltip.method_37020(narrationMsg));
    }

    public void method_25306() {
        this.action.accept(this);
    }

    @Override
    public void tick() {
        this.update.accept(this);
    }

    protected boolean method_25361(double mouseX, double mouseY) {
        return this.method_25405(mouseX, mouseY);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22763 && this.field_22764 && this.getBounds().contains(mouseX, mouseY);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float tickDelta) {
        if (!this.field_22764) {
            return;
        }
        this.getStyle().getTooltip().ifPresentOrElse(tooltip -> {
            if (tooltip != this.prevTooltip) {
                this.prevTooltip = tooltip;
                this.method_47400(tooltip.toTooltip());
            }
        }, () -> this.method_47400(null));
        super.method_25394(context, mouseX, mouseY, tickDelta);
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float tickDelta) {
        class_310 mc = class_310.method_1551();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        this.renderButtonBlit(context, this.method_46426(), this.method_46427(), this.getTextureY(), this.method_25368(), this.field_22759);
        this.renderBackground(context, mc, mouseX, mouseY);
        this.method_25355(this.getStyle().getText());
        this.drawIcon(context, mouseX, mouseY, tickDelta);
        int foreColor = this.getStyle().getColor();
        if (!this.field_22763) {
            foreColor = 0xA0A0A0;
        } else if (this.method_49606()) {
            foreColor = 0xFFFFA0;
        }
        this.renderForground(context, mc, mouseX, mouseY, foreColor | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
    }

    protected class_8000 method_47937() {
        class_8000 original = super.method_47937();
        return (screenWidth, screenHeight, x, y, width, height) -> {
            Vector2ic pos = original.method_47944(screenWidth, screenHeight, x, y, width, height);
            return new Vector2i(pos.x() + this.getStyle().toolTipX, pos.y() + this.getStyle().toolTipY);
        };
    }

    protected void drawIcon(class_332 context, int mouseX, int mouseY, float partialTicks) {
        if (this.getStyle().hasIcon()) {
            this.getStyle().getIcon().render(context, this.method_46426(), this.method_46427(), mouseX, mouseY, partialTicks);
        }
    }

    protected void renderForground(class_332 context, class_310 mc, int mouseX, int mouseY, int foreColor) {
        this.method_48589(context, mc.field_1772, foreColor);
    }

    protected void renderBackground(class_332 context, class_310 mc, int mouseX, int mouseY) {
    }

    public void method_48589(class_332 context, class_327 textRenderer, int color) {
        Bounds bounds = this.getBounds();
        int left = this.getStyle().getIcon().getBounds().right();
        Button.method_49605((class_332)context, (class_327)textRenderer, (class_2561)this.method_25369(), (int)(bounds.left + left), (int)bounds.top, (int)(bounds.right() - 2), (int)bounds.bottom(), (int)color);
    }

    protected int getTextureY() {
        int i = 1;
        if (!this.field_22763) {
            i = 0;
        } else if (this.method_25367()) {
            i = 2;
        }
        return 46 + i * 20;
    }

    protected final void renderButtonBlit(class_332 context, int x, int y, int state, int blockWidth, int blockHeight) {
        context.method_49697(field_22757, x, y, blockWidth, blockHeight, 20, 4, 200, 20, 0, state);
    }
}

