/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import net.lenni0451.reflect.Fields;
import net.lenni0451.reflect.JVMConstants;
import net.lenni0451.reflect.JavaBypass;
import net.lenni0451.reflect.exceptions.InvalidOOPSizeException;

public class Objects {
    private static final ThreadLocal<Object[]> OBJECT_ARRAY_CACHE = ThreadLocal.withInitial(() -> new Object[1]);
    public static final long ARRAY_BASE_OFFSET = JavaBypass.UNSAFE.arrayBaseOffset(Object[].class);
    public static final int ARRAY_INDEX_SCALE = JavaBypass.UNSAFE.arrayIndexScale(Object[].class);
    public static final int ADDRESS_SIZE = JavaBypass.UNSAFE.addressSize();
    public static final int OOP_SIZE = CompressedOopsClass.access$000();
    public static final int OBJECT_HEADER_SIZE = BooleanHeaderClass.access$100();
    public static final int ARRAY_HEADER_SIZE = OBJECT_HEADER_SIZE + 4;
    public static final int OBJECT_ALIGNMENT = Objects.getObjectAlignment();
    public static final boolean COMPRESSED_OOPS = ADDRESS_SIZE != OOP_SIZE;
    public static final int COMPRESSED_OOP_SHIFT = Objects.log2p(OBJECT_ALIGNMENT);
    public static final long COMPRESSED_OOP_BASE = Objects.toNativeAddress(null);
    public static final long KLASS_OFFSET = OBJECT_HEADER_SIZE - OOP_SIZE;

    @Deprecated
    public static long toAddress(Object o) {
        return Objects.toJVMAddress(o);
    }

    public static long toJVMAddress(Object o) {
        long jvmAddress;
        Object[] array = OBJECT_ARRAY_CACHE.get();
        array[0] = o;
        if (OOP_SIZE == 4) {
            jvmAddress = (long)JavaBypass.UNSAFE.getInt(array, ARRAY_BASE_OFFSET) & 0xFFFFFFFFL;
        } else if (OOP_SIZE == 8) {
            jvmAddress = JavaBypass.UNSAFE.getLong(array, ARRAY_BASE_OFFSET);
        } else {
            throw new InvalidOOPSizeException();
        }
        array[0] = null;
        return jvmAddress;
    }

    public static long toJVMAddress(long nativeAddress) {
        if (COMPRESSED_OOPS) {
            return nativeAddress - COMPRESSED_OOP_BASE >>> COMPRESSED_OOP_SHIFT;
        }
        return nativeAddress;
    }

    public static long toNativeAddress(Object o) {
        return Objects.toNativeAddress(Objects.toJVMAddress(o));
    }

    public static long toNativeAddress(long jvmAddress) {
        if (COMPRESSED_OOPS) {
            return COMPRESSED_OOP_BASE + (jvmAddress << COMPRESSED_OOP_SHIFT);
        }
        return jvmAddress;
    }

    @Deprecated
    public static <T> T fromAddress(long jvmAddress) {
        return Objects.fromJVMAddress(jvmAddress);
    }

    public static <T> T fromJVMAddress(long jvmAddress) {
        Object[] array = OBJECT_ARRAY_CACHE.get();
        if (OOP_SIZE == 4) {
            JavaBypass.UNSAFE.putInt(array, ARRAY_BASE_OFFSET, (int)jvmAddress);
        } else if (OOP_SIZE == 8) {
            JavaBypass.UNSAFE.putLong(array, ARRAY_BASE_OFFSET, jvmAddress);
        } else {
            throw new InvalidOOPSizeException();
        }
        Object o = array[0];
        array[0] = null;
        return (T)o;
    }

    public static void copyMemory(Object from, Object to, long size) {
        Objects.copyMemory(from, 0L, to, 0L, size);
    }

    public static void copyMemory(Object from, long fromOffset, Object to, long toOffset, long size) {
        JavaBypass.UNSAFE.copyMemory(Objects.toJVMAddress(from) + fromOffset, Objects.toJVMAddress(to) + toOffset, size);
    }

    public static long getKlass(Class<?> clazz) {
        if (clazz.isArray()) {
            return Objects.getKlass(Array.newInstance(clazz.getComponentType(), 0));
        }
        return Objects.getKlass(JavaBypass.UNSAFE.allocateInstance(clazz));
    }

    public static long getKlass(Object o) {
        if (OOP_SIZE == 4) {
            return (long)JavaBypass.UNSAFE.getInt(o, KLASS_OFFSET) & 0xFFFFFFFFL;
        }
        if (OOP_SIZE == 8) {
            return JavaBypass.UNSAFE.getLong(o, KLASS_OFFSET);
        }
        throw new InvalidOOPSizeException();
    }

    public static <T> T cast(Object o, Class<T> target) {
        return Objects.cast(o, Objects.getKlass(target));
    }

    public static <T> T cast(Object o, Object target) {
        return Objects.cast(o, Objects.getKlass(target));
    }

    public static <T> T cast(Object o, long klass) {
        if (JVMConstants.OPENJ9_RUNTIME) {
            throw new UnsupportedOperationException("OpenJ9 is not supported");
        }
        if (OOP_SIZE == 4) {
            JavaBypass.UNSAFE.putInt(o, KLASS_OFFSET, (int)klass);
        } else if (OOP_SIZE == 8) {
            JavaBypass.UNSAFE.putLong(o, KLASS_OFFSET, klass);
        } else {
            throw new InvalidOOPSizeException();
        }
        return (T)o;
    }

    private static int getObjectAlignment() {
        HotSpotDiagnosticMXBean mxBean;
        if (!JVMConstants.OPENJ9_RUNTIME && (mxBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class)) != null) {
            return Integer.parseInt(mxBean.getVMOption("ObjectAlignmentInBytes").getValue());
        }
        return 8;
    }

    private static int log2p(int i) {
        int result = 0;
        while ((i >>= 1) != 0) {
            ++result;
        }
        return result;
    }

    private static class BooleanHeaderClass {
        public boolean b;

        private BooleanHeaderClass() {
        }

        private static int getHeaderSize() {
            long b = JavaBypass.UNSAFE.objectFieldOffset(Fields.getDeclaredField(BooleanHeaderClass.class, "b"));
            return (int)b;
        }

        static /* synthetic */ int access$100() {
            return BooleanHeaderClass.getHeaderSize();
        }
    }

    private static class CompressedOopsClass {
        public Object o1;
        public Object o2;

        private CompressedOopsClass() {
        }

        private static int getOopSize() {
            long o1 = JavaBypass.UNSAFE.objectFieldOffset(Fields.getDeclaredField(CompressedOopsClass.class, "o1"));
            long o2 = JavaBypass.UNSAFE.objectFieldOffset(Fields.getDeclaredField(CompressedOopsClass.class, "o2"));
            return (int)Math.abs(o2 - o1);
        }

        static /* synthetic */ int access$000() {
            return CompressedOopsClass.getOopSize();
        }
    }
}

