/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect;

import java.lang.reflect.Field;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.lenni0451.reflect.Constructors;
import net.lenni0451.reflect.Fields;
import net.lenni0451.reflect.JVMConstants;

public class Enums {
    public static <T extends Enum<T>> T newInstance(Class<T> enumClass, String name, int ordinal, Class<?>[] argumentTypes, Object[] arguments) {
        Class[] types = new Class[arguments.length + 2];
        types[0] = String.class;
        types[1] = Integer.TYPE;
        System.arraycopy(argumentTypes, 0, types, 2, argumentTypes.length);
        Object[] args = new Object[arguments.length + 2];
        args[0] = name;
        args[1] = ordinal;
        System.arraycopy(arguments, 0, args, 2, arguments.length);
        return (T)((Enum)Constructors.invoke(Constructors.getDeclaredConstructor(enumClass, types), args));
    }

    public static <T extends Enum<T>> void addEnumInstance(Class<T> enumClass, T enumValue) {
        Field values = Fields.getDeclaredField(enumClass, JVMConstants.FIELD_Enum_$VALUES);
        Object[] valuesArray = (Object[])Fields.getObject(null, values);
        valuesArray = Arrays.copyOf(valuesArray, valuesArray.length + 1);
        valuesArray[valuesArray.length - 1] = enumValue;
        Fields.setObject(null, values, valuesArray);
        Enums.clearEnumCache(enumClass);
    }

    public static void clearEnumCache(Class<?> enumClass) {
        if (JVMConstants.OPENJ9_RUNTIME) {
            Fields.setObject(enumClass, Fields.getDeclaredField(Class.class, JVMConstants.FIELD_Class_EnumVars), null);
        } else {
            Fields.setObject(enumClass, Fields.getDeclaredField(Class.class, JVMConstants.FIELD_Class_enumConstants), null);
            Fields.setObject(enumClass, Fields.getDeclaredField(Class.class, JVMConstants.FIELD_Class_enumConstantDirectory), null);
        }
    }

    @Nullable
    public static Object valueOfIgnoreCase(Class<?> enumClass, String name) {
        for (Object constant : enumClass.getEnumConstants()) {
            Enum enumConstant = (Enum)constant;
            if (!enumConstant.name().equalsIgnoreCase(name)) continue;
            return constant;
        }
        return null;
    }
}

