/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry;

import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_357;

@Environment(value=EnvType.CLIENT)
public class CustomSlider
extends class_357 {
    private final double min;
    private final double max;
    private final Consumer<Double> onChange;
    private final boolean wholeNumber;

    public CustomSlider(int x, int y, int width, int height, double value, double min, double max, Consumer<Double> onChange, boolean wholeNumber) {
        super(x, y, width, height, CustomSlider.toText(value), CustomSlider.rangeToSlider(value, min, max));
        this.min = min;
        this.max = max;
        this.onChange = onChange;
        this.wholeNumber = wholeNumber;
    }

    protected void method_25346() {
        this.method_25355(CustomSlider.toText(this.getValue()));
    }

    protected void method_25344() {
        this.onChange.accept(this.getValue());
    }

    public double getValue() {
        double result = CustomSlider.sliderToRange(this.field_22753, this.min, this.max);
        if (this.wholeNumber) {
            result = Math.floor(result + 0.5);
        }
        return result;
    }

    public void setValue(double value) {
        this.field_22753 = CustomSlider.rangeToSlider(value, this.min, this.max);
    }

    private static double sliderToRange(double value, double min, double max) {
        return value * (max - min) + min;
    }

    private static double rangeToSlider(double value, double min, double max) {
        return (value - min) / (max - min);
    }

    private static class_2561 toText(double value) {
        return class_2561.method_43470((String)Objects.toString(value));
    }
}

