/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models.geometry;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.core.PortingLib;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.NullGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.RegisterGeometryLoadersCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class GeometryLoaderManager {
    private static ImmutableMap<class_2960, IGeometryLoader<?>> LOADERS;
    private static String LOADER_LIST;
    public static final List<class_2960> KNOWN_MISSING_LOADERS;

    @Nullable
    public static IGeometryLoader<?> get(class_2960 name) {
        return (IGeometryLoader)LOADERS.get((Object)name);
    }

    public static String getLoaderList() {
        return LOADER_LIST;
    }

    @Nullable
    public static String getModelLoader(JsonObject json) {
        if (json.has("porting_lib:loader")) {
            return class_3518.method_15265((JsonObject)json, (String)"porting_lib:loader");
        }
        if (json.has("loader")) {
            return class_3518.method_15265((JsonObject)json, (String)"loader");
        }
        return null;
    }

    @ApiStatus.Internal
    public static void init() {
        HashMap loaders = new HashMap();
        ((RegisterGeometryLoadersCallback)RegisterGeometryLoadersCallback.EVENT.invoker()).registerGeometryLoaders(loaders);
        GeometryLoaderManager.getProvidedLoaders(loaders);
        LOADERS = ImmutableMap.copyOf(loaders);
        LOADER_LIST = loaders.keySet().stream().map(class_2960::toString).collect(Collectors.joining(", "));
    }

    private static void getProvidedLoaders(Map<class_2960, IGeometryLoader<?>> loaders) {
        ArrayList<class_2960> providedLoaders = new ArrayList<class_2960>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            CustomValue provided = mod.getMetadata().getCustomValue("porting_lib:provided_loaders");
            if (provided == null) continue;
            if (provided.getType() != CustomValue.CvType.ARRAY) {
                PortingLib.LOGGER.error("Mod {} specifies provided loaders, but it's not an array! got: {}", (Object)mod.getMetadata().getName(), (Object)provided.getType());
                continue;
            }
            for (CustomValue value : provided.getAsArray()) {
                if (value.getType() != CustomValue.CvType.STRING) {
                    PortingLib.LOGGER.error("Mod {} specifies an array of provided loaders, but it contains a non-string! got: {}", (Object)mod.getMetadata().getName(), (Object)value.getType());
                    continue;
                }
                String idString = value.getAsString();
                class_2960 id = class_2960.method_12829((String)idString);
                if (id == null) {
                    PortingLib.LOGGER.error("Mod {} provides loader {}, which is not a valid ID!", (Object)mod.getMetadata().getName(), (Object)idString);
                    continue;
                }
                providedLoaders.add(id);
            }
        }
        if (!providedLoaders.isEmpty()) {
            StringBuilder out = new StringBuilder("Registered %s provided loaders: ".formatted(providedLoaders.size()));
            for (class_2960 loader : providedLoaders) {
                out.append(loader).append(", ");
                loaders.put(loader, NullGeometryLoader.INSTANCE);
            }
            PortingLib.LOGGER.info(out.substring(0, out.length() - 2));
        }
    }

    private GeometryLoaderManager() {
    }

    static {
        KNOWN_MISSING_LOADERS = new ArrayList<class_2960>();
        GeometryLoaderManager.init();
    }
}

