/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_156;
import net.minecraft.class_4590;
import net.minecraft.class_765;
import org.joml.Vector3f;
import org.joml.Vector4f;

public final class QuadTransformers {
    private static final RenderContext.QuadTransform EMPTY = quad -> true;
    private static final RenderContext.QuadTransform[] EMISSIVE_TRANSFORMERS = (RenderContext.QuadTransform[])class_156.method_654((Object)new RenderContext.QuadTransform[16], array -> Arrays.setAll(array, i -> QuadTransformers.applyingLightmap(class_765.method_23687((int)i, (int)i))));

    public static RenderContext.QuadTransform empty() {
        return EMPTY;
    }

    public static RenderContext.QuadTransform applying(class_4590 transform) {
        if (transform.isIdentity()) {
            return QuadTransformers.empty();
        }
        return quad -> {
            Vector4f pos;
            float z;
            float y;
            float x;
            int i;
            for (i = 0; i < 4; ++i) {
                x = quad.x(i);
                y = quad.y(i);
                z = quad.z(i);
                pos = new Vector4f(x, y, z, 1.0f);
                transform.transformPosition(pos);
                pos.div(pos.w);
                quad.pos(i, pos.x(), pos.y(), pos.z());
            }
            for (i = 0; i < 4; ++i) {
                if (!quad.hasNormal(i)) continue;
                x = quad.normalX(i);
                y = quad.normalY(i);
                z = quad.normalZ(i);
                pos = new Vector3f(x, y, z);
                transform.transformNormal((Vector3f)pos);
                quad.normal(i, (Vector3f)pos);
            }
            return true;
        };
    }

    public static RenderContext.QuadTransform applyingLightmap(int packedLight) {
        return quad -> {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, packedLight);
            }
            return true;
        };
    }

    public static RenderContext.QuadTransform applyingLightmap(int blockLight, int skyLight) {
        return QuadTransformers.applyingLightmap(class_765.method_23687((int)blockLight, (int)skyLight));
    }

    public static RenderContext.QuadTransform settingEmissivity(int emissivity) {
        Preconditions.checkArgument((emissivity >= 0 && emissivity < 16 ? 1 : 0) != 0, (Object)"Emissivity must be between 0 and 15.");
        return EMISSIVE_TRANSFORMERS[emissivity];
    }

    public static RenderContext.QuadTransform settingMaxEmissivity() {
        return EMISSIVE_TRANSFORMERS[15];
    }

    public static RenderContext.QuadTransform applyingColor(int color) {
        int fixedColor = QuadTransformers.toABGR(color);
        return quad -> {
            for (int i = 0; i < 4; ++i) {
                quad.spriteColor(i, 0, fixedColor);
            }
            return true;
        };
    }

    public static RenderContext.QuadTransform applyingColor(int red, int green, int blue) {
        return QuadTransformers.applyingColor(255, red, green, blue);
    }

    public static RenderContext.QuadTransform applyingColor(int alpha, int red, int green, int blue) {
        return QuadTransformers.applyingColor(alpha << 24 | red << 16 | green << 8 | blue);
    }

    public static int toABGR(int color) {
        return color & 0xFF00FF00 | color >> 16 & 0xFF | color << 16 & 0xFF0000;
    }

    private QuadTransformers() {
    }
}

