/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.kaleido.lib.quiltconfig.impl.builders;

import folk.sisby.kaleido.lib.quiltconfig.api.Config;
import folk.sisby.kaleido.lib.quiltconfig.api.ReflectiveConfig;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.Processor;
import folk.sisby.kaleido.lib.quiltconfig.api.exceptions.ConfigCreationException;
import folk.sisby.kaleido.lib.quiltconfig.api.exceptions.ConfigFieldException;
import folk.sisby.kaleido.lib.quiltconfig.api.values.TrackedValue;
import folk.sisby.kaleido.lib.quiltconfig.impl.ConfigFieldAnnotationProcessors;
import folk.sisby.kaleido.lib.quiltconfig.impl.builders.TrackedValueBuilderImpl;
import folk.sisby.kaleido.lib.quiltconfig.impl.tree.TrackedValueImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectiveConfigCreator<C>
implements Config.Creator {
    private final Class<C> creatorClass;
    private C instance;

    public ReflectiveConfigCreator(Class<C> creatorClass) {
        this.creatorClass = creatorClass;
    }

    private void createField(Config.SectionBuilder builder, Object object, Field field) throws IllegalAccessException {
        if (!Modifier.isStatic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers())) {
            Object defaultValue;
            if (!Modifier.isFinal(field.getModifiers())) {
                throw new ConfigFieldException("Field '" + field.getType().getName() + ':' + field.getName() + "' is not final");
            }
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            if ((defaultValue = field.get(object)) instanceof TrackedValueImpl) {
                TrackedValueImpl value = (TrackedValueImpl)defaultValue;
                TrackedValueBuilderImpl delegateBuilder = new TrackedValueBuilderImpl(value.getDefaultValue(), field.getName());
                for (Annotation annotation : field.getAnnotations()) {
                    ConfigFieldAnnotationProcessors.applyAnnotationProcessors(annotation, delegateBuilder);
                }
                if (field.isAnnotationPresent(Processor.class)) {
                    Processor processor = field.getAnnotation(Processor.class);
                    try {
                        Method method = field.getDeclaringClass().getMethod(processor.value(), TrackedValue.Builder.class);
                        method.invoke(object, delegateBuilder);
                    }
                    catch (NoSuchMethodException e) {
                        throw new ConfigCreationException("Processor method '" + processor.value() + "' not found.");
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new ConfigCreationException("Exception invoking processor method '" + processor.value() + "': " + e.getLocalizedMessage());
                    }
                }
                TrackedValueImpl delegate = (TrackedValueImpl)delegateBuilder.build();
                if (value.key() != null) {
                    throw new IllegalStateException("Unexpected key set in TrackedValue. Please report this!");
                }
                value.setKey(delegate.key());
                if (!value.metadata.isEmpty()) {
                    throw new IllegalStateException("Unexpected metadata value set in TrackedValue. Please report this!");
                }
                value.metadata = delegate.metadata;
                if (!value.constraints.isEmpty()) {
                    throw new IllegalStateException("Unexpected constraints value set in TrackedValue. Please report this!");
                }
                value.constraints = delegate.constraints;
                if (!value.callbacks.isEmpty()) {
                    throw new IllegalStateException("Unexpected callback value set in TrackedValue. Please report this!");
                }
                value.callbacks = delegate.callbacks;
                builder.field(value);
            } else if (defaultValue instanceof ReflectiveConfig.Section) {
                builder.section(field.getName(), b -> {
                    for (Annotation annotation : field.getAnnotations()) {
                        ConfigFieldAnnotationProcessors.applyAnnotationProcessors(annotation, b);
                    }
                    for (Field f : defaultValue.getClass().getDeclaredFields()) {
                        if (f.isSynthetic()) continue;
                        try {
                            this.createField((Config.SectionBuilder)b, defaultValue, f);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                if (defaultValue == null) {
                    throw new ConfigFieldException("Default value for field '" + field.getName() + "' cannot be null");
                }
                throw new ConfigFieldException("Class '" + defaultValue.getClass().getName() + "' of field '" + field.getName() + "' of config class '" + field.getDeclaringClass().getName() + "'is not a valid config value: it must be a TrackedValue or implement org.quiltmc.loader.api.Config.Section");
            }
        }
    }

    @Override
    public void create(Config.Builder builder) {
        block7: {
            if (this.instance != null) {
                throw new ConfigCreationException("Reflective config creator used more than once");
            }
            try {
                this.instance = this.creatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (Field field : this.creatorClass.getDeclaredFields()) {
                    this.createField(builder, this.instance, field);
                }
                if (!this.creatorClass.isAnnotationPresent(Processor.class)) break block7;
                Processor processor = this.creatorClass.getAnnotation(Processor.class);
                try {
                    Method method = this.creatorClass.getMethod(processor.value(), Config.Builder.class);
                    method.invoke(this.instance, builder);
                }
                catch (NoSuchMethodException e) {
                    throw new ConfigCreationException("Processor method '" + processor.value() + "' not found.");
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new ConfigCreationException("Exception invoking processor method '" + processor.value() + "': " + e.getLocalizedMessage());
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ConfigCreationException(e);
            }
        }
    }

    public static <C> ReflectiveConfigCreator<C> of(Class<C> creatorClass) {
        return new ReflectiveConfigCreator<C>(creatorClass);
    }

    public C getInstance() {
        if (this.instance == null) {
            throw new RuntimeException("Config not built yet");
        }
        return this.instance;
    }
}

