/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.kaleido.lib.quiltconfig.impl;

import folk.sisby.kaleido.lib.quiltconfig.api.Constraint;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.Comment;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.ConfigFieldAnnotationProcessor;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.FloatRange;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.IntegerRange;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.Matches;
import folk.sisby.kaleido.lib.quiltconfig.api.exceptions.ConfigFieldException;
import folk.sisby.kaleido.lib.quiltconfig.api.metadata.MetadataContainerBuilder;
import folk.sisby.kaleido.lib.quiltconfig.api.values.CompoundConfigValue;
import folk.sisby.kaleido.lib.quiltconfig.api.values.TrackedValue;
import folk.sisby.kaleido.lib.quiltconfig.impl.Comments;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ConfigFieldAnnotationProcessors {
    private static final Map<Class<? extends Annotation>, List<ConfigFieldAnnotationProcessor<?>>> PROCESSORS = new HashMap();

    public static <T extends Annotation> void register(Class<T> annotationClass, ConfigFieldAnnotationProcessor<T> processor) {
        PROCESSORS.computeIfAbsent(annotationClass, c -> new ArrayList()).add(processor);
    }

    private static <T extends Annotation> void process(ConfigFieldAnnotationProcessor<T> processor, T annotation, MetadataContainerBuilder<?> builder) {
        processor.process(annotation, builder);
    }

    public static void applyAnnotationProcessors(Annotation annotation, MetadataContainerBuilder<?> builder) {
        for (ConfigFieldAnnotationProcessor processor : PROCESSORS.getOrDefault(annotation.annotationType(), Collections.emptyList())) {
            ConfigFieldAnnotationProcessors.process(processor, annotation, builder);
        }
    }

    static {
        ConfigFieldAnnotationProcessors.register(Comment.class, new CommentProcessor());
        ConfigFieldAnnotationProcessors.register(Comments.class, new Comments.Processor());
        ConfigFieldAnnotationProcessors.register(IntegerRange.class, new IntegerRangeProcessor());
        ConfigFieldAnnotationProcessors.register(FloatRange.class, new FloatRangeProcessor());
        ConfigFieldAnnotationProcessors.register(Matches.class, new MatchesProcessor());
    }

    private static final class CommentProcessor
    implements ConfigFieldAnnotationProcessor<Comment> {
        private CommentProcessor() {
        }

        @Override
        public void process(Comment comment, MetadataContainerBuilder<?> builder) {
            for (String c : comment.value()) {
                builder.metadata(Comment.TYPE, comments -> comments.add(c));
            }
        }
    }

    private static final class IntegerRangeProcessor
    implements ConfigFieldAnnotationProcessor<IntegerRange> {
        private IntegerRangeProcessor() {
        }

        @Override
        public void process(IntegerRange range, MetadataContainerBuilder<?> builder) {
            if (builder instanceof TrackedValue.Builder) {
                Object defaultValue = ((TrackedValue.Builder)builder).getDefaultValue();
                if (defaultValue instanceof Integer) {
                    ((TrackedValue.Builder)builder).constraint(Constraint.range((int)range.min(), (int)range.max()));
                } else if (defaultValue instanceof Long) {
                    ((TrackedValue.Builder)builder).constraint(Constraint.range(range.min(), range.max()));
                } else if (defaultValue instanceof CompoundConfigValue && Integer.class.isAssignableFrom(((CompoundConfigValue)defaultValue).getType())) {
                    ((TrackedValue.Builder)builder).constraint(Constraint.all(Constraint.range((int)range.min(), (int)range.max())));
                } else if (defaultValue instanceof CompoundConfigValue && Long.class.isAssignableFrom(((CompoundConfigValue)defaultValue).getType())) {
                    ((TrackedValue.Builder)builder).constraint(Constraint.all(Constraint.range(range.min(), range.max())));
                } else {
                    throw new ConfigFieldException("Constraint LongRange not applicable for type '" + defaultValue.getClass() + "'");
                }
            }
        }
    }

    private static final class FloatRangeProcessor
    implements ConfigFieldAnnotationProcessor<FloatRange> {
        private FloatRangeProcessor() {
        }

        @Override
        public void process(FloatRange range, MetadataContainerBuilder<?> builder) {
            if (builder instanceof TrackedValue.Builder) {
                Object defaultValue = ((TrackedValue.Builder)builder).getDefaultValue();
                if (defaultValue instanceof Float) {
                    ((TrackedValue.Builder)builder).constraint(Constraint.range((float)range.min(), (float)range.max()));
                } else if (defaultValue instanceof Double) {
                    ((TrackedValue.Builder)builder).constraint(Constraint.range(range.min(), range.max()));
                } else if (defaultValue instanceof CompoundConfigValue && Float.class.isAssignableFrom(((CompoundConfigValue)defaultValue).getType())) {
                    ((TrackedValue.Builder)builder).constraint(Constraint.all(Constraint.range((float)range.min(), (float)range.max())));
                } else if (defaultValue instanceof CompoundConfigValue && Double.class.isAssignableFrom(((CompoundConfigValue)defaultValue).getType())) {
                    ((TrackedValue.Builder)builder).constraint(Constraint.all(Constraint.range(range.min(), range.max())));
                } else {
                    throw new ConfigFieldException("Constraint FloatRange not applicable for type '" + defaultValue.getClass() + "'");
                }
            }
        }
    }

    private static final class MatchesProcessor
    implements ConfigFieldAnnotationProcessor<Matches> {
        private MatchesProcessor() {
        }

        @Override
        public void process(Matches matches, MetadataContainerBuilder<?> builder) {
            if (builder instanceof TrackedValue.Builder) {
                Object defaultValue = ((TrackedValue.Builder)builder).getDefaultValue();
                if (defaultValue instanceof String) {
                    ((TrackedValue.Builder)builder).constraint(Constraint.matching(matches.value()));
                } else if (defaultValue instanceof CompoundConfigValue && ((CompoundConfigValue)defaultValue).getType().equals(String.class)) {
                    ((TrackedValue.Builder)builder).constraint(Constraint.all(Constraint.matching(matches.value())));
                }
            }
        }
    }
}

