/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.kaleido.impl;

import folk.sisby.kaleido.lib.nightconfig.core.CommentedConfig;
import folk.sisby.kaleido.lib.nightconfig.core.InMemoryCommentedFormat;
import folk.sisby.kaleido.lib.nightconfig.core.UnmodifiableCommentedConfig;
import folk.sisby.kaleido.lib.nightconfig.core.UnmodifiableConfig;
import folk.sisby.kaleido.lib.nightconfig.core.io.ConfigParser;
import folk.sisby.kaleido.lib.nightconfig.core.io.ConfigWriter;
import folk.sisby.kaleido.lib.quiltconfig.api.Config;
import folk.sisby.kaleido.lib.quiltconfig.api.Constraint;
import folk.sisby.kaleido.lib.quiltconfig.api.MarshallingUtils;
import folk.sisby.kaleido.lib.quiltconfig.api.Serializer;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.Comment;
import folk.sisby.kaleido.lib.quiltconfig.api.values.CompoundConfigValue;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ConfigSerializableObject;
import folk.sisby.kaleido.lib.quiltconfig.api.values.TrackedValue;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ValueList;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ValueMap;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ValueTreeNode;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NightConfigSerializer<C extends CommentedConfig>
implements Serializer {
    private final String fileExtension;
    private final ConfigParser<C> parser;
    private final ConfigWriter writer;

    public NightConfigSerializer(String fileExtension, ConfigParser<C> parser, ConfigWriter writer) {
        this.fileExtension = fileExtension;
        this.parser = parser;
        this.writer = writer;
    }

    @Override
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public void serialize(Config config, OutputStream to) {
        this.writer.write((UnmodifiableConfig)NightConfigSerializer.write(NightConfigSerializer.createCommentedConfig(), config.nodes()), to);
    }

    @Override
    public void deserialize(Config config, InputStream from) {
        CommentedConfig read = (CommentedConfig)this.parser.parse(from);
        for (TrackedValue<?> trackedValue : config.values()) {
            if (!read.contains(trackedValue.key().toString())) continue;
            trackedValue.setValue(MarshallingUtils.coerce(read.get(trackedValue.key().toString()), trackedValue.getDefaultValue(), (c, entryConsumer) -> c.entrySet().forEach(e -> entryConsumer.put(e.getKey(), e.getValue()))), false);
        }
    }

    private static List<Object> convertList(List<?> list) {
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        for (Object value : list) {
            result.add(NightConfigSerializer.convertAny(value));
        }
        return result;
    }

    private static UnmodifiableCommentedConfig convertMap(ValueMap<?> map) {
        CommentedConfig result = NightConfigSerializer.createCommentedConfig();
        for (Map.Entry entry : map.entrySet()) {
            result.add((String)entry.getKey(), NightConfigSerializer.convertAny(entry.getValue()));
        }
        return result;
    }

    private static Object convertAny(Object value) {
        if (value instanceof ValueMap) {
            return NightConfigSerializer.convertMap((ValueMap)value);
        }
        if (value instanceof ValueList) {
            return NightConfigSerializer.convertList((ValueList)value);
        }
        if (value instanceof ConfigSerializableObject) {
            return NightConfigSerializer.convertAny(((ConfigSerializableObject)value).getRepresentation());
        }
        return value;
    }

    private static CommentedConfig write(CommentedConfig config, Iterable<ValueTreeNode> nodes) {
        for (ValueTreeNode node : nodes) {
            ArrayList<Object> comments = new ArrayList<Object>();
            if (node.hasMetadata(Comment.TYPE)) {
                for (String string : node.metadata(Comment.TYPE)) {
                    comments.add(string);
                }
            }
            if (node instanceof TrackedValue) {
                TrackedValue trackedValue = (TrackedValue)node;
                Object defaultValue = trackedValue.getDefaultValue();
                if (defaultValue.getClass().isEnum()) {
                    StringBuilder options = new StringBuilder("options: ");
                    ?[] enumConstants = defaultValue.getClass().getEnumConstants();
                    int enumConstantsLength = enumConstants.length;
                    for (int i = 0; i < enumConstantsLength; ++i) {
                        Object o = enumConstants[i];
                        options.append(o);
                        if (i >= enumConstantsLength - 1) continue;
                        options.append(", ");
                    }
                    comments.add(options.toString());
                }
                for (Constraint constraint : trackedValue.constraints()) {
                    comments.add(constraint.getRepresentation());
                }
                if (!(defaultValue instanceof CompoundConfigValue)) {
                    comments.add("default: " + defaultValue);
                }
                config.add(trackedValue.key().toString(), NightConfigSerializer.convertAny(trackedValue.getRealValue()));
            } else {
                NightConfigSerializer.write(config, (ValueTreeNode.Section)node);
            }
            if (comments.isEmpty()) continue;
            config.setComment(node.key().toString(), " " + String.join((CharSequence)"\n ", comments));
        }
        return config;
    }

    private static CommentedConfig createCommentedConfig() {
        return InMemoryCommentedFormat.defaultInstance().createConfig(LinkedHashMap::new);
    }
}

