/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.impl;

import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.web.api.AdvancedSubServer;
import io.gitlab.jfronny.libjf.web.api.ContentProvider;
import io.gitlab.jfronny.libjf.web.api.SubServer;
import io.gitlab.jfronny.libjf.web.api.WebInit;
import io.gitlab.jfronny.libjf.web.api.WebServer;
import io.gitlab.jfronny.libjf.web.impl.DefaultFileHost;
import io.gitlab.jfronny.libjf.web.impl.JfWebConfig;
import io.gitlab.jfronny.libjf.web.impl.RequestHandler;
import io.gitlab.jfronny.libjf.web.impl.util.WebPaths;
import io.gitlab.jfronny.libjf.web.impl.util.bluemapcore.HttpRequest;
import io.gitlab.jfronny.libjf.web.impl.util.bluemapcore.HttpResponse;
import io.gitlab.jfronny.libjf.web.impl.util.bluemapcore.HttpServer;
import io.gitlab.jfronny.libjf.web.impl.util.bluemapcore.HttpStatusCode;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import javax.management.openmbean.KeyAlreadyExistsException;
import net.fabricmc.loader.api.FabricLoader;

public class JfWebServer
implements WebServer {
    private HttpServer server = null;
    private final RequestHandler handler = new RequestHandler();
    private final int port;
    private final int maxConnections;
    private final DefaultFileHost dfh = new DefaultFileHost();

    public JfWebServer(int port, int maxConnections) {
        this.port = port;
        this.maxConnections = maxConnections;
    }

    @Override
    public String register(String webPath, ContentProvider provider) {
        if (this.handler.contentProviders.containsKey(webPath = WebPaths.simplify(webPath))) {
            throw new KeyAlreadyExistsException("A ContentProvider already exists at that address (" + this.handler.contentProviders.get(webPath).getClass() + ")");
        }
        this.handler.contentProviders.put(webPath, provider);
        return WebPaths.concat(this.getServerRoot(), webPath);
    }

    @Override
    public String registerFile(String webPath, Path file, Boolean readOnSend) throws IOException {
        if (readOnSend.booleanValue()) {
            if (!Files.exists(file, new LinkOption[0])) {
                throw new FileNotFoundException();
            }
            this.register(webPath, s -> {
                HttpResponse resp = new HttpResponse(HttpStatusCode.OK);
                resp.addHeader("Content-Type", Files.probeContentType(file));
                resp.addHeader("Content-Length", String.valueOf(Files.size(file)));
                FileInputStream fs = new FileInputStream(file.toFile());
                resp.setData(fs);
                return resp;
            });
            return WebPaths.concat(this.getServerRoot(), webPath);
        }
        return this.registerFile(webPath, Files.readAllBytes(file), Files.probeContentType(file));
    }

    @Override
    public String registerFile(String webPath, byte[] data, String contentType) {
        return this.register(webPath, s -> {
            HttpResponse resp = new HttpResponse(HttpStatusCode.OK);
            resp.addHeader("Content-Type", contentType);
            resp.addHeader("Content-Length", String.valueOf(data.length));
            ByteArrayInputStream fs = new ByteArrayInputStream(data);
            resp.setData(fs);
            return resp;
        });
    }

    @Override
    public String registerDir(String webPath, Path dir, Boolean readOnSend) throws IOException {
        try (Stream<Path> contentPath = Files.walk(dir, new FileVisitOption[0]);){
            if (readOnSend.booleanValue()) {
                String string = this.registerSubServer(webPath, (HttpRequest s, String[] t) -> {
                    HttpResponse resp;
                    boolean[] c = new boolean[]{false};
                    Path[] p_f = new Path[1];
                    contentPath.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Files::isReadable).forEach(q -> {
                        if (c[0]) {
                            return;
                        }
                        Path p = dir.toAbsolutePath().relativize(q.toAbsolutePath());
                        String wp = webPath;
                        for (Path path : p) {
                            wp = WebPaths.concat(wp, path.toString());
                        }
                        if (Objects.equals(WebPaths.simplify(wp), WebPaths.simplify(WebPaths.concat(t)))) {
                            p_f[0] = q;
                            c[0] = true;
                        }
                    });
                    if (c[0]) {
                        resp = new HttpResponse(HttpStatusCode.OK);
                        resp.addHeader("Content-Type", Files.probeContentType(p_f[0]));
                        resp.addHeader("Content-Length", String.valueOf(Files.size(p_f[0])));
                        FileInputStream fs = new FileInputStream(p_f[0].toFile());
                        resp.setData(fs);
                    } else {
                        resp = new HttpResponse(HttpStatusCode.NOT_FOUND);
                    }
                    return resp;
                });
                return string;
            }
            contentPath.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Files::isReadable).forEach(s -> {
                Path p = dir.toAbsolutePath().relativize(s.toAbsolutePath());
                String wp = webPath;
                for (Path path : p) {
                    wp = WebPaths.concat(wp, path.toString());
                }
                try {
                    this.registerFile(wp, (Path)s, false);
                }
                catch (IOException e) {
                    LibJf.LOGGER.error("Could not register static file", (Throwable)e);
                }
            });
            String string = WebPaths.concat(this.getServerRoot(), webPath);
            return string;
        }
    }

    @Override
    public String registerSubServer(String webPath, final SubServer subServer) {
        return this.registerSubServer(webPath, new AdvancedSubServer(){

            @Override
            public void onStop() {
            }

            @Override
            public void onStart() {
            }

            @Override
            public HttpResponse handle(HttpRequest request, String[] segments) throws IOException {
                return subServer.handle(request, segments);
            }
        });
    }

    @Override
    public String registerSubServer(String webPath, AdvancedSubServer subServer) {
        if (this.handler.subServers.containsKey(webPath = WebPaths.simplify(webPath))) {
            throw new KeyAlreadyExistsException("A Subserver already exists at that address (" + this.handler.subServers.get(webPath).getClass() + ")");
        }
        this.handler.subServers.put(webPath, subServer);
        return WebPaths.concat(this.getServerRoot(), webPath);
    }

    @Override
    public String getServerRoot() {
        Object ip = JfWebConfig.serverIp;
        if (!((String)ip).startsWith("http")) {
            ip = "http://" + (String)ip;
        }
        if (JfWebConfig.portOverride != -1) {
            return WebPaths.simplify((String)ip) + ":" + JfWebConfig.portOverride;
        }
        return WebPaths.simplify((String)ip) + ":" + JfWebConfig.port;
    }

    @Override
    public synchronized void stop() {
        for (AdvancedSubServer subServer : this.handler.subServers.values()) {
            subServer.onStop();
        }
        if (this.server != null) {
            try {
                this.server.close();
                this.server.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void restart() {
        JfWebConfig.ensureValidPort();
        int tmpPort = this.port;
        if (this.server != null) {
            tmpPort = this.server.getPort();
            this.stop();
        }
        this.handler.clear();
        this.server = new HttpServer(null, tmpPort, this.maxConnections, this.handler, () -> {
            if (JfWebConfig.enableFileHost) {
                this.dfh.register(this);
            }
            FabricLoader.getInstance().getEntrypointContainers("libjf:web", WebInit.class).forEach(entrypoint -> {
                WebInit init = (WebInit)entrypoint.getEntrypoint();
                init.register(this);
            });
        });
        this.server.start();
        try {
            this.server.waitUntilReady();
        }
        catch (InterruptedException e) {
            this.stop();
            LibJf.LOGGER.error("Server could not be readied", (Throwable)e);
        }
        for (AdvancedSubServer subServer : this.handler.subServers.values()) {
            subServer.onStart();
        }
    }

    @Override
    public boolean isActive() {
        return this.server != null && this.server.isAlive();
    }
}

