/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.networking.impl;

import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.impl.CommonResourcePackInfoHolder;
import eu.pb4.polymer.networking.api.EarlyPlayNetworkHandler;
import eu.pb4.polymer.networking.api.PolymerHandshakeHandler;
import eu.pb4.polymer.networking.impl.ClientPackets;
import eu.pb4.polymer.networking.impl.NetImpl;
import eu.pb4.polymer.networking.impl.NetworkHandlerExtension;
import eu.pb4.polymer.networking.impl.ServerPacketRegistry;
import eu.pb4.polymer.networking.impl.TempPlayerLoginAttachments;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_6374;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PolymerHandshakeHandlerImplLogin
extends EarlyPlayNetworkHandler
implements PolymerHandshakeHandler {
    public static long MAGIC_INIT_VALUE = -4940329573899144332L;
    public static int CONTINUE_LOGIN_ID = 1;
    private String polymerVersion = "";
    private Object2IntMap<class_2960> protocolVersions = null;
    private final Object2LongMap<class_2960> lastUpdate = new Object2LongOpenHashMap();
    private final Map<class_2960, class_2520> metadata = new HashMap<class_2960, class_2520>();

    private PolymerHandshakeHandlerImplLogin(EarlyPlayNetworkHandler.Context context) {
        super(new class_2960("polymer", "early_handshake"), context);
        ((TempPlayerLoginAttachments)this.getPlayer()).polymerNet$setHandshakeHandler(this);
        if (NetImpl.SEND_GAME_JOIN_PACKET) {
            this.sendInitialGameJoin();
        }
        this.sendKeepAlive(MAGIC_INIT_VALUE);
    }

    @Nullable
    public static EarlyPlayNetworkHandler create(EarlyPlayNetworkHandler.Context context) {
        if (PolymerCommonUtils.isBedrockPlayer((class_3222)context.player())) {
            return null;
        }
        return new PolymerHandshakeHandlerImplLogin(context);
    }

    @Override
    public void set(String polymerVersion, Object2IntMap<class_2960> protocolVersions) {
        this.polymerVersion = polymerVersion;
        this.protocolVersions = protocolVersions;
    }

    @Override
    public void setMetadataValue(class_2960 identifier, class_2520 value) {
        this.metadata.put(identifier, value);
    }

    @Override
    public boolean isPolymer() {
        return !this.polymerVersion.isEmpty();
    }

    @Override
    public String getPolymerVersion() {
        return this.polymerVersion;
    }

    @Override
    public int getSupportedProtocol(class_2960 identifier) {
        return this.protocolVersions != null ? this.protocolVersions.getOrDefault((Object)identifier, -1) : -1;
    }

    @Override
    public void setLastPacketTime(class_2960 identifier) {
        this.lastUpdate.put((Object)identifier, System.currentTimeMillis());
    }

    @Override
    public long getLastPacketTime(class_2960 identifier) {
        return this.lastUpdate.getLong((Object)identifier);
    }

    @Override
    public void apply(class_3244 handler) {
        NetworkHandlerExtension polymerHandler = NetworkHandlerExtension.of(handler);
        polymerHandler.polymerNet$setVersion(this.getPolymerVersion());
        polymerHandler.polymerNet$getMetadataMap().putAll(this.metadata);
        if (this.protocolVersions != null) {
            for (Object2IntMap.Entry entry : this.protocolVersions.object2IntEntrySet()) {
                polymerHandler.polymerNet$setSupportedVersion((class_2960)entry.getKey(), entry.getIntValue());
            }
        }
        for (Object2IntMap.Entry entry : this.lastUpdate.keySet()) {
            polymerHandler.polymerNet$savePacketTime((class_2960)entry);
        }
    }

    @Override
    public boolean getPackStatus() {
        return ((CommonResourcePackInfoHolder)this.getPlayer()).polymerCommon$hasResourcePack();
    }

    @Override
    public void reset() {
        this.protocolVersions.clear();
    }

    @Override
    public void setPackStatus(boolean status) {
        ((CommonResourcePackInfoHolder)this.getPlayer()).polymerCommon$setResourcePack(status);
    }

    @Override
    public boolean handleCustomPayload(class_2817 packet) {
        class_2540 data = packet.method_36170();
        if (packet.method_36169().equals((Object)ClientPackets.HANDSHAKE)) {
            try {
                ServerPacketRegistry.handleHandshake(this, data.method_10816(), data);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return true;
        }
        if (packet.method_36169().equals((Object)ClientPackets.METADATA)) {
            try {
                ServerPacketRegistry.handleMetadata(this, data.method_10816(), data);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @Override
    public void handleKeepAlive(long value) {
        if (value == MAGIC_INIT_VALUE) {
            this.sendPing(CONTINUE_LOGIN_ID);
        }
    }

    @Override
    public void method_36580(class_6374 packet) {
        if (packet.method_36960() == CONTINUE_LOGIN_ID) {
            this.continueJoining();
        }
    }
}

