/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.networking.api.client;

import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.networking.api.client.PolymerClientPacketHandler;
import eu.pb4.polymer.networking.impl.ClientPackets;
import eu.pb4.polymer.networking.impl.ServerPackets;
import eu.pb4.polymer.networking.impl.client.ClientPacketRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_4614;
import net.minecraft.class_634;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class PolymerClientNetworking {
    public static final SimpleEvent<Runnable> AFTER_HANDSHAKE_RECEIVED = new SimpleEvent();
    public static final SimpleEvent<Runnable> AFTER_METADATA_RECEIVED = new SimpleEvent();
    public static final SimpleEvent<Runnable> AFTER_DISABLE = new SimpleEvent();
    public static final SimpleEvent<Runnable> BEFORE_METADATA_SYNC = new SimpleEvent();

    private PolymerClientNetworking() {
    }

    public static boolean sendDirect(class_634 player, class_2960 identifier, class_2540 packetByteBuf) {
        player.method_2883((class_2596)new class_2817(identifier, packetByteBuf));
        return true;
    }

    public static boolean registerPacketHandler(class_2960 identifier, PolymerClientPacketHandler handler) {
        return PolymerClientNetworking.registerPacketHandler(identifier, handler, ServerPackets.REGISTRY.getOrDefault(identifier, new int[0]));
    }

    public static boolean registerPacketHandler(class_2960 identifier, PolymerClientPacketHandler handler, int ... supportedVersions) {
        if (!ClientPacketRegistry.PACKETS.containsKey(identifier)) {
            ServerPackets.register(identifier, supportedVersions);
            ClientPacketRegistry.PACKETS.put(identifier, handler);
            return true;
        }
        return false;
    }

    public static boolean registerSendPacket(class_2960 identifier, int ... supportedVersions) {
        ClientPackets.register(identifier, supportedVersions);
        return true;
    }

    public static int getSupportedVersion(class_2960 identifier) {
        return ClientPacketRegistry.CLIENT_PROTOCOL.getOrDefault((Object)identifier, -1);
    }

    @Nullable
    public static <T extends class_2520> T getMetadata(class_2960 identifier, class_4614<T> type) {
        class_2520 x = ClientPacketRegistry.SERVER_METADATA.get(identifier);
        if (x != null && x.method_23258() == type) {
            return (T)x;
        }
        return null;
    }

    public static void setClientMetadata(class_2960 identifier, @Nullable class_2520 nbtElement) {
        if (nbtElement == null) {
            ClientPacketRegistry.METADATA.remove(identifier);
        } else {
            ClientPacketRegistry.METADATA.put(identifier, nbtElement);
        }
    }

    public static String getServerVersion() {
        return ClientPacketRegistry.lastVersion;
    }

    public static boolean isEnabled() {
        return ClientPacketRegistry.lastVersion.isEmpty();
    }

    static {
        ClientPackets.register();
        ServerPackets.register();
    }
}

