/*
 * Decompiled with CFR 0.152.
 */
package net.projectile_damage.mixin;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1811;
import net.projectile_damage.api.EntityAttributes_ProjectileDamage;
import net.projectile_damage.api.IProjectileWeapon;
import net.projectile_damage.api.RangedWeaponKind;
import net.projectile_damage.internal.Constants;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={class_1811.class})
abstract class RangedWeaponItemMixin
extends class_1792
implements IProjectileWeapon {
    private Multimap<class_1320, class_1322> attributeModifiers = null;
    private List<class_1304> allowedSlots = List.of(class_1304.field_6173, class_1304.field_6171);
    private Double customLaunchVelocity = null;
    private RangedWeaponKind rangedWeaponKind = RangedWeaponKind.from(this);
    private double projectileDamage = 0.0;

    RangedWeaponItemMixin(class_1792.class_1793 settings) {
        super(settings);
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return this.allowedSlots.contains(slot) && this.attributeModifiers != null ? this.attributeModifiers : super.method_7844(slot);
    }

    @Override
    public void setRangedWeaponKind(RangedWeaponKind kind) {
        this.rangedWeaponKind = kind;
        if (this.projectileDamage == 0.0) {
            this.setProjectileDamage(kind.damage());
        }
    }

    @Override
    public RangedWeaponKind getRangeWeaponKind() {
        return this.rangedWeaponKind;
    }

    @Override
    public void setProjectileDamage(double value, boolean mainHand, boolean offHand) {
        this.allowedSlots = new ArrayList<class_1304>();
        if (mainHand) {
            this.allowedSlots.add(class_1304.field_6173);
        }
        if (offHand) {
            this.allowedSlots.add(class_1304.field_6171);
        }
        this.projectileDamage = value;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)EntityAttributes_ProjectileDamage.GENERIC_PROJECTILE_DAMAGE, (Object)new class_1322(Constants.GENERIC_PROJECTILE_MODIFIER_ID, "Projectile damage", value, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
    }

    @Override
    public double getProjectileDamage() {
        return this.projectileDamage;
    }

    @Override
    public void setCustomLaunchVelocity(Double value) {
        this.customLaunchVelocity = value;
    }

    @Override
    public Double getCustomLaunchVelocity() {
        return this.customLaunchVelocity;
    }
}

