/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl;

import io.gitlab.jfronny.commons.serialize.gson.api.v1.GsonHolders;
import io.gitlab.jfronny.libjf.config.api.v1.Category;
import io.gitlab.jfronny.libjf.config.api.v1.JfConfig;
import io.gitlab.jfronny.libjf.config.api.v1.dsl.CategoryBuilder;
import io.gitlab.jfronny.libjf.gson.FabricLoaderGsonGenerator;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import org.jetbrains.annotations.Nullable;

public class AuxiliaryMetadata {
    public List<String> referencedConfigs;

    public static AuxiliaryMetadata of(Category category) {
        AuxiliaryMetadata meta = new AuxiliaryMetadata();
        if (category != null) {
            meta.referencedConfigs = List.of(category.referencedConfigs());
        }
        return meta.sanitize();
    }

    public static AuxiliaryMetadata of(JfConfig config) {
        AuxiliaryMetadata meta = new AuxiliaryMetadata();
        if (config != null) {
            meta.referencedConfigs = List.of(config.referencedConfigs());
        }
        return meta.sanitize();
    }

    @Nullable
    public static AuxiliaryMetadata forMod(String modId) {
        var metaRef = new Object(){
            AuxiliaryMetadata meta = null;
        };
        FabricLoader.getInstance().getModContainer(modId).ifPresent(container -> {
            CustomValue cv = container.getMetadata().getCustomValue("libjf:config");
            if (cv == null && (cv = container.getMetadata().getCustomValue("libjf")) != null) {
                cv = cv.getAsObject().get("config");
            }
            if (cv != null) {
                metaRef.meta = (AuxiliaryMetadata)GsonHolders.API.getGson().fromJson(FabricLoaderGsonGenerator.toGson((CustomValue)cv), AuxiliaryMetadata.class);
            }
        });
        return metaRef.meta;
    }

    public void applyTo(CategoryBuilder<?> builder) {
        if (this.referencedConfigs != null) {
            this.referencedConfigs.forEach(builder::referenceConfig);
        }
    }

    public AuxiliaryMetadata sanitize() {
        this.referencedConfigs = this.referencedConfigs == null ? List.of() : List.copyOf(this.referencedConfigs);
        return this;
    }

    public AuxiliaryMetadata merge(AuxiliaryMetadata other) {
        if (other == null) {
            return this;
        }
        AuxiliaryMetadata meta = new AuxiliaryMetadata();
        meta.referencedConfigs = new LinkedList<String>();
        meta.referencedConfigs.addAll(this.referencedConfigs);
        meta.referencedConfigs.addAll(other.referencedConfigs);
        return meta.sanitize();
    }
}

