/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.api.v1.type;

import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Type {
    public static Type ofClass(java.lang.reflect.Type klazz) {
        Class k;
        if (klazz == Integer.TYPE || klazz == Integer.class) {
            return TInt.INSTANCE;
        }
        if (klazz == Long.TYPE || klazz == Long.class) {
            return TLong.INSTANCE;
        }
        if (klazz == Float.TYPE || klazz == Float.class) {
            return TFloat.INSTANCE;
        }
        if (klazz == Double.TYPE || klazz == Double.class) {
            return TDouble.INSTANCE;
        }
        if (klazz == String.class) {
            return TString.INSTANCE;
        }
        if (klazz == Boolean.TYPE || klazz == Boolean.class) {
            return TBool.INSTANCE;
        }
        if (klazz instanceof Class && (k = (Class)klazz).isEnum()) {
            return new TEnum(k);
        }
        return new TUnknown(klazz);
    }

    default public boolean isInt() {
        return false;
    }

    default public boolean isLong() {
        return false;
    }

    default public boolean isFloat() {
        return false;
    }

    default public boolean isDouble() {
        return false;
    }

    default public boolean isString() {
        return false;
    }

    default public boolean isBool() {
        return false;
    }

    default public boolean isEnum() {
        return false;
    }

    default public <T> TEnum<T> asEnum() {
        Type type = this;
        if (type instanceof TEnum) {
            TEnum c = (TEnum)type;
            return c;
        }
        throw new ClassCastException("This type is not an enum");
    }

    @Nullable
    public java.lang.reflect.Type asClass();

    public String getName();

    public static final class TInt
    implements Type {
        public static TInt INSTANCE = new TInt();

        private TInt() {
        }

        @Override
        public boolean isInt() {
            return true;
        }

        @Override
        public Class<Integer> asClass() {
            return Integer.class;
        }

        @Override
        public String getName() {
            return "Integer";
        }
    }

    public static final class TLong
    implements Type {
        public static TLong INSTANCE = new TLong();

        private TLong() {
        }

        @Override
        public boolean isLong() {
            return true;
        }

        @Override
        public Class<Long> asClass() {
            return Long.class;
        }

        @Override
        public String getName() {
            return "Long";
        }
    }

    public static final class TFloat
    implements Type {
        public static TFloat INSTANCE = new TFloat();

        private TFloat() {
        }

        @Override
        public boolean isFloat() {
            return true;
        }

        @Override
        public Class<Float> asClass() {
            return Float.class;
        }

        @Override
        public String getName() {
            return "Float";
        }
    }

    public static final class TDouble
    implements Type {
        public static TDouble INSTANCE = new TDouble();

        private TDouble() {
        }

        @Override
        public boolean isDouble() {
            return true;
        }

        @Override
        public Class<Double> asClass() {
            return Double.class;
        }

        @Override
        public String getName() {
            return "Double";
        }
    }

    public static final class TString
    implements Type {
        public static TString INSTANCE = new TString();

        private TString() {
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public Class<String> asClass() {
            return String.class;
        }

        @Override
        public String getName() {
            return "String";
        }
    }

    public static final class TBool
    implements Type {
        public static TBool INSTANCE = new TBool();

        private TBool() {
        }

        @Override
        public boolean isBool() {
            return true;
        }

        @Override
        public Class<Boolean> asClass() {
            return Boolean.class;
        }

        @Override
        public String getName() {
            return "Boolean";
        }
    }

    public record TEnum<T>(@Nullable Class<T> klazz, String name, T[] options) implements Type
    {
        public TEnum(Class<T> klazz) {
            this(klazz, klazz.getSimpleName(), klazz.getEnumConstants());
        }

        public static TEnum<String> create(String name, String[] options) {
            return new TEnum<String>(null, name, options);
        }

        @Override
        public boolean isEnum() {
            return true;
        }

        @Override
        public Class<T> asClass() {
            return this.klazz;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public T optionForString(String string) {
            for (T option : this.options) {
                if (!option.toString().equals(string)) continue;
                return option;
            }
            return null;
        }
    }

    public record TUnknown(java.lang.reflect.Type klazz) implements Type
    {
        @Override
        @Nullable
        public java.lang.reflect.Type asClass() {
            return this.klazz;
        }

        @Override
        public String getName() {
            String string;
            java.lang.reflect.Type type = this.klazz;
            if (type instanceof Class) {
                Class k = (Class)type;
                string = k.getSimpleName();
            } else {
                string = this.klazz.getTypeName();
            }
            return string;
        }
    }
}

