/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.api.v1;

import io.gitlab.jfronny.gson.JsonElement;
import io.gitlab.jfronny.gson.JsonParseException;
import io.gitlab.jfronny.gson.stream.JsonReader;
import io.gitlab.jfronny.gson.stream.JsonTreeReader;
import io.gitlab.jfronny.gson.stream.JsonWriter;
import io.gitlab.jfronny.libjf.config.api.v1.type.Type;
import io.gitlab.jfronny.libjf.config.impl.dsl.DslEntryInfo;
import java.io.IOException;
import java.lang.reflect.Field;
import org.jetbrains.annotations.ApiStatus;

public interface EntryInfo<T> {
    public static EntryInfo<?> ofField(Field field) {
        return DslEntryInfo.ofField(field);
    }

    @ApiStatus.Internal
    public static EntryInfo<?> ofField(Class<?> klazz, String name) {
        try {
            return EntryInfo.ofField(klazz.getField(name));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName();

    public T getDefault();

    public T getValue() throws IllegalAccessException;

    public void setValue(T var1) throws IllegalAccessException;

    public Type getValueType();

    public void fix();

    @Deprecated
    default public void loadFromJson(JsonElement element) throws IllegalAccessException {
        try {
            this.loadFromJson((JsonReader)new JsonTreeReader(element));
        }
        catch (IOException e) {
            throw new JsonParseException("Could not read Json", (Throwable)e);
        }
    }

    public void loadFromJson(JsonReader var1) throws IOException, IllegalAccessException;

    public void writeTo(JsonWriter var1, String var2) throws IOException, IllegalAccessException;

    public int getWidth();

    public double getMinValue();

    public double getMaxValue();

    default public void reset() throws IllegalAccessException {
        this.setValue(this.getDefault());
    }
}

