/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal.impl.mixin;

import com.mojang.authlib.GameProfile;
import io.github.ladysnake.pal.AbilityTracker;
import io.github.ladysnake.pal.PlayerAbility;
import io.github.ladysnake.pal.VanillaAbilities;
import io.github.ladysnake.pal.impl.PalInternals;
import io.github.ladysnake.pal.impl.PlayerAbilityView;
import io.github.ladysnake.pal.impl.VanillaAbilityTracker;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements PlayerAbilityView {
    @Unique
    private final Map<PlayerAbility, AbilityTracker> palAbilities = new LinkedHashMap<PlayerAbility, AbilityTracker>();

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(MinecraftServer server, class_3218 world, GameProfile profile, CallbackInfo ci) {
        PalInternals.populate(this, this.palAbilities);
    }

    @Override
    public Iterable<PlayerAbility> listPalAbilities() {
        return this.palAbilities.keySet();
    }

    @Override
    public AbilityTracker get(PlayerAbility abilityId) {
        return this.palAbilities.get(abilityId);
    }

    @Override
    public void refreshAllPalAbilities(boolean syncVanilla) {
        for (PlayerAbility ability : this.listPalAbilities()) {
            if (ability == VanillaAbilities.FLYING) continue;
            this.get(ability).refresh(false);
        }
        if (syncVanilla) {
            this.method_7355();
        }
    }

    @Inject(method={"copyFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerInteractionManager;setGameMode(Lnet/minecraft/world/GameMode;Lnet/minecraft/world/GameMode;)V", shift=At.Shift.AFTER)})
    private void copyAbilitiesAfterRespawn(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        if (alive) {
            class_2487 nbt = new class_2487();
            ((ServerPlayerEntityMixin)oldPlayer).writeAbilitiesToTag(nbt, null);
            this.readAbilitiesFromTag(nbt, null);
        }
    }

    @Inject(method={"sendAbilitiesUpdate"}, at={@At(value="NEW", target="net/minecraft/network/packet/s2c/play/PlayerAbilitiesS2CPacket")})
    private void checkAbilityConsistency(CallbackInfo ci) {
        for (PlayerAbility ability : this.listPalAbilities()) {
            AbilityTracker tracker = this.get(ability);
            if (!(tracker instanceof VanillaAbilityTracker) || ability == VanillaAbilities.FLYING) continue;
            ((VanillaAbilityTracker)tracker).checkConflict();
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="RETURN")})
    private void writeAbilitiesToTag(class_2487 tag, CallbackInfo ci) {
        class_2499 list = new class_2499();
        for (Map.Entry<PlayerAbility, AbilityTracker> entry : this.palAbilities.entrySet()) {
            class_2487 abilityTag = new class_2487();
            abilityTag.method_10582("ability_id", entry.getKey().getId().toString());
            entry.getValue().save(abilityTag);
            list.add((Object)abilityTag);
        }
        tag.method_10566("playerabilitylib:abilities", (class_2520)list);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V", shift=At.Shift.AFTER)})
    private void readAbilitiesFromTag(class_2487 tag, CallbackInfo ci) {
        for (class_2520 t : tag.method_10554("playerabilitylib:abilities", 10)) {
            class_2487 abilityTag = (class_2487)t;
            if (!abilityTag.method_10573("ability_id", 8)) continue;
            String abilityId = abilityTag.method_10558("ability_id");
            AbilityTracker tracker = this.palAbilities.get(PalInternals.getAbility(class_2960.method_12829((String)abilityId)));
            if (tracker != null) {
                tracker.load(abilityTag);
                continue;
            }
            PalInternals.LOGGER.warn("Encountered unknown ability {} while deserializing data for {}", (Object)abilityId, (Object)this);
        }
    }
}

