/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_5242;

public class CUuidArgumentType
implements ArgumentType<UUID> {
    public static final SimpleCommandExceptionType INVALID_UUID = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.uuid.invalid"));
    private static final Collection<String> EXAMPLES = List.of("dd12be42-52a9-4a91-a8a1-11c01849e498");
    private static final Pattern VALID_CHARACTERS = Pattern.compile("^([-A-Fa-f0-9]+)");

    public static class_5242 uuid() {
        return new class_5242();
    }

    public static UUID getCUuid(CommandContext<FabricClientCommandSource> context, String name) {
        return (UUID)context.getArgument(name, UUID.class);
    }

    public UUID parse(StringReader stringReader) throws CommandSyntaxException {
        String string = stringReader.getRemaining();
        Matcher matcher = VALID_CHARACTERS.matcher(string);
        if (matcher.find()) {
            String match = matcher.group(1);
            try {
                UUID uuid = UUID.fromString(match);
                stringReader.setCursor(stringReader.getCursor() + match.length());
                return uuid;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw INVALID_UUID.create();
    }

    public String toString() {
        return "uuid()";
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

