/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class CTimeArgumentType
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0d", "0s", "0t", "0");
    private static final SimpleCommandExceptionType INVALID_UNIT_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.time.invalid_unit"));
    private static final Dynamic2CommandExceptionType TICK_COUNT_TOO_LOW_EXCEPTION = new Dynamic2CommandExceptionType((value, minimum) -> class_2561.method_43469((String)"argument.time.tick_count_too_low", (Object[])new Object[]{minimum, value}));
    private static final Object2IntMap<String> UNITS = new Object2IntOpenHashMap();
    final int minimum;

    private CTimeArgumentType(int minimum) {
        this.minimum = minimum;
    }

    public static CTimeArgumentType time() {
        return new CTimeArgumentType(0);
    }

    public static CTimeArgumentType time(int minimum) {
        return new CTimeArgumentType(minimum);
    }

    public static Integer getCTime(CommandContext<FabricClientCommandSource> context, String name) {
        return (Integer)context.getArgument(name, Integer.class);
    }

    public Integer parse(StringReader stringReader) throws CommandSyntaxException {
        float time = stringReader.readFloat();
        String unit = stringReader.readUnquotedString();
        int unitFactor = UNITS.getOrDefault((Object)unit, 0);
        if (unitFactor == 0) {
            throw INVALID_UNIT_EXCEPTION.create();
        }
        int ticks = Math.round(time * (float)unitFactor);
        if (ticks < this.minimum) {
            throw TICK_COUNT_TOO_LOW_EXCEPTION.create((Object)ticks, (Object)this.minimum);
        }
        return ticks;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader stringReader = new StringReader(builder.getRemaining());
        try {
            stringReader.readFloat();
        }
        catch (CommandSyntaxException var5) {
            return builder.buildFuture();
        }
        return class_2172.method_9265((Iterable)UNITS.keySet(), (SuggestionsBuilder)builder.createOffset(builder.getStart() + stringReader.getCursor()));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    static {
        UNITS.put((Object)"d", 24000);
        UNITS.put((Object)"s", 20);
        UNITS.put((Object)"t", 1);
        UNITS.put((Object)"", 1);
    }
}

