/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.clientarguments.arguments.CEntityArgumentType;
import dev.xpple.clientarguments.arguments.CEntitySelector;
import dev.xpple.clientarguments.arguments.CEntitySelectorReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_269;

public class CScoreHolderArgumentType
implements ArgumentType<ScoreHolder> {
    public static final SuggestionProvider<FabricClientCommandSource> SUGGESTION_PROVIDER = (context, builder) -> {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        CEntitySelectorReader entitySelectorReader = new CEntitySelectorReader(stringReader);
        try {
            entitySelectorReader.read();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return entitySelectorReader.listSuggestions(builder, builderx -> class_2172.method_9265((Iterable)((FabricClientCommandSource)context.getSource()).method_9262(), (SuggestionsBuilder)builderx));
    };
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "*", "@e");
    private static final SimpleCommandExceptionType EMPTY_SCORE_HOLDER_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.scoreHolder.empty"));
    final boolean multiple;

    public CScoreHolderArgumentType(boolean multiple) {
        this.multiple = multiple;
    }

    public static CScoreHolderArgumentType scoreHolder() {
        return new CScoreHolderArgumentType(false);
    }

    public static CScoreHolderArgumentType scoreHolders() {
        return new CScoreHolderArgumentType(true);
    }

    public static String getCScoreHolder(CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        return CScoreHolderArgumentType.getCScoreHolders(context, name).iterator().next();
    }

    public static Collection<String> getCScoreHolders(CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        return CScoreHolderArgumentType.getCScoreHolders(context, name, Collections::emptyList);
    }

    public static Collection<String> getCScoreboardScoreHolders(CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        class_269 scoreboard = ((FabricClientCommandSource)context.getSource()).getWorld().method_8428();
        Objects.requireNonNull(scoreboard);
        return CScoreHolderArgumentType.getCScoreHolders(context, name, () -> ((class_269)scoreboard).method_1178());
    }

    public static Collection<String> getCScoreHolders(CommandContext<FabricClientCommandSource> context, String name, Supplier<Collection<String>> players) throws CommandSyntaxException {
        Collection<String> collection = ((ScoreHolder)context.getArgument(name, ScoreHolder.class)).getNames((FabricClientCommandSource)context.getSource(), players);
        if (collection.isEmpty()) {
            throw CEntityArgumentType.ENTITY_NOT_FOUND_EXCEPTION.create();
        }
        return collection;
    }

    public ScoreHolder parse(StringReader stringReader) throws CommandSyntaxException {
        if (stringReader.canRead() && stringReader.peek() == '@') {
            CEntitySelectorReader entitySelectorReader = new CEntitySelectorReader(stringReader);
            CEntitySelector entitySelector = entitySelectorReader.read();
            if (!this.multiple && entitySelector.getLimit() > 1) {
                throw CEntityArgumentType.TOO_MANY_ENTITIES_EXCEPTION.create();
            }
            return new SelectorScoreHolder(entitySelector);
        }
        int cursor = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            stringReader.skip();
        }
        String string = stringReader.getString().substring(cursor, stringReader.getCursor());
        if (string.equals("*")) {
            return (FabricClientCommandSource2, supplier) -> {
                Collection collection = (Collection)supplier.get();
                if (collection.isEmpty()) {
                    throw EMPTY_SCORE_HOLDER_EXCEPTION.create();
                }
                return collection;
            };
        }
        Set<String> collection = Collections.singleton(string);
        return (FabricClientCommandSource2, supplier) -> collection;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @FunctionalInterface
    public static interface ScoreHolder {
        public Collection<String> getNames(FabricClientCommandSource var1, Supplier<Collection<String>> var2) throws CommandSyntaxException;
    }

    public static class SelectorScoreHolder
    implements ScoreHolder {
        private final CEntitySelector selector;

        public SelectorScoreHolder(CEntitySelector selector) {
            this.selector = selector;
        }

        @Override
        public Collection<String> getNames(FabricClientCommandSource FabricClientCommandSource2, Supplier<Collection<String>> supplier) throws CommandSyntaxException {
            List<? extends class_1297> list = this.selector.getEntities(FabricClientCommandSource2);
            if (list.isEmpty()) {
                throw CEntityArgumentType.ENTITY_NOT_FOUND_EXCEPTION.create();
            }
            ArrayList list2 = Lists.newArrayList();
            for (class_1297 class_12972 : list) {
                list2.add(class_12972.method_5820());
            }
            return list2;
        }
    }
}

